/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.topology.grid.GridPopulation;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.LayerData;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.matrix.GamaFloatMatrix;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.Types;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.util.Collection;

public class GridLayerData
extends LayerData {
    static GamaColor defaultLineColor = GamaColor.get(Color.black);
    GridPopulation grid;
    final String name;
    Boolean turnGridOn;
    private final boolean shouldComputeImage;
    AttributeHolder.Attribute<GamaColor> line;
    AttributeHolder.Attribute<IImageProvider> texture;
    AttributeHolder.Attribute<double[]> elevation;
    AttributeHolder.Attribute<Boolean> smooth;
    AttributeHolder.Attribute<Boolean> triangulation;
    AttributeHolder.Attribute<Boolean> grayscale;
    AttributeHolder.Attribute<Boolean> text;
    AttributeHolder.Attribute<Boolean> wireframe;
    BufferedImage image;
    private final GamaPoint dim = new GamaPoint();

    public GridLayerData(ILayerStatement iLayerStatement) throws GamaRuntimeException {
        super(iLayerStatement);
        this.shouldComputeImage = !iLayerStatement.hasFacet("hexagonal");
        this.name = iLayerStatement.getFacet("species").literalValue();
        this.line = this.create("border", Types.COLOR, null);
        this.wireframe = this.create("wireframe", Types.BOOL, false);
        this.turnGridOn = iLayerStatement.hasFacet("border");
        this.elevation = this.create("elevation", (IScope iScope, IExpression iExpression) -> {
            if (iExpression != null) {
                switch (iExpression.getGamlType().id()) {
                    case 8: {
                        return GamaFloatMatrix.from(iScope, Cast.asMatrix(iScope, iExpression.value(iScope))).getMatrix();
                    }
                    case 1: 
                    case 2: {
                        return this.grid.getTopology().getPlaces().getGridValueOf(iScope, iExpression);
                    }
                    case 3: {
                        if (((Boolean)iExpression.value(iScope)).booleanValue()) {
                            return this.grid.getTopology().getPlaces().getGridValue();
                        }
                        return null;
                    }
                }
            }
            return null;
        }, Types.NO_TYPE, null);
        this.triangulation = this.create("triangulation", Types.BOOL, false);
        this.smooth = this.create("smooth", Types.BOOL, false);
        this.grayscale = this.create("grayscale", Types.BOOL, false);
        this.text = this.create("text", Types.BOOL, false);
        this.texture = this.create("texture", (IScope iScope, IExpression iExpression) -> {
            Object object = iExpression.value(iScope);
            if (object instanceof IImageProvider) {
                return (IImageProvider)iExpression.value(iScope);
            }
            throw GamaRuntimeException.error("The texture of a grid must be an image or an image file", iScope);
        }, Types.FILE, null);
    }

    @Override
    public boolean compute(IScope iScope, IGraphics iGraphics) throws GamaRuntimeException {
        if (this.grid == null) {
            IPopulation<? extends IAgent> iPopulation = iScope.getAgent().getPopulationFor(this.name);
            if (iPopulation == null) {
                throw GamaRuntimeException.error("No grid species named " + this.name + " can be found", iScope);
            }
            if (!iPopulation.isGrid()) {
                throw GamaRuntimeException.error("Species named " + this.name + " is not a grid", iScope);
            }
            this.grid = (GridPopulation)iPopulation;
            this.dim.setLocation(this.grid.getTopology().getPlaces().getDimensions());
        }
        boolean bl = super.compute(iScope, iGraphics);
        if (this.shouldComputeImage) {
            this.computeImage(iScope, iGraphics);
        }
        return bl;
    }

    public Boolean isTriangulated() {
        return this.triangulation.get();
    }

    public Boolean isGrayScaled() {
        return this.grayscale.get();
    }

    public Boolean isShowText() {
        return this.text.get();
    }

    public IImageProvider textureFile() {
        return this.texture.get();
    }

    public GamaColor getLineColor() {
        return this.line.get() == null ? defaultLineColor : this.line.get();
    }

    public boolean drawLines() {
        return this.line.get() != null && this.turnGridOn != false;
    }

    public void setDrawLines(Boolean bl) {
        this.turnGridOn = bl;
        if (bl.booleanValue() && this.line.get() == null) {
            this.line = this.create("border", Types.COLOR, defaultLineColor);
        }
    }

    public IGrid getGrid() {
        return this.grid.getTopology().getPlaces();
    }

    public Collection<IAgent> getAgentsToDisplay() {
        return (Collection)((Object)this.grid.getAgents(null));
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Boolean isWireframe() {
        return this.wireframe.get();
    }

    private void setImage(BufferedImage bufferedImage) {
        if (this.image != null) {
            this.image.flush();
        }
        this.image = bufferedImage;
    }

    protected void computeImage(IScope iScope, IGraphics iGraphics) {
        if (this.image == null) {
            this.image = AbstractDisplayGraphics.createCompatibleImage((int)this.dim.getX(), (int)this.dim.getY());
        }
    }

    public double[] getElevationMatrix(IScope iScope) {
        return this.elevation.get();
    }

    public GamaPoint getDimensions() {
        return this.dim;
    }

    public Boolean isSmooth() {
        return this.smooth.get();
    }

    public void reset() {
        this.setImage(null);
    }
}

