/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.Scaling3D;
import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.IImageProvider;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.AbstractLayer;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.ImageLayerData;
import gama.core.outputs.layers.ImageLayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.IGamaFile;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.draw.AssetDrawingAttributes;
import gama.gaml.types.GamaFileType;

public class ImageLayer
extends AbstractLayer {
    Envelope3D env;
    IImageProvider cachedImageProvider;
    IExpression providerExpression;
    boolean isProviderPotentiallyVariable;
    boolean isImageProvider;

    public ImageLayer(IScope iScope, ILayerStatement iLayerStatement) {
        super(iLayerStatement);
        this.providerExpression = ((ImageLayerStatement)this.definition).imageExpression;
        this.isImageProvider = this.isImageProvider(iScope);
        boolean bl = this.isProviderPotentiallyVariable = !this.providerExpression.isContextIndependant();
        if (!this.isImageProvider) {
            if (this.providerExpression.isConst() || !this.isProviderPotentiallyVariable) {
                Object object = this.providerExpression.value(iScope);
                if (object instanceof String) {
                    String string = (String)object;
                    this.cachedImageProvider = this.createFileFromString(iScope, string);
                } else if (object instanceof IImageProvider) {
                    IImageProvider iImageProvider;
                    this.cachedImageProvider = iImageProvider = (IImageProvider)object;
                } else {
                    String string = Cast.asString(iScope, object);
                    this.cachedImageProvider = this.createFileFromString(iScope, string);
                }
                this.isImageProvider = true;
            }
        } else if (!this.isProviderPotentiallyVariable) {
            this.cachedImageProvider = this.getImageFromProvider(iScope, this.providerExpression.value(iScope));
            this.isImageProvider = true;
        }
    }

    private boolean isImageProvider(IScope iScope) {
        Class<?> clazz = this.providerExpression.value(iScope).getClass();
        return IImageProvider.class.isAssignableFrom(clazz);
    }

    @Override
    protected ILayerData createData() {
        return new ImageLayerData(this.definition);
    }

    private IImageProvider createFileFromString(IScope iScope, String string) {
        IGamaFile iGamaFile = GamaFileType.createFile(iScope, string, false, null);
        return this.getImageFromProvider(iScope, iGamaFile);
    }

    private IImageProvider getImageFromProvider(IScope iScope, Object object) throws GamaRuntimeException.GamaRuntimeFileException, GamaRuntimeException {
        if (object == this.cachedImageProvider) {
            return this.cachedImageProvider;
        }
        if (!(object instanceof IImageProvider)) {
            throw GamaRuntimeException.error("Not a provider of images: " + this.providerExpression.serializeToGaml(false), iScope);
        }
        IImageProvider iImageProvider = (IImageProvider)object;
        try {
            iImageProvider.getImage(iScope, this.getData().getRefresh() == false);
        }
        catch (GamaRuntimeException.GamaRuntimeFileException gamaRuntimeFileException) {
            throw gamaRuntimeFileException;
        }
        catch (Throwable throwable) {
            throw GamaRuntimeException.create(throwable, iScope);
        }
        this.cachedImageProvider = iImageProvider;
        this.env = this.computeEnvelope(iScope, iImageProvider);
        return iImageProvider;
    }

    private Envelope3D computeEnvelope(IScope iScope, IImageProvider iImageProvider) {
        IGamaFile iGamaFile;
        if (iImageProvider instanceof IGamaFile && (iGamaFile = (IGamaFile)((Object)iImageProvider)).hasGeoDataAvailable(iScope)) {
            return iImageProvider.computeEnvelope(iScope);
        }
        return iScope.getSimulation().getEnvelope();
    }

    protected IImageProvider buildImage(IScope iScope) {
        if (!this.isProviderPotentiallyVariable) {
            return this.cachedImageProvider;
        }
        return this.isImageProvider ? this.getImageFromProvider(iScope, this.providerExpression.value(iScope)) : this.createFileFromString(iScope, Cast.asString(iScope, this.providerExpression.value(iScope)));
    }

    @Override
    public void privateDraw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) {
        AssetDrawingAttributes assetDrawingAttributes = new AssetDrawingAttributes(null, true);
        assetDrawingAttributes.setUseCache(this.getData().getRefresh() == false);
        IImageProvider iImageProvider = this.buildImage(iGraphicsScope);
        if (this.env != null) {
            GamaPoint gamaPoint = iGraphics.is2D() ? new GamaPoint(this.env.getMinX(), this.env.getMinY()) : new GamaPoint(this.env.getMinX() + this.env.getWidth() / 2.0, this.env.getMinY() + this.env.getHeight() / 2.0);
            assetDrawingAttributes.setLocation(gamaPoint);
            assetDrawingAttributes.setSize(Scaling3D.of(this.env.getWidth(), this.env.getHeight(), 0.0));
        }
        if (iImageProvider != null) {
            iGraphics.drawAsset(iImageProvider, assetDrawingAttributes);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        this.cachedImageProvider = null;
        this.env = null;
    }

    @Override
    public String getType() {
        return "Image layer";
    }
}

