/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.properties;

import gama.core.common.geometry.Rotation3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.outputs.layers.properties.AbstractDefinition;
import gama.core.outputs.layers.properties.RotationStatement;
import gama.core.runtime.IScope;
import gama.gaml.statements.draw.AttributeHolder;
import gama.gaml.types.Types;

public class RotationDefinition
extends AbstractDefinition {
    final AttributeHolder.Attribute<GamaPoint> locationAttribute;
    final AttributeHolder.Attribute<GamaPoint> axisAttribute;
    AttributeHolder.Attribute<Double> angleAttribute;
    final AttributeHolder.Attribute<Double> initialAngleAttribute;

    public RotationDefinition(RotationStatement rotationStatement) {
        super(rotationStatement);
        this.locationAttribute = this.create("location", rotationStatement.hasFacet("location") ? rotationStatement.getFacet("location") : iScope -> iScope.getSimulation().getCentroid(), Types.POINT, null);
        this.axisAttribute = this.create("axis", Types.POINT, Rotation3D.PLUS_K);
        this.initialAngleAttribute = this.create("angle", Types.FLOAT, 0.0);
        this.angleAttribute = this.initialAngleAttribute;
    }

    @Override
    public void update(IScope iScope) {
        this.angleAttribute = new AttributeHolder.ConstantAttribute<Double>(this.angleAttribute.get() + this.initialAngleAttribute.get());
    }

    public Double getAngleDelta() {
        return this.initialAngleAttribute.get();
    }

    public Double getCurrentAngle() {
        return this.angleAttribute.get();
    }

    @Override
    public Boolean isDynamic() {
        return (Boolean)this.dynamic.get();
    }

    public GamaPoint getCenter() {
        return this.locationAttribute.get();
    }

    public GamaPoint getAxis() {
        return this.axisAttribute.get();
    }

    @Override
    public void reset() {
        this.angleAttribute = this.initialAngleAttribute;
    }

    public void setAngle(double d) {
        this.angleAttribute = new AttributeHolder.ConstantAttribute<Double>(d);
    }

    public void setDynamic(boolean bl) {
        this.dynamic = new AttributeHolder.ConstantAttribute<Boolean>(bl);
    }

    @Override
    protected boolean getDefaultDynamicValue() {
        return false;
    }
}

