/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.matrix.IMatrix;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import one.util.streamex.StreamEx;

public interface IContainer<KeyType, ValueType>
extends IValue {
    public IContainerType<?> getGamlType();

    public IList<ValueType> listValue(IScope var1, IType<?> var2, boolean var3);

    public IMatrix<?> matrixValue(IScope var1, IType<?> var2, boolean var3);

    public IMatrix<?> matrixValue(IScope var1, IType<?> var2, GamaPoint var3, boolean var4);

    public <D, C> IMap<C, D> mapValue(IScope var1, IType<C> var2, IType<D> var3, boolean var4);

    public Iterable<? extends ValueType> iterable(IScope var1);

    default public StreamEx<ValueType> stream(IScope iScope) {
        if (this instanceof Collection) {
            return StreamEx.of(((Collection)((Object)this)).stream());
        }
        return StreamEx.of(this.listValue(iScope, Types.NO_TYPE, false));
    }

    default public StreamEx<ValueType> parallelStream(IScope iScope) {
        return (StreamEx)this.stream(iScope).parallel(GamaExecutorService.AGENT_PARALLEL_EXECUTOR);
    }

    @GamlAnnotations.operator(value={"contains", "contains_value"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="true, if the container contains the right operand, false otherwise. 'contains' can also be written 'contains_value'. On graphs, it is equivalent to calling 'contains_edge'", masterDoc=true, comment="the contains operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list or a matrix, contains returns true if the list or matrix contains the right operand", examples={@GamlAnnotations.example(value="[1, 2, 3] contains 2", equals="true"), @GamlAnnotations.example(value="[{1,2}, {3,4}, {5,6}] contains {3,4}", equals="true")}), @GamlAnnotations.usage(value="if it is a map, contains, which can also be written 'contains_value', returns true if the operand is a value of the map"), @GamlAnnotations.usage(value="if it is a pair, contains_key returns true if the operand is equal to the value of the pair"), @GamlAnnotations.usage(value="if it is a file, contains returns true it the operand is contained in the file content"), @GamlAnnotations.usage(value="if it is a population, contains returns true if the operand is an agent of the population, false otherwise"), @GamlAnnotations.usage(value="if it is a graph, contains can be written 'contains_edge' and  returns true if the operand is an edge of the graph, false otherwise (use 'contains_node' for testing the presence of a node)")}, see={"contains_all", "contains_any", "contains_key"})
    @GamlAnnotations.test(value="['aa'::'bb', 13::14] contains 'bb'")
    public boolean contains(IScope var1, Object var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"contains_key", "contains_node"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="true, if the left-hand operand -- the container -- contains a key -- or an index -- equal to the right-hand operand, false otherwise. On graphs, 'contains_key' is equivalent to calling 'contains_vertex' ", masterDoc=true, comment="the behavior of contains_key depends on the nature of the container", usages={@GamlAnnotations.usage(value="if it is a list, contains_key returns true if the right-hand operand is an integer and if it is a valid index (i.e. >= 0 and < length)", examples={@GamlAnnotations.example(isExecutable=true, value="[1, 2, 3] contains_key 3", equals="false"), @GamlAnnotations.example(isExecutable=true, value="[{1,2}, {3,4}, {5,6}] contains_key 0", equals="true")}), @GamlAnnotations.usage(value="if it is a map, contains_key returns true if the operand is a key of the map"), @GamlAnnotations.usage(value="if it is a pair, contains_key returns true if the operand is equal to the key of the pair"), @GamlAnnotations.usage(value="if it is a matrix, contains_key returns true if the point operand is a valid index of the matrix (i.e. >= {0,0} and < {rows, col})"), @GamlAnnotations.usage(value="if it is a file, contains_key is applied to the file contents -- a container"), @GamlAnnotations.usage(value="if it is a graph, contains_key returns true if the graph contains the corresponding vertex")}, see={"contains_all", "contains", "contains_any"})
    @GamlAnnotations.test(value="['aa'::'bb', 13::14] contains_key 'aa'")
    public boolean containsKey(IScope var1, Object var2) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"first"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the first value of the operand", masterDoc=true, comment="the first operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list, first returns the first element of the list, or nil if the list is empty", examples={@GamlAnnotations.example(value="first ([1, 2, 3])", returnType="int", equals="1")}), @GamlAnnotations.usage(value="if it is a map, first returns the first value of the first pair (in insertion order)"), @GamlAnnotations.usage(value="if it is a file, first returns the first element of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a population, first returns the first agent of the population"), @GamlAnnotations.usage(value="if it is a graph, first returns the first edge (in creation order)"), @GamlAnnotations.usage(value="if it is a matrix, first returns the element at {0,0} in the matrix"), @GamlAnnotations.usage(value="for a matrix of int or float, it will return 0 if the matrix is empty"), @GamlAnnotations.usage(value="for a matrix of object or geometry, it will return nil if the matrix is empty")}, see={"last"})
    public ValueType firstValue(IScope var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"last"}, can_be_const=true, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the last element of the operand", masterDoc=true, comment="the last operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list, last returns the last element of the list, or nil if the list is empty", examples={@GamlAnnotations.example(value="last ([1, 2, 3])", returnType="int", equals="3")}), @GamlAnnotations.usage(value="if it is a map, last returns the value of the last pair (in insertion order)"), @GamlAnnotations.usage(value="if it is a file, last returns the last element of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a population, last returns the last agent of the population"), @GamlAnnotations.usage(value="if it is a graph, last returns a list containing the last edge created"), @GamlAnnotations.usage(value="if it is a matrix, last returns the element at {length-1,length-1} in the matrix"), @GamlAnnotations.usage(value="for a matrix of int or float, it will return 0 if the matrix is empty"), @GamlAnnotations.usage(value="for a matrix of object or geometry, it will return nil if the matrix is empty")}, see={"first"})
    public ValueType lastValue(IScope var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"length"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the number of elements contained in the operand", masterDoc=true, comment="the length operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list or a map, length returns the number of elements in the list or map", examples={@GamlAnnotations.example(value="length([12,13])", equals="2"), @GamlAnnotations.example(value="length([])", equals="0")}), @GamlAnnotations.usage(value="if it is a population, length returns number of agents of the population"), @GamlAnnotations.usage(value="if it is a graph, length returns the number of vertexes or of edges (depending on the way it was created)"), @GamlAnnotations.usage(value="if it is a matrix, length returns the number of cells", examples={@GamlAnnotations.example(value="length(matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]]))", equals="6")})})
    public int length(IScope var1);

    @Override
    default public int intValue(IScope iScope) {
        return this.length(iScope);
    }

    @GamlAnnotations.operator(value={"empty"}, can_be_const=true, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="true if the operand is empty, false otherwise.", masterDoc=true, comment="the empty operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list, empty returns true if there is no element in the list, and false otherwise", examples={@GamlAnnotations.example(value="empty([])", equals="true")}), @GamlAnnotations.usage(value="if it is a map, empty returns true if the map contains no key-value mappings, and false otherwise"), @GamlAnnotations.usage(value="if it is a file, empty returns true if the content of the file (that is also a container) is empty, and false otherwise"), @GamlAnnotations.usage(value="if it is a population, empty returns true if there is no agent in the population, and false otherwise"), @GamlAnnotations.usage(value="if it is a graph, empty returns true if it contains no vertex and no edge, and false otherwise"), @GamlAnnotations.usage(value="if it is a matrix of int, float or object, it will return true if all elements are respectively 0, 0.0 or null, and false otherwise"), @GamlAnnotations.usage(value="if it is a matrix of geometry, it will return true if the matrix contains no cell, and false otherwise")})
    public boolean isEmpty(IScope var1);

    @GamlAnnotations.operator(value={"reverse"}, can_be_const=true, type=-199, content_type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="the operand elements in the reversed order in a copy of the operand.", masterDoc=true, comment="the reverse operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if it is a list, reverse returns a copy of the operand list with elements in the reversed order", examples={@GamlAnnotations.example(value="reverse ([10,12,14])", equals="[14, 12, 10]", returnType="list<int>")}), @GamlAnnotations.usage(value="if it is a map, reverse returns a copy of the operand map with each pair in the reversed order (i.e. all keys become values and values become keys)", examples={@GamlAnnotations.example(value="reverse (['k1'::44, 'k2'::32, 'k3'::12])", equals="[44::'k1', 32::'k2', 12::'k3']", returnType="map<int,string>")}), @GamlAnnotations.usage(value="if it is a file, reverse returns a copy of the file with a reversed content"), @GamlAnnotations.usage(value="if it is a population, reverse returns a copy of the population with elements in the reversed order"), @GamlAnnotations.usage(value="if it is a graph, reverse returns a copy of the graph (with all edges and vertexes), with all of the edges reversed"), @GamlAnnotations.usage(value="if it is a matrix, reverse returns a new matrix containing the transpose of the operand.", examples={@GamlAnnotations.example(returnType="matrix<string>", value="reverse(matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]]))", equals="matrix([[\"c11\",\"c21\"],[\"c12\",\"c22\"],[\"c13\",\"c23\"]])")})})
    public IContainer<?, ?> reverse(IScope var1) throws GamaRuntimeException;

    @GamlAnnotations.operator(value={"one_of", "any"}, can_be_const=false, type=-299, category={"Containers-related operators"}, concept={"container"})
    @GamlAnnotations.doc(value="one of the values stored in this container  at a random key", masterDoc=true, comment="the one_of operator behavior depends on the nature of the operand", usages={@GamlAnnotations.usage(value="if the operand is empty, one_of returns nil"), @GamlAnnotations.usage(value="if it is a list or a matrix, one_of returns one of the values of the list or of the matrix", examples={@GamlAnnotations.example(value="any ([1,2,3])", var="i", equals="1, 2 or 3", returnType="int", test=false), @GamlAnnotations.example(value="string sMat <- one_of(matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]])); \t// sMat equals \"c11\",\"c12\",\"c13\", \"c21\",\"c22\" or \"c23\"")}), @GamlAnnotations.usage(value="if it is a map, one_of returns one the value of a random pair of the map", examples={@GamlAnnotations.example(value="int im <- one_of ([2::3, 4::5, 6::7]);\t// im equals 3, 5 or 7"), @GamlAnnotations.example(value="[2::3, 4::5, 6::7].values contains im", returnType="bool", equals="true")}), @GamlAnnotations.usage(value="if it is a graph, one_of returns one of the lists of edges"), @GamlAnnotations.usage(value="if it is a file, one_of returns one of the elements of the content of the file (that is also a container)"), @GamlAnnotations.usage(value="if it is a population, one_of returns one of the agents of the population", examples={@GamlAnnotations.example(value="bug b <- one_of(bug);  \t// Given a previously defined species bug, b is one of the created bugs, e.g. bug3", isExecutable=false)})}, see={"contains"})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="one_of([]) = nil"), @GamlAnnotations.test(value="int i  <- any([1,2,3]); [1,2,3] contains i"), @GamlAnnotations.test(value="string sMat <- one_of(matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]])); matrix([[\"c11\",\"c12\",\"c13\"],[\"c21\",\"c22\",\"c23\"]]) contains sMat"), @GamlAnnotations.test(value="agent b <- one_of(agents);")})
    public ValueType anyValue(IScope var1);

    public static interface Addressable<KeyType, ValueType> {
        public ValueType get(IScope var1, KeyType var2) throws GamaRuntimeException;

        public ValueType getFromIndicesList(IScope var1, IList<KeyType> var2) throws GamaRuntimeException;
    }

    public static interface Modifiable<KeyType, ValueType> {
        public void addValue(IScope var1, ValueType var2);

        public void addValueAtIndex(IScope var1, Object var2, ValueType var3);

        public void setValueAtIndex(IScope var1, Object var2, ValueType var3);

        public void addValues(IScope var1, Object var2, IContainer<?, ?> var3);

        default public void addValues(IScope iScope, IContainer<?, ?> iContainer) {
            this.addValues(iScope, null, iContainer);
        }

        public void setAllValues(IScope var1, ValueType var2);

        public void removeValue(IScope var1, Object var2);

        public void removeIndex(IScope var1, Object var2);

        public void removeIndexes(IScope var1, IContainer<?, ?> var2);

        public void removeValues(IScope var1, IContainer<?, ?> var2);

        public void removeAllOccurrencesOfValue(IScope var1, Object var2);
    }
}

