/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.descriptions;

import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlProperties;
import gama.core.common.interfaces.IKeyword;
import gama.core.common.util.StringUtils;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.operators.Strings;
import gama.gaml.statements.Arguments;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class SymbolSerializer<C extends SymbolDescription>
implements IKeyword {
    public static final Set<String> uselessFacets = new HashSet<String>(Arrays.asList("internal_function", "with"));

    protected SymbolSerializer() {
    }

    public final String serialize(SymbolDescription symbolDescription, boolean bl) {
        if (symbolDescription.isBuiltIn() && !bl) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        this.serialize(symbolDescription, stringBuilder, bl);
        return stringBuilder.toString();
    }

    public final void serializeNoRecursion(StringBuilder stringBuilder, IDescription iDescription, boolean bl) {
        this.serializeKeyword((SymbolDescription)iDescription, stringBuilder, bl);
        this.serializeFacets((SymbolDescription)iDescription, stringBuilder, bl);
    }

    protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
        this.serializeKeyword(symbolDescription, stringBuilder, bl);
        this.serializeFacets(symbolDescription, stringBuilder, bl);
        this.serializeChildren(symbolDescription, stringBuilder, bl);
    }

    protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
        stringBuilder.append(symbolDescription.getKeyword()).append(' ');
    }

    protected void serializeChildren(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
        StringBuilder stringBuilder2 = new StringBuilder();
        symbolDescription.visitChildren(iDescription -> {
            this.serializeChild((IDescription)iDescription, stringBuilder2, bl);
            return true;
        });
        if (stringBuilder2.length() == 0) {
            stringBuilder.append(';');
        } else {
            stringBuilder.append(' ').append('{').append(Strings.LN);
            stringBuilder.append((CharSequence)stringBuilder2);
            stringBuilder.append('}').append(Strings.LN);
        }
    }

    protected void serializeChild(IDescription iDescription, StringBuilder stringBuilder, boolean bl) {
        String string = iDescription.serializeToGaml(false);
        if (string != null && string.length() > 0) {
            stringBuilder.append(Strings.indent(iDescription.serializeToGaml(bl), 1)).append(Strings.LN);
        }
    }

    protected void serializeFacets(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
        String string = DescriptionFactory.getOmissibleFacetForSymbol(symbolDescription.getKeyword());
        String string3 = this.serializeFacetValue(symbolDescription, string, bl);
        if (string3 != null) {
            stringBuilder.append(string3).append(" ");
        }
        symbolDescription.visitFacets((string2, iExpressionDescription) -> {
            if (string2.equals(string)) {
                return true;
            }
            String string3 = this.serializeFacetValue(symbolDescription, (String)string2, bl);
            if (string3 != null) {
                stringBuilder.append(this.serializeFacetKey(symbolDescription, (String)string2, bl)).append(string3).append(" ");
            }
            return true;
        });
    }

    protected String serializeFacetKey(SymbolDescription symbolDescription, String string, boolean bl) {
        return string + ": ";
    }

    protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
        boolean bl2;
        if (uselessFacets.contains(string)) {
            return null;
        }
        IExpressionDescription iExpressionDescription = symbolDescription.getFacet(string);
        if (iExpressionDescription == null) {
            return null;
        }
        String string2 = iExpressionDescription.serializeToGaml(bl);
        if (string2.startsWith("_internal_")) {
            return null;
        }
        if (iExpressionDescription instanceof LabelExpressionDescription && !(bl2 = symbolDescription.getMeta().isId(string))) {
            string2 = StringUtils.toGamlString(string2);
        }
        return string2;
    }

    protected void collectMetaInformation(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
        this.collectMetaInformationInSymbol(symbolDescription, gamlProperties);
        this.collectMetaInformationInFacets(symbolDescription, gamlProperties);
        this.collectMetaInformationInChildren(symbolDescription, gamlProperties);
        symbolDescription.getGamlType().collectMetaInformation(gamlProperties);
    }

    protected void collectMetaInformationInSymbol(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
        gamlProperties.put("plugins", symbolDescription.getDefiningPlugin());
        gamlProperties.put("statements", symbolDescription.getKeyword());
    }

    protected void collectMetaInformationInFacets(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
        symbolDescription.visitFacets((string, iExpressionDescription) -> {
            this.collectMetaInformationInFacetValue(symbolDescription, (String)string, gamlProperties);
            return true;
        });
    }

    protected void collectMetaInformationInFacetValue(SymbolDescription symbolDescription, String string, GamlProperties gamlProperties) {
        IExpression iExpression = symbolDescription.getFacetExpr(string);
        if (iExpression != null) {
            iExpression.collectMetaInformation(gamlProperties);
        }
    }

    protected void collectMetaInformationInChildren(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
        symbolDescription.visitChildren(iDescription -> {
            iDescription.collectMetaInformation(gamlProperties);
            return true;
        });
    }

    public static class ModelSerializer
    extends SpeciesSerializer {
        @Override
        protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append("model ").append(symbolDescription.getName().replace("_model", "")).append(Strings.LN).append(Strings.LN);
            stringBuilder.append("global ");
        }

        @Override
        protected void serializeChildren(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            SpeciesDescription speciesDescription = (SpeciesDescription)symbolDescription;
            stringBuilder.append(' ').append('{').append(Strings.LN);
            Iterable<SymbolDescription> iterable = speciesDescription.getAttributes();
            stringBuilder.append(Strings.LN);
            stringBuilder.append("// Global attributes of ").append(speciesDescription.getName()).append(Strings.LN);
            for (IDescription iDescription : iterable) {
                this.serializeChild(iDescription, stringBuilder, bl);
            }
            iterable = speciesDescription.getActions();
            stringBuilder.append(Strings.LN);
            stringBuilder.append("// Global actions of ").append(speciesDescription.getName()).append(Strings.LN);
            for (IDescription iDescription : iterable) {
                this.serializeChild(iDescription, stringBuilder, bl);
            }
            iterable = speciesDescription.getBehaviors();
            stringBuilder.append(Strings.LN);
            stringBuilder.append("// Behaviors of ").append(speciesDescription.getName()).append(Strings.LN);
            for (IDescription iDescription : iterable) {
                this.serializeChild(iDescription, stringBuilder, bl);
            }
            iterable = speciesDescription.getAspects();
            stringBuilder.append(Strings.LN);
            stringBuilder.append("// Aspects of ").append(speciesDescription.getName()).append(Strings.LN);
            for (IDescription iDescription : iterable) {
                this.serializeChild(iDescription, stringBuilder, bl);
            }
            stringBuilder.append('}').append(Strings.LN);
            if (speciesDescription.hasMicroSpecies()) {
                iterable = speciesDescription.getMicroSpecies().values();
                for (IDescription iDescription : iterable) {
                    stringBuilder.append(Strings.LN);
                    this.serializeChild(iDescription, stringBuilder, bl);
                }
            }
            iterable = ((ModelDescription)speciesDescription).getExperiments();
            for (IDescription iDescription : iterable) {
                stringBuilder.append(Strings.LN);
                this.serializeChild(iDescription, stringBuilder, bl);
            }
        }

        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("name".equals(string)) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }
    }

    public static class SpeciesSerializer
    extends SymbolSerializer<SpeciesDescription> {
        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("skills".equals(string)) {
                IExpressionDescription iExpressionDescription = symbolDescription.getFacet(string);
                if (iExpressionDescription == null) {
                    return null;
                }
                Collection<String> collection = iExpressionDescription.getStrings(symbolDescription, true);
                return collection.toString();
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }

        @Override
        protected void collectMetaInformationInSymbol(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
            gamlProperties.put("plugins", symbolDescription.getDefiningPlugin());
            gamlProperties.put("skills", ((SpeciesDescription)symbolDescription).getSkillsNames());
        }

        @Override
        protected void collectMetaInformationInFacetValue(SymbolDescription symbolDescription, String string, GamlProperties gamlProperties) {
            IExpression iExpression = symbolDescription.getFacetExpr(string);
            if (iExpression != null) {
                iExpression.collectMetaInformation(gamlProperties);
            }
        }
    }

    public static class StatementSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void collectMetaInformationInFacets(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
            super.collectMetaInformationInFacets(symbolDescription, gamlProperties);
        }

        @Override
        protected void serializeFacets(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            super.serializeFacets(symbolDescription, stringBuilder, bl);
            this.serializeArgs(symbolDescription, stringBuilder, bl);
        }

        protected void serializeArgs(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            StatementDescription statementDescription = (StatementDescription)symbolDescription;
            Iterable<IDescription> iterable = statementDescription.getFormalArgs();
            if (!Iterables.isEmpty(iterable)) {
                stringBuilder.append("(");
                for (IDescription iDescription : iterable) {
                    this.serializeArg(statementDescription, iDescription, stringBuilder, bl);
                    stringBuilder.append(", ");
                }
            } else {
                Arguments arguments = statementDescription.getPassedArgs();
                if (arguments.isEmpty()) {
                    return;
                }
                stringBuilder.append("(");
                arguments.forEachFacet((string, iExpressionDescription) -> {
                    if (Strings.isGamaNumber(string).booleanValue()) {
                        stringBuilder.append(iExpressionDescription.serializeToGaml(bl));
                    } else {
                        stringBuilder.append((String)string).append(":").append(iExpressionDescription.serializeToGaml(bl));
                    }
                    stringBuilder.append(", ");
                    return true;
                });
            }
            stringBuilder.setLength(stringBuilder.length() - 2);
            stringBuilder.append(")");
        }

        protected void serializeArg(IDescription iDescription, IDescription iDescription2, StringBuilder stringBuilder, boolean bl) {
        }
    }

    public static class VarSerializer
    extends SymbolSerializer<VariableDescription> {
        @Override
        protected void collectMetaInformationInSymbol(SymbolDescription symbolDescription, GamlProperties gamlProperties) {
            gamlProperties.put("plugins", symbolDescription.getDefiningPlugin());
        }

        @Override
        protected void serializeKeyword(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            String string;
            String string2 = symbolDescription.getKeyword();
            if (!"parameter".equals(string2) && !"unknown".equals(string = symbolDescription.getGamlType().serializeToGaml(false))) {
                string2 = string;
            }
            stringBuilder.append(string2).append(' ');
        }

        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("type".equals(string) || "of".equals(string) || "index".equals(string)) {
                return null;
            }
            if ("const".equals(string) && symbolDescription.hasFacet("const") && "false".equals(symbolDescription.getFacet(string).serializeToGaml(bl))) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }

        @Override
        protected String serializeFacetKey(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("init".equals(string)) {
                return "<- ";
            }
            return super.serializeFacetKey(symbolDescription, string, bl);
        }
    }
}

