/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.operators.IOperator;
import gama.gaml.operators.Cast;
import java.util.Objects;

public class Logic {
    @GamlAnnotations.operator(value={"xor"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="a bool value, equal to the logical xor between the left-hand operand and the right-hand operand. False when they are equal", comment="both operands are always casted to bool before applying the operator. Thus, an expression like 1 xor 0 is accepted and returns true.", see={"or", "and", "!"}, examples={@GamlAnnotations.example(value="xor(true,false)", equals="true"), @GamlAnnotations.example(value="xor(false,false)", equals="false"), @GamlAnnotations.example(value="xor(false,true)", equals="true"), @GamlAnnotations.example(value="xor(true,true)", equals="false"), @GamlAnnotations.example(value="true xor true", equals="false")})
    public static Boolean xor(IScope iScope, Boolean bl, Boolean bl2) throws GamaRuntimeException {
        return !Objects.equals(bl, bl2);
    }

    @GamlAnnotations.operator(value={"or"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="a bool value, equal to the logical or between the left-hand operand and the right-hand operand.", comment="both operands are always casted to bool before applying the operator. Thus, an expression like 1 or 0 is accepted and returns true.", see={"bool", "and", "!"}, examples={@GamlAnnotations.example(value="true or false", equals="true"), @GamlAnnotations.example(value=" int a <-3 ; int b <- 4; int c <- 7;"), @GamlAnnotations.example(value="((a+b) = c ) or ((a+b) > c )", equals="true")})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="false or false = false"), @GamlAnnotations.test(value="false or true"), @GamlAnnotations.test(value="true or true")})
    public static Boolean or(IScope iScope, Boolean bl, IExpression iExpression) throws GamaRuntimeException {
        if (!(bl != null && bl.booleanValue() || iExpression != null && Cast.asBool(iScope, iExpression.value(iScope)).booleanValue())) {
            return false;
        }
        return true;
    }

    @GamlAnnotations.operator(value={"and"}, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="a bool value, equal to the logical and between the left-hand operand and the right-hand operand.", comment="both operands are always casted to bool before applying the operator. Thus, an expression like (1 and 0) is accepted and returns false.", see={"bool", "or", "!"}, examples={@GamlAnnotations.example(value="true and false", equals="false"), @GamlAnnotations.example(value="false and false", equals="false"), @GamlAnnotations.example(value="false and true", equals="false"), @GamlAnnotations.example(value="true and true", equals="true"), @GamlAnnotations.example(value=" int a <-3 ; int b <- 4; int c <- 7;"), @GamlAnnotations.example(value="((a+b) = c ) and ((a+b) > c )", equals="false")})
    public static Boolean and(IScope iScope, Boolean bl, IExpression iExpression) throws GamaRuntimeException {
        if (bl != null && bl.booleanValue() && iExpression != null && Cast.asBool(iScope, iExpression.value(iScope)).booleanValue()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"!", "not"}, can_be_const=true, category={"Logical operators"}, concept={"logical"})
    @GamlAnnotations.doc(value="opposite boolean value.", special_cases={"if the parameter is not boolean, it is casted to a boolean value."}, examples={@GamlAnnotations.example(value="! (true)", equals="false")}, see={"bool", "and", "or"})
    public static Boolean not(Boolean bl) {
        return bl == false;
    }

    @GamlAnnotations.operator(value={"?"}, type=-198, content_type=-298, category={"Logical operators"}, concept={"logical", "ternary"})
    @GamlAnnotations.doc(value="It is used in combination with the : operator: if the left-hand operand evaluates to true, returns the value of the left-hand operand of the :, otherwise that of the right-hand operand of the :", comment="These functional tests can be combined together.", examples={@GamlAnnotations.example(value="[10, 19, 43, 12, 7, 22] collect ((each > 20) ? 'above' : 'below')", returnType="list<string>", equals="['below', 'below', 'above', 'below', 'below', 'above']"), @GamlAnnotations.example(value="rgb col <- (flip(0.3) ? #red : (flip(0.9) ? #blue : #green));")}, see={":"})
    public static Object iff(IScope iScope, Boolean bl, IExpression iExpression) throws GamaRuntimeException {
        IOperator iOperator = (IOperator)iExpression;
        return bl != false ? iOperator.arg(0).value(iScope) : iOperator.arg(1).value(iScope);
    }

    @GamlAnnotations.operator(value={":"}, type=-21, content_type=-21, index_type=-21, category={"Logical operators"}, concept={"logical", "ternary"})
    @GamlAnnotations.doc(value="It is used in combination with the ? operator. If the left-hand of ? operand evaluates to true, returns the value of the left-hand operand of the :, otherwise that of the right-hand operand of the :", examples={@GamlAnnotations.example(value="[10, 19, 43, 12, 7, 22] collect ((each > 20) ? 'above' : 'below')", returnType="list<string>", equals="['below', 'below', 'above', 'below', 'below', 'above']")}, see={"?"})
    public static Object then(IScope iScope, Object object, Object object2) {
        return null;
    }
}

