/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.common.util.FileUtils;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.InputParameter;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Strings;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.eclipse.core.runtime.Platform;

public class System {
    @GamlAnnotations.operator(value={"dead"}, category={"System"}, concept={"system", "species"})
    @GamlAnnotations.doc(value="true if the agent is dead (or null), false otherwise.", examples={@GamlAnnotations.example(value="dead(agent_A)", equals="true or false", isExecutable=false)})
    @GamlAnnotations.test(value="dead(simulation) = false")
    public static Boolean opDead(IScope iScope, IAgent iAgent) {
        if (iAgent != null && !iAgent.dead()) {
            return false;
        }
        return true;
    }

    @GamlAnnotations.operator(value={"is_error"}, can_be_const=true, concept={"test"})
    @GamlAnnotations.doc(value="Returns whether or not the argument raises an error when evaluated")
    @GamlAnnotations.test(value="is_error(1.0 = 1) = false")
    public static Boolean is_error(IScope iScope, IExpression iExpression) {
        try {
            iExpression.value(iScope);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            return !gamaRuntimeException.isWarning();
        }
        catch (Exception exception) {}
        return false;
    }

    @GamlAnnotations.operator(value={"is_warning"}, can_be_const=true, concept={"test"})
    @GamlAnnotations.doc(value="Returns whether or not the argument raises a warning when evaluated")
    @GamlAnnotations.test(value="is_warning(1.0 = 1) = false")
    public static Boolean is_warning(IScope iScope, IExpression iExpression) {
        try {
            iExpression.value(iScope);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            return gamaRuntimeException.isWarning();
        }
        catch (Exception exception) {}
        return false;
    }

    @GamlAnnotations.operator(value={"is_reachable"}, can_be_const=true, concept={"test"})
    @GamlAnnotations.doc(value="Returns whether or not the given web address is reachable or not before a time_out time in milliseconds", examples={@GamlAnnotations.example(value="write sample(is_reachable(\"www.google.com\", 200));", isExecutable=false)})
    public static Boolean is_reachable(IScope iScope, String string, int n, int n2) {
        try {
            Throwable throwable = null;
            Object var5_6 = null;
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(string, n), n2);
                return true;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @GamlAnnotations.operator(value={"play_sound"}, can_be_const=true, concept={"sound"})
    @GamlAnnotations.doc(value="Play a wave file", examples={@GamlAnnotations.example(value="bool sound_ok <- play_sound('beep.wav');", isExecutable=false)})
    public static Boolean playSound(IScope iScope, String string) {
        try {
            String string2 = FileUtils.constructAbsoluteFilePath(iScope, string, true);
            File file2 = new File(string2);
            if (!file2.exists()) {
                return false;
            }
            Clip clip = AudioSystem.getClip();
            AudioInputStream audioInputStream = AudioSystem.getAudioInputStream(file2);
            clip.open(audioInputStream);
            clip.start();
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error(exception.toString(), iScope);
        }
        return true;
    }

    @GamlAnnotations.operator(value={"is_reachable"}, concept={"test"})
    @GamlAnnotations.doc(value="Returns whether or not the given web address is reachable or not before a time_out time in milliseconds", examples={@GamlAnnotations.example(value="write sample(is_reachable(\"www.google.com\", 200));", isExecutable=false)})
    public static Boolean is_reachable(IScope iScope, String string, int n) {
        return System.is_reachable(iScope, string, 80, n);
    }

    @GamlAnnotations.operator(value={"command"}, category={"System"}, concept={"system", "communication"})
    @GamlAnnotations.doc(value="command allows GAMA to issue a system command using the system terminal or shell and to receive a string containing the outcome of the command or script executed. By default, commands are blocking the agent calling them, unless the sequence ' &' is used at the end. In this case, the result of the operator is an empty string. The basic form with only one string in argument uses the directory of the model and does not set any environment variables. Two other forms (with a directory and a map<string, string> of environment variables) are available.", masterDoc=true)
    public static String console(IScope iScope, String string) {
        return System.console(iScope, string, iScope.getSimulation().getExperiment().getWorkingPath());
    }

    @GamlAnnotations.operator(value={"command"}, category={"System"}, concept={"system", "communication"})
    @GamlAnnotations.doc(value="command allows GAMA to issue a system command using the system terminal or shell and to receive a string containing the outcome of the command or script executed. By default, commands are blocking the agent calling them, unless the sequence ' &' is used at the end. In this case, the result of the operator is an empty string. The basic form with only one string in argument uses the directory of the model and does not set any environment variables. Two other forms (with a directory and a map<string, string> of environment variables) are available.")
    public static String console(IScope iScope, String string, String string2) {
        return System.console(iScope, string, string2, GamaMapFactory.create());
    }

    @GamlAnnotations.operator(value={"command"}, category={"System"}, concept={"system", "communication"})
    @GamlAnnotations.doc(value="command allows GAMA to issue a system command using the system terminal or shell and to receive a string containing the outcome of the command or script executed. By default, commands are blocking the agent calling them, unless the sequence ' &' is used at the end. In this case, the result of the operator is an empty string. A map<string, string> containing environment variables values can be passed, replacing, only for this command, the values of existing variables.")
    public static String console(IScope iScope, String string, String string2, IMap<String, String> iMap) {
        Process process;
        StringBuilder stringBuilder;
        block15: {
            if (string == null || string.isEmpty()) {
                return "";
            }
            stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("win32".equals(Platform.getOS()) ? "cmd.exe" : "/bin/bash");
            arrayList.add("win32".equals(Platform.getOS()) ? "/C" : "-c");
            arrayList.add(string.trim());
            boolean bl = ((String)arrayList.get(arrayList.size() - 1)).endsWith("&");
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.redirectErrorStream(true);
            processBuilder.directory(new File(string2));
            processBuilder.environment().putAll(iMap);
            process = processBuilder.start();
            if (!bl) break block15;
            return "";
        }
        try {
            Throwable throwable = null;
            Object var10_12 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                int n = process.waitFor();
                String string3 = "";
                while ((string3 = bufferedReader.readLine()) != null) {
                    stringBuilder.append(string3 + Strings.LN);
                }
                if (n != 0) {
                    throw GamaRuntimeException.error("Error in console command." + stringBuilder.toString(), iScope);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException | InterruptedException exception) {
            throw GamaRuntimeException.error("Error in console command. " + exception.getMessage(), iScope);
        }
        return stringBuilder.toString();
    }

    @GamlAnnotations.operator(value={".", "of"}, type=-198, content_type=-298, index_type=-398, category={"System"}, concept={"system", "attribute"})
    @GamlAnnotations.doc(value="It has two different uses: it can be the dot product between 2 matrices or return an evaluation of the expression (right-hand operand) in the scope the given agent.", masterDoc=true, special_cases={"if the agent is nil or dead, throws an exception"}, usages={@GamlAnnotations.usage(value="if the left operand is an agent, it evaluates of the expression (right-hand operand) in the scope the given agent", examples={@GamlAnnotations.example(value="agent1.location", equals="the location of the agent agent1", isExecutable=false)})})
    public static Object opGetValue(IScope iScope, IAgent iAgent, IExpression iExpression) throws GamaRuntimeException {
        if (iAgent == null) {
            if (!iScope.interrupted()) {
                throw GamaRuntimeException.warning("Cannot evaluate " + iExpression.serializeToGaml(false) + " as the target agent is nil", iScope);
            }
            return null;
        }
        if (iAgent.dead()) {
            if (!iScope.interrupted()) {
                throw GamaRuntimeException.warning("Cannot evaluate " + iExpression.serializeToGaml(false) + " as the target agent is dead", iScope);
            }
            return null;
        }
        return iScope.evaluate(iExpression, iAgent).getValue();
    }

    @GamlAnnotations.operator(value={"copy"}, type=-199, content_type=-299, category={"System"}, concept={"system"})
    @GamlAnnotations.doc(value="returns a copy of the operand.")
    public static Object opCopy(IScope iScope, Object object) throws GamaRuntimeException {
        if (object instanceof IValue) {
            return ((IValue)object).copy(iScope);
        }
        return object;
    }

    @GamlAnnotations.operator(value={"user_input_dialog"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user for some values and returns a map containing these values. Takes a string and a list of calls to the `enter()` or `choose()` operators as arguments. The string is used to specify the message of the dialog box. The list is to specify the parameters the user can enter", examples={@GamlAnnotations.example(value="map<string,unknown> values2 <- user_input_dialog('Enter number of agents and locations',[enter('Number',100), enter('Location',point, {10, 10})]);"), @GamlAnnotations.example(value="create bug number: int(values2 at \"Number\") with: [location:: (point(values2 at \"Location\"))];", isExecutable=false)})
    public static IMap<String, Object> userInputDialog(IScope iScope, String string, IList iList) {
        iList.removeIf(object -> !(object instanceof IParameter));
        return System.userInputDialog(iScope, string, iList, null, null);
    }

    @GamlAnnotations.operator(value={"user_input_dialog"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user for some values and returns a map containing these values. Takes a string and a list of calls to the `enter()` or `choose()` operators as arguments. The string is used to specify the message of the dialog box. The list is to specify the parameters the user can enter", examples={@GamlAnnotations.example(value="map<string,unknown> values_no_title <- user_input_dialog([enter('Number',100), enter('Location',point, {10, 10})]);"), @GamlAnnotations.example(value="create bug number: int(values2 at \"Number\") with: [location:: (point(values2 at \"Location\"))];", isExecutable=false)})
    public static IMap<String, Object> userInputDialog(IScope iScope, IList iList) {
        IAgent iAgent = iScope.getAgent();
        return System.userInputDialog(iScope, iAgent.getSpeciesName() + " #" + iAgent.getIndex() + " request", iList);
    }

    @GamlAnnotations.operator(value={"user_input_dialog"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user for some values and returns a map containing these values. Takes a string and a list of calls to the `enter()` or `choose()` operators as arguments. The string is used to specify the message of the dialog box. The list is used to specify the parameters the user can enter. Finally, the font of the title can be specified", examples={@GamlAnnotations.example(value="map<string,unknown> values2 <- user_input_dialog('Enter number of agents and locations',[enter('Number',100), enter('Location',point, {10, 10})], font('Helvetica', 18));"), @GamlAnnotations.example(value="create bug number: int(values2 at \"Number\") with: [location:: (point(values2 at \"Location\"))];", isExecutable=false)})
    public static IMap<String, Object> userInputDialog(IScope iScope, String string, IList iList, GamaFont gamaFont) {
        iList.removeIf(object -> !(object instanceof IParameter));
        return GamaMapFactory.createWithoutCasting(Types.STRING, Types.NO_TYPE, iScope.getGui().openUserInputDialog(iScope, string, iList, gamaFont, null, true));
    }

    @GamlAnnotations.operator(value={"user_input_dialog"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user for some values and returns a map containing these values. Takes a string and a list of calls to the `enter()` or `choose()` operators as arguments. The string is used to specify the message of the dialog box. The list is used to specify the parameters the user can enter. Finally, the font of the title can be specified as well as the background color", examples={@GamlAnnotations.example(value="map<string,unknown> values2 <- user_input_dialog('Enter number of agents and locations',[enter('Number',100), enter('Location',point, {10, 10})], font('Helvetica', 18));"), @GamlAnnotations.example(value="create bug number: int(values2 at \"Number\") with: [location:: (point(values2 at \"Location\"))];", isExecutable=false)})
    public static IMap<String, Object> userInputDialog(IScope iScope, String string, IList iList, GamaFont gamaFont, GamaColor gamaColor) {
        return System.userInputDialog(iScope, string, iList, gamaFont, gamaColor, true);
    }

    @GamlAnnotations.operator(value={"user_input_dialog"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user for some values and returns a map containing these values. Takes a string and a list of calls to the `enter()` or `choose()` operators as arguments. The string is used to specify the message of the dialog box. The list is used to specify the parameters the user can enter. Finally, the font of the title can be specified, as well as the background color and whether the title and close button of the dialog should be displayed or not", masterDoc=true, examples={@GamlAnnotations.example(value="map<string,unknown> values2 <- user_input_dialog('Enter number of agents and locations',[enter('Number',100), enter('Location',point, {10, 10})], font('Helvetica', 18), #blue, true);"), @GamlAnnotations.example(value="create bug number: int(values2 at \"Number\") with: [location:: (point(values2 at \"Location\"))];", isExecutable=false)})
    public static IMap<String, Object> userInputDialog(IScope iScope, String string, IList iList, GamaFont gamaFont, GamaColor gamaColor, Boolean bl) {
        iList.removeIf(object -> !(object instanceof IParameter));
        return GamaMapFactory.createWithoutCasting(Types.STRING, Types.NO_TYPE, iScope.getGui().openUserInputDialog(iScope, string, iList, gamaFont, gamaColor, bl));
    }

    @GamlAnnotations.operator(value={"wizard"}, category={"System", "User control operators"}, concept={"system", "gui"})
    @GamlAnnotations.doc(value="Build a wizard and return the values enter by the user as a map of map [\"title page 1\"::[\"var1\"::1,\"var2\"::2]]. Takes a string, an action and a list of calls to the `wizard_page()` operator. The first string is used to specify the title. The action to describe when the wizard is supposed to be finished. A classic way of defining the action is bool eval_finish(map<string,map> input_map) {return input_map[\"page1\"][\"file\"] != nil;}. The list is to specify the wizard pages.", examples={@GamlAnnotations.example(value="map results <-  wizard(\"My wizard\",eval_finish, [wizard_page(\"page1\",\"enter info\" ,[enter(\"var1\",string)], font(\"Arial\", 10))]);", isExecutable=false)})
    public static IMap<String, IMap<String, Object>> openWizard(IScope iScope, String string, ActionDescription actionDescription, IList<IMap<String, Object>> iList) {
        return iScope.getGui().openWizard(iScope, string, actionDescription, iList);
    }

    @GamlAnnotations.operator(value={"wizard"}, category={"System", "User control operators"}, concept={"system", "gui"})
    @GamlAnnotations.doc(value="Build a wizard and return the values enter by the user as a map of map [\"title page 1\"::[\"var1\"::1,\"var2\"::2]]. Takes a string, a list of calls to the `wizard_page()` operator. The first string is used to specify the title. The list is to specify the wizard pages.", examples={@GamlAnnotations.example(value="map results <-  wizard(\"My wizard\",[wizard_page(\"page1\",\"enter info\" ,[enter(\"var1\",string)], font(\"Arial\", 10))]);", isExecutable=false)})
    public static IMap<String, IMap<String, Object>> openWizard(IScope iScope, String string, IList<IMap<String, Object>> iList) {
        return iScope.getGui().openWizard(iScope, string, null, iList);
    }

    @GamlAnnotations.operator(value={"wizard_page"}, category={"System", "User control operators"}, concept={"system", "gui"})
    @GamlAnnotations.doc(value="Build a wizard page. Takes two strings, a list of calls to the `enter()` or `choose()` operators and a font as arguments. The first string is used to specify the title, the second the description of the dialog box. The list is to specify the parameters the user can enter. The font is used to specify the font", examples={@GamlAnnotations.example(value="map results <-  wizard(\"My wizard\",[wizard_page(\"page1\",\"enter info\" ,[enter(\"var1\",string)], font(\"Arial\", 10))]);", isExecutable=false)})
    public static IMap<String, Object> wizardPage(String string, String string2, IList iList, GamaFont gamaFont) {
        IMap iMap = GamaMapFactory.create();
        iMap.put("title", string);
        iMap.put("description", string2);
        iMap.put("parameters", iList);
        iMap.put("font", gamaFont);
        return iMap;
    }

    @GamlAnnotations.operator(value={"wizard_page"}, category={"System", "User control operators"}, concept={"system", "gui"})
    @GamlAnnotations.doc(value="Build a wizard page. Takes two strings and a list of calls to the `enter()` or `choose()` operators. The first string is used to specify the title, the second the description of the dialog box. The list is to specify the parameters the user can enter", examples={@GamlAnnotations.example(value="map results <-  wizard(\"My wizard\",[wizard_page(\"page1\",\"enter info\" ,[enter(\"var1\",string)])]);", isExecutable=false)})
    public static IMap<String, Object> wizardPage(String string, String string2, IList iList) {
        IMap iMap = GamaMapFactory.create();
        iMap.put("title", string);
        iMap.put("description", string2);
        iMap.put("parameters", iList);
        return iMap;
    }

    @GamlAnnotations.operator(value={"user_confirm"}, category={"System", "User control operators"}, concept={})
    @GamlAnnotations.doc(value="Asks the user to confirm a choice. The two string are used to specify the title and the message of the dialog box. ", examples={@GamlAnnotations.example(value="bool confirm <- user_confirm(\"Confirm\",\"Please confirm\");")})
    public static Boolean userConfirmDialog(IScope iScope, String string, String string2) {
        return iScope.getGui().openUserInputDialogConfirm(iScope, string, string2);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a value by specifying a title and a type")
    public static IParameter enterValue(IScope iScope, String string, IType iType) {
        return System.enterValue(iScope, string, iType, iType.getDefault());
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter an int by specifying a title and an initial value")
    public static IParameter enterValue(IScope iScope, String string, Integer n) {
        return System.enterValue(iScope, string, Types.INT, n);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter an int by specifying a title, an initial value, a min and a max value. The initial value is clamped if it is lower than min or higher than max.")
    public static IParameter enterValue(IScope iScope, String string, Integer n, Integer n2, Integer n3) {
        return new InputParameter(string, (Object)n, n2, n3);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter an int by specifying a title, an initial value, a min, a max and a step value. The initial value is clamped if it is lower than min or higher than max.", usages={@GamlAnnotations.usage(value="The GUI is then a slider when an init value, a min (int or float), a max (int or float) (and eventually a  step (int or float) ) operands.", examples={@GamlAnnotations.example(value="map resMinMax <- user_input([enter(\"Title\",5,0)])", test=false), @GamlAnnotations.example(value="map resMinMax <- user_input([enter(\"Title\",5,0,10)])", test=false), @GamlAnnotations.example(value="map resMMStepFF <- user_input([enter(\"Title\",5,0.1,10.1,0.5)]);", test=false)})})
    public static IParameter enterValue(IScope iScope, String string, Integer n, Integer n2, Integer n3, Integer n4) {
        return new InputParameter(string, n, n2, n3, n4);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter an int by specifying a title, an initial value, a min and a max valueThe initial value is clamped if it is lower than min or higher than max.")
    public static IParameter enterValue(IScope iScope, String string, Double d, Double d2, Double d3) {
        return new InputParameter(string, (Object)d, d2, d3);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a float by specifying a title, an initial value, a min, a max and a step value. The initial value is clamped if it is lower than min or higher than max.")
    public static IParameter enterValue(IScope iScope, String string, Double d, Double d2, Double d3, Double d4) {
        return new InputParameter(string, d, d2, d3, d4);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a float by specifying a title and an initial value")
    public static IParameter enterValue(IScope iScope, String string, Double d) {
        return System.enterValue(iScope, string, Types.FLOAT, d);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a boolean value by specifying a title and an initial value", usages={@GamlAnnotations.usage(value="When the second operand is the boolean type or a boolean value, the GUI is then a switch", examples={@GamlAnnotations.example(value="map<string,unknown> m <- user_input(enter(\"Title\",true));", test=false), @GamlAnnotations.example(value="map<string,unknown> m2 <- user_input(enter(\"Title\",bool));", test=false)})})
    public static IParameter enterValue(IScope iScope, String string, Boolean bl) {
        return System.enterValue(iScope, string, Types.BOOL, bl);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a string by specifying a title and an initial value", masterDoc=true)
    public static IParameter enterValue(IScope iScope, String string, String string2) {
        return System.enterValue(iScope, string, Types.STRING, string2);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a value by specifying a title, a type, and an initial value")
    public static IParameter enterValue(IScope iScope, String string, IType iType, Object object) {
        return new InputParameter(string, object, iType);
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"enter"})
    @GamlAnnotations.doc(value="Allows the user to enter a value by specifying a title and an initial value. The type will be deduced from the value")
    public static IParameter enterValue(IScope iScope, String string, Object object) {
        return new InputParameter(string, object, GamaType.of(object));
    }

    @GamlAnnotations.operator(can_be_const=false, category={"System", "User control operators"}, value={"choose"})
    @GamlAnnotations.doc(value="Allows the user to choose a value by specifying a title, a type, and a list of possible values")
    public static IParameter enterValue(IScope iScope, String string, IType iType, Object object, IList iList) {
        return new InputParameter(string, object, iType, iList);
    }

    @GamlAnnotations.operator(value={"copy_to_clipboard"}, can_be_const=false, category={"System"}, concept={"system"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="bool copied  <- copy_to_clipboard('text to copy');")}, value="Tries to copy the text in parameter to the clipboard and returns whether it has been correctly copied or not (for instance it might be impossible in a headless environment)")
    public static Boolean copyToClipboard(IScope iScope, String string) {
        return iScope.getGui().copyToClipboard(string);
    }

    @GamlAnnotations.operator(value={"copy_from_clipboard"}, can_be_const=false, type=-349, category={"System"}, concept={"system"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="string copied  <- copy_from_clipboard(string);")}, value="Tries to copy data from the clipboard by passing its expected type. Returns nil if it has not been correctly retrieved, or not retrievable using the given type or if GAMA is in a headless environment")
    public static Object copyFromClipboard(IScope iScope, IType iType) {
        return iType.copyFromClipboard(iScope);
    }
}

