/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;

@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="topology", type={18}, optional=false, doc={@GamlAnnotations.doc(value="the topology")})}, omissible="topology")
@GamlAnnotations.doc(value="`using` is a statement that allows to set the topology to use by its sub-statements. They can gather it by asking the scope to provide it.", usages={@GamlAnnotations.usage(value="All the spatial operations are topology-dependent (e.g. neighbors are not the same in a continuous and in a grid topology). So `using` statement allows modelers to specify the topology in which the spatial operation will be computed.", examples={@GamlAnnotations.example(value="float dist <- 0.0;", isExecutable=false), @GamlAnnotations.example(value="using topology(grid_ant) {", isExecutable=false), @GamlAnnotations.example(value="\td (self.location distance_to target.location);", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})})
public class UsingStatement
extends AbstractStatementSequence {
    final IExpression topology;
    final ThreadLocal<ITopology> previous = new ThreadLocal();

    public UsingStatement(IDescription iDescription) {
        super(iDescription);
        this.topology = this.getFacet("topology");
        this.setName("using " + this.topology.serializeToGaml(false));
    }

    @Override
    public void enterScope(IScope iScope) {
        super.enterScope(iScope);
        ITopology iTopology = Cast.asTopology(iScope, this.topology.value(iScope));
        if (iTopology != null) {
            this.previous.set(iScope.setTopology(iTopology));
        }
    }

    @Override
    public void leaveScope(IScope iScope) {
        iScope.setTopology(this.previous.get());
        this.previous.set(null);
        super.leaveScope(iScope);
    }
}

