/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.draw;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Scaling3D;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.gaml.statements.draw.DrawingAttributes;

public class TextDrawingAttributes
extends DrawingAttributes
implements Cloneable {
    private GamaFont font;
    public GamaPoint anchor;
    public Double precision;

    public TextDrawingAttributes(Scaling3D scaling3D, AxisAngle axisAngle, GamaPoint gamaPoint, GamaColor gamaColor) {
        super(scaling3D, axisAngle, gamaPoint, gamaColor, null, null);
        this.setFlag(DrawingAttributes.Flag.Perspective, true);
        this.setType(IShape.Type.POLYGON);
    }

    public void setPerspective(Boolean bl) {
        this.setFlag(DrawingAttributes.Flag.Perspective, bl == null ? true : bl);
    }

    @Override
    public GamaColor getColor() {
        if (this.isEmpty() && this.fill == null && this.border != null) {
            return this.border;
        }
        return super.getColor();
    }

    public void setAnchor(GamaPoint gamaPoint) {
        this.anchor = gamaPoint;
    }

    @Override
    public GamaPoint getAnchor() {
        if (this.anchor == null) {
            return super.getAnchor();
        }
        return this.anchor;
    }

    public GamaFont getFont() {
        return this.font;
    }

    public void setFont(GamaFont gamaFont) {
        this.font = gamaFont;
    }

    public boolean isPerspective() {
        return this.isSet(DrawingAttributes.Flag.Perspective);
    }

    @Override
    public Double getDepth() {
        return this.depth == null ? 0.0 : this.depth;
    }

    public TextDrawingAttributes copyTranslatedBy(GamaPoint gamaPoint) {
        try {
            TextDrawingAttributes textDrawingAttributes = (TextDrawingAttributes)this.clone();
            textDrawingAttributes.setLocation(this.getLocation().plus(gamaPoint));
            return textDrawingAttributes;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            return new TextDrawingAttributes(this.getSize(), this.getRotation(), this.getLocation().plus(gamaPoint), this.getColor());
        }
    }

    public void setPrecision(Double d) {
        this.precision = Math.min(1.0, Math.max(0.0, d));
    }

    public Double getPrecision() {
        return this.precision;
    }
}

