/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements.save;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.projection.IProjection;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.save.AbstractShapeSaver;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureWriter;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.feature.SchemaException;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class ShapeSaver
extends AbstractShapeSaver {
    @Override
    public void internalSave(IScope iScope, File file2, List<? extends IShape> list, String string, String string2, Map<String, IExpression> map, IProjection iProjection, String string3) throws IOException, SchemaException, GamaRuntimeException {
        block28: {
            if (list == null || list.isEmpty()) {
                return;
            }
            ShapefileDataStore shapefileDataStore = new ShapefileDataStore(file2.toURI().toURL());
            shapefileDataStore.setCharset(StandardCharsets.UTF_8);
            SimpleFeatureType simpleFeatureType = DataUtilities.createType((String)shapefileDataStore.getFeatureSource().getEntry().getTypeName(), (String)string);
            shapefileDataStore.createSchema(simpleFeatureType);
            boolean bl = string2.equals(MultiPolygon.class.getSimpleName()) || string2.equals(Polygon.class.getSimpleName());
            boolean bl2 = string2.equals(MultiLineString.class.getSimpleName()) || string2.equals(LineString.class.getSimpleName());
            boolean bl3 = string2.equals(MultiPoint.class.getSimpleName()) || string2.equals(Point.class.getSimpleName());
            try {
                try {
                    Throwable throwable = null;
                    Object var15_16 = null;
                    try (FeatureWriter featureWriter = shapefileDataStore.getFeatureWriter(Transaction.AUTO_COMMIT);){
                        CoordinateReferenceSystem coordinateReferenceSystem;
                        Object object;
                        Geometry throwable2;
                        List<IExpression> list2 = map == null ? Collections.emptyList() : map.values();
                        for (IShape iShape2 : list) {
                            boolean bl4;
                            if (iShape2.getGeometries().size() > 1) {
                                iShape2.setInnerGeometry(this.geometryCollectionToSimpleManagement(iShape2.getInnerGeometry()));
                            }
                            throwable2 = iShape2.getInnerGeometry();
                            if ((bl && (throwable2 instanceof Polygon || throwable2 instanceof MultiPolygon) || bl2 && iShape2.isLine() || bl3 && iShape2.isPoint()) && !(bl4 = ShapeSaver.buildFeature(iScope, (SimpleFeature)(object = (SimpleFeature)featureWriter.next()), iShape2, iProjection, list2))) break;
                        }
                        if (iProjection == null || (coordinateReferenceSystem = iProjection.getInitialCRS(iScope)) == null) break block28;
                        try {
                            Object object2 = null;
                            throwable2 = null;
                            try {
                                object = new FileWriter(file2.getAbsolutePath().replace(".shp", ".prj"));
                                try {
                                    ((Writer)object).write(coordinateReferenceSystem.toString());
                                }
                                finally {
                                    if (object != null) {
                                        ((OutputStreamWriter)object).close();
                                    }
                                }
                            }
                            catch (Throwable throwable3) {
                                if (object2 == null) {
                                    object2 = throwable3;
                                } else if (object2 != throwable3) {
                                    ((Throwable)object2).addSuppressed(throwable3);
                                }
                                throw object2;
                            }
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        throw throwable;
                    }
                }
                catch (ClassCastException classCastException) {
                    throw GamaRuntimeException.error("Cannot save agents/geometries with different types of geometries (point, line, polygon) in a same shapefile", iScope);
                }
            }
            finally {
                shapefileDataStore.dispose();
            }
        }
    }

    @Override
    protected void internalSave(IScope iScope, OutputStream outputStream, List<? extends IShape> list, String string, String string2, Map<String, IExpression> map, IProjection iProjection, String string3) throws IOException, SchemaException, GamaRuntimeException {
    }

    @Override
    public Set<String> computeFileTypes() {
        return Set.of("shp", "shape");
    }

    @Override
    public BiMap<String, String> getSynonyms() {
        return ImmutableBiMap.of((Object)"shp", (Object)"shape");
    }
}

