/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization.genetic;

import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.operators.Cast;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

public class Chromosome
implements Comparable<Chromosome> {
    private Object[] genes;
    private final String[] phenotype;
    private double fitness;

    public Object[] getGenes() {
        return this.genes;
    }

    public void setGenes(Object[] objectArray) {
        this.genes = objectArray;
    }

    public double getFitness() {
        return this.fitness;
    }

    public void setFitness(double d) {
        this.fitness = d;
    }

    public Chromosome(Chromosome chromosome) {
        this.genes = new Object[chromosome.genes.length];
        this.phenotype = new String[chromosome.phenotype.length];
        int n = 0;
        while (n < this.genes.length) {
            this.genes[n] = chromosome.genes[n];
            this.phenotype[n] = chromosome.phenotype[n];
            ++n;
        }
        this.fitness = chromosome.fitness;
    }

    public void update(IScope iScope, ParametersSet parametersSet) {
        int n = this.getGenes().length;
        int n2 = 0;
        while (n2 < n) {
            String string = this.getPhenotype()[n2];
            this.genes[n2] = Cast.asFloat(iScope, parametersSet.get(string));
            ++n2;
        }
    }

    public Chromosome(IScope iScope, List<IParameter.Batch> list, boolean bl) {
        this.genes = new Object[list.size()];
        this.phenotype = new String[list.size()];
        int n = 0;
        for (IParameter.Batch batch : list) {
            if (bl) {
                batch.reinitRandomly(iScope);
            }
            this.phenotype[n] = batch.getName();
            this.genes[n] = batch.getType().id() == 2 ? Cast.asFloat(iScope, batch.value(iScope)) : (batch.getType().id() == 1 ? Cast.asInt(iScope, batch.value(iScope)) : batch.value(iScope));
            ++n;
        }
    }

    public void setGene(IScope iScope, IParameter.Batch batch, int n) {
        this.genes[n] = batch.getType().id() == 2 ? (Number)Cast.asFloat(iScope, batch.value(iScope)) : (Number)(batch.getType().id() == 1 ? Cast.asInt(iScope, batch.value(iScope)) : Integer.valueOf(0));
    }

    public ParametersSet convertToSolution(IScope iScope, Collection<IParameter.Batch> collection) throws GamaRuntimeException {
        ParametersSet parametersSet = new ParametersSet(iScope, collection, true);
        int n = 0;
        while (n < this.phenotype.length) {
            parametersSet.put(this.phenotype[n], this.genes[n]);
            ++n;
        }
        return parametersSet;
    }

    @Override
    public int compareTo(Chromosome chromosome) {
        return Double.compare(this.fitness, chromosome.fitness);
    }

    public String[] getPhenotype() {
        return this.phenotype;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Arrays.hashCode(this.genes);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Chromosome chromosome = (Chromosome)object;
        return Arrays.equals(this.genes, chromosome.genes);
    }
}

