/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.graph;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.runtime.GAMA;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IList;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph._Edge;
import gama.core.util.graph._Vertex;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;

public class AStar<V, E> {
    protected GamaGraph<V, E> graph;
    protected V source;
    protected V target;
    protected Map<V, ASNode> openMap = GamaMapFactory.create();
    protected Map<V, ASNode> closedMap = GamaMapFactory.create();
    protected List<E> result;
    protected boolean isSpatialGraph;

    public AStar() {
    }

    public AStar(GamaGraph<V, E> gamaGraph) {
        this.init(gamaGraph);
    }

    public AStar(GamaGraph<V, E> gamaGraph, V v, V v2) {
        this(gamaGraph);
        this.setSource(v);
        this.setTarget(v2);
    }

    public void setSource(V v) {
        this.cleanAll();
        this.source = v;
    }

    public void setTarget(V v) {
        this.cleanAll();
        this.target = v;
    }

    public void init(GamaGraph<V, E> gamaGraph) {
        this.cleanAll();
        this.graph = gamaGraph;
        this.isSpatialGraph = gamaGraph instanceof GamaSpatialGraph;
    }

    public IList<E> compute() {
        if (this.source != null && this.target != null) {
            this.aStar(this.source, this.target);
        }
        if (this.result == null || this.result.isEmpty()) {
            return GamaListFactory.EMPTY_LIST;
        }
        return GamaListFactory.create(GAMA.getRuntimeScope(), Types.NO_TYPE, this.result);
    }

    /*
     * Loose catch block
     */
    public IList<E> buildPath(ASNode aSNode) {
        Throwable throwable = null;
        Object var3_4 = null;
        try {
            Collection collection;
            Collector.AsList asList;
            Collector.AsList asList2;
            block19: {
                block18: {
                    asList2 = Collector.getList();
                    asList = Collector.getList();
                    ASNode aSNode2 = aSNode;
                    while (aSNode2 != null) {
                        asList.add(aSNode2);
                        aSNode2 = aSNode2.parent;
                    }
                    int n = asList.size();
                    if (n > 1) {
                        ASNode aSNode3 = (ASNode)asList.items().get(n - 2);
                        asList2.add(aSNode3.edge);
                        int n2 = n - 3;
                        while (n2 >= 0) {
                            aSNode3 = (ASNode)asList.items().get(n2);
                            asList2.add(aSNode3.edge);
                            --n2;
                        }
                    }
                    collection = asList2.items();
                    if (asList == null) break block18;
                    asList.close();
                }
                if (asList2 == null) break block19;
                asList2.close();
            }
            return collection;
            {
                catch (Throwable throwable2) {
                    try {
                        if (asList != null) {
                            asList.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (asList2 != null) {
                            asList2.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    protected void cleanAll() {
        this.openMap.clear();
        this.closedMap.clear();
        this.result = null;
    }

    protected void aStar(V v, V v2) {
        this.cleanAll();
        this.openMap.put((ASNode)v, new ASNode(v, null, null, 0.0, this.heuristic(v, v2)));
        while (!this.openMap.isEmpty()) {
            ASNode aSNode = this.getNextBetterNode();
            assert (aSNode != null);
            if (aSNode.node.equals(v2)) {
                assert (aSNode.edge != null);
                this.result = this.buildPath(aSNode);
                return;
            }
            this.openMap.remove(aSNode.node);
            this.closedMap.put((ASNode)aSNode.node, aSNode);
            _Vertex<V, E> _Vertex2 = this.graph.getVertex(aSNode.node);
            LinkedHashSet linkedHashSet = new LinkedHashSet(_Vertex2.getOutEdges());
            if (!this.graph.isDirected()) {
                linkedHashSet.addAll(_Vertex2.getInEdges());
            }
            for (Object e : linkedHashSet) {
                Object object;
                _Edge<V, E> _Edge2 = this.graph.getEdge(e);
                Object object2 = object = _Edge2.getTarget().equals(aSNode.node) ? _Edge2.getSource() : _Edge2.getTarget();
                if (this.closedMap.containsKey(object)) continue;
                double d = this.heuristic(object, v2);
                double d2 = aSNode.g + _Edge2.getWeight();
                ASNode aSNode2 = this.openMap.get(object);
                if (aSNode2 == null || d2 < aSNode2.g) {
                    this.openMap.put((ASNode)object, new ASNode(object, e, aSNode, d2, d));
                    continue;
                }
                double cfr_ignored_0 = aSNode2.rank;
            }
        }
    }

    protected double heuristic(Object object, Object object2) {
        if (this.isSpatialGraph) {
            GamaPoint gamaPoint = ((IShape)object).getLocation();
            GamaPoint gamaPoint2 = ((IShape)object2).getLocation();
            return gamaPoint.distance(gamaPoint2);
        }
        return 0.0;
    }

    protected ASNode getNextBetterNode() {
        double d = 3.4028234663852886E38;
        ASNode aSNode = null;
        for (ASNode aSNode2 : this.openMap.values()) {
            if (!(aSNode2.rank < d)) continue;
            aSNode = aSNode2;
            d = aSNode2.rank;
        }
        return aSNode;
    }

    protected class ASNode {
        public V node;
        public ASNode parent;
        public E edge;
        public double g;
        public double rank;

        public ASNode(V v, E e, ASNode aSNode, double d, double d2) {
            this.node = v;
            this.edge = e;
            this.parent = aSNode;
            this.g = d;
            this.rank = d + d2;
        }
    }
}

