/*
 * Decompiled with CFR 0.152.
 */
package gama.core.runtime;

import gama.core.runtime.IExecutionContext;
import gama.core.runtime.IScope;
import gama.gaml.compilation.ISymbol;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class ExecutionContext
implements IExecutionContext {
    Map<String, Object> local;
    IExecutionContext outer;
    IScope scope;
    ISymbol command;

    public static ExecutionContext create(IExecutionContext iExecutionContext, ISymbol iSymbol) {
        return ExecutionContext.create(iExecutionContext.getScope(), iExecutionContext, iSymbol);
    }

    public static ExecutionContext create(IScope iScope, ISymbol iSymbol) {
        return ExecutionContext.create(iScope, null, iSymbol);
    }

    public static ExecutionContext create(IScope iScope, IExecutionContext iExecutionContext, ISymbol iSymbol) {
        ExecutionContext executionContext = new ExecutionContext(iSymbol);
        executionContext.scope = iScope;
        executionContext.outer = iExecutionContext;
        return executionContext;
    }

    @Override
    public void dispose() {
        this.local = null;
        this.outer = null;
        this.scope = null;
    }

    @Override
    public IScope getScope() {
        return this.scope;
    }

    ExecutionContext(ISymbol iSymbol) {
        this.command = iSymbol;
    }

    @Override
    public final IExecutionContext getOuterContext() {
        return this.outer;
    }

    @Override
    public void setTempVar(String string, Object object) {
        if (this.local == null || !this.local.containsKey(string)) {
            if (this.outer != null) {
                this.outer.setTempVar(string, object);
            }
        } else {
            this.local.put(string, object);
        }
    }

    @Override
    public Object getTempVar(String string) {
        if (this.local == null || !this.local.containsKey(string)) {
            return this.outer == null ? null : this.outer.getTempVar(string);
        }
        return this.local.get(string);
    }

    @Override
    public ExecutionContext createCopy(ISymbol iSymbol) {
        ExecutionContext executionContext = ExecutionContext.create(this.scope, this.outer, iSymbol);
        if (this.local != null) {
            executionContext.local = Collections.synchronizedMap(new HashMap());
            if (this.local != null) {
                executionContext.local.putAll(this.local);
            }
        }
        return executionContext;
    }

    @Override
    public ExecutionContext createChildContext(ISymbol iSymbol) {
        return ExecutionContext.create(this, iSymbol);
    }

    @Override
    public Map<? extends String, ? extends Object> getLocalVars() {
        return this.local == null ? Collections.EMPTY_MAP : this.local;
    }

    @Override
    public void clearLocalVars() {
        this.local = null;
    }

    @Override
    public void putLocalVar(String string, Object object) {
        if (this.local == null) {
            this.local = Collections.synchronizedMap(new HashMap());
        }
        this.local.put(string, object);
    }

    @Override
    public Object getLocalVar(String string) {
        if (this.local == null) {
            return null;
        }
        return this.local.get(string);
    }

    @Override
    public boolean hasLocalVar(String string) {
        if (this.local == null) {
            return false;
        }
        return this.local.containsKey(string);
    }

    @Override
    public void removeLocalVar(String string) {
        if (this.local == null) {
            return;
        }
        this.local.remove(string);
    }

    public String toString() {
        return "execution context " + String.valueOf(this.local);
    }

    @Override
    public ISymbol getCurrentSymbol() {
        return this.command;
    }

    @Override
    public void setCurrentSymbol(ISymbol iSymbol) {
        this.command = iSymbol;
    }
}

