/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.geometry.AxisAngle;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.geometry.GeometryUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.GamaShapeFactory;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.file.GamaGeometryFile;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import org.locationtech.jts.geom.Geometry;

public abstract class Gama3DGeometryFile
extends GamaGeometryFile {
    protected AxisAngle initRotation;
    protected Envelope3D envelope;

    public Gama3DGeometryFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string);
    }

    public Gama3DGeometryFile(IScope iScope, String string, GamaPair<Double, GamaPoint> gamaPair) throws GamaRuntimeException {
        super(iScope, string);
        if (gamaPair != null) {
            Double d = Cast.asFloat(null, gamaPair.key);
            GamaPoint gamaPoint = (GamaPoint)gamaPair.value;
            this.initRotation = new AxisAngle(gamaPoint, d);
        } else {
            this.initRotation = null;
        }
    }

    @Override
    protected IShape buildGeometry(IScope iScope) {
        ArrayList<Geometry> arrayList = new ArrayList<Geometry>();
        for (IShape iShape : ((IList)this.getBuffer()).iterable(iScope)) {
            arrayList.add(iShape.getInnerGeometry());
        }
        return GamaShapeFactory.createFrom(GeometryUtils.GEOMETRY_FACTORY.buildGeometry(arrayList));
    }

    @Override
    public AxisAngle getInitRotation() {
        return this.initRotation;
    }

    public void setInitRotation(AxisAngle axisAngle) {
        this.initRotation = axisAngle;
    }

    @Override
    public Envelope3D computeEnvelope(IScope iScope) {
        if (this.envelope == null) {
            this.fillBuffer(iScope);
            if (this.initRotation != null && this.initRotation.angle != 0.0) {
                this.envelope = this.envelope.rotate(this.initRotation);
            }
        }
        return this.envelope;
    }

    @Override
    public boolean is2D() {
        return false;
    }
}

