/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.common.interfaces.IStatusDisplayer;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import javax.imageio.ImageReader;
import javax.imageio.event.IIOReadProgressListener;
import org.geotools.util.SimpleInternationalString;
import org.opengis.util.InternationalString;
import org.opengis.util.ProgressListener;

public class ProgressCounter
implements ProgressListener,
IIOReadProgressListener {
    final IScope scope;
    final String name;
    float progress;

    public ProgressCounter(IScope iScope, String string) {
        this.scope = iScope;
        this.name = string;
    }

    IStatusDisplayer getDisplayer() {
        return GAMA.getGui().getStatus();
    }

    public void complete() {
        this.getDisplayer().setTaskCompletion(this.name, 1.0);
    }

    public void dispose() {
        this.getDisplayer().endTask(this.name, "status/status.download");
    }

    public void exceptionOccurred(Throwable throwable) {
        GAMA.reportAndThrowIfNeeded(this.scope, GamaRuntimeException.create(throwable, this.scope), true);
    }

    public float getProgress() {
        return this.progress;
    }

    public InternationalString getTask() {
        return new SimpleInternationalString(this.name);
    }

    public boolean isCanceled() {
        return this.scope.interrupted();
    }

    public void progress(float f) {
        this.progress = f;
        this.getDisplayer().setTaskCompletion(this.name, Double.valueOf(this.progress));
    }

    public void setCanceled(boolean bl) {
        this.getDisplayer().endTask(this.name, "status/status.download");
    }

    public void setTask(InternationalString internationalString) {
    }

    public void started() {
        this.getDisplayer().beginTask(this.name, "status/status.download");
    }

    public void warningOccurred(String string, String string2, String string3) {
        GAMA.reportAndThrowIfNeeded(this.scope, GamaRuntimeException.warning(string3, this.scope), false);
    }

    @Override
    public void sequenceStarted(ImageReader imageReader, int n) {
    }

    @Override
    public void sequenceComplete(ImageReader imageReader) {
    }

    @Override
    public void imageStarted(ImageReader imageReader, int n) {
        this.getDisplayer().beginTask(this.name, "status/status.download");
    }

    @Override
    public void imageProgress(ImageReader imageReader, float f) {
        this.progress(f);
    }

    @Override
    public void imageComplete(ImageReader imageReader) {
        this.getDisplayer().setTaskCompletion(this.name, 1.0);
        this.getDisplayer().endTask(this.name, "status/status.download");
    }

    @Override
    public void thumbnailStarted(ImageReader imageReader, int n, int n2) {
    }

    @Override
    public void thumbnailProgress(ImageReader imageReader, float f) {
    }

    @Override
    public void thumbnailComplete(ImageReader imageReader) {
    }

    @Override
    public void readAborted(ImageReader imageReader) {
        this.getDisplayer().endTask(this.name, "status/status.download");
    }
}

