/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.FlowStatus;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.statements.AbstractStatementSequence;
import gama.gaml.statements.IStatement;
import gama.gaml.types.Types;
import java.util.EnumSet;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="from", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the lower bound of the loop")}), @GamlAnnotations.facet(name="to", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the higher bound of the loop")}), @GamlAnnotations.facet(name="step", type={1, 2}, optional=true, doc={@GamlAnnotations.doc(value="an int or float expression that represents the incrementation of the loop")}), @GamlAnnotations.facet(name="name", type={-204}, optional=true, doc={@GamlAnnotations.doc(value="a temporary variable name")}), @GamlAnnotations.facet(name="over", type={16, 7}, optional=true, doc={@GamlAnnotations.doc(value="a list, point, matrix or map expression")}), @GamlAnnotations.facet(name="while", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean expression")}), @GamlAnnotations.facet(name="times", type={1}, optional=true, doc={@GamlAnnotations.doc(value="an int expression")})}, omissible="name")
@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.doc(value="Allows the agent toExpression perform the same set of statements either a fixed number of times, or while a condition is true, or by progressing in a collection of elements or along an interval of numbers. Be aware that there are no prevention of infinite loops. As a consequence, open loops should be used with caution, as one agent may block the execution of the whole model.", usages={@GamlAnnotations.usage(value="The basic syntax for repeating a fixed number of times a set of statements is:", examples={@GamlAnnotations.example(value="loop times: an_int_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumTimes <- 1;", isTestOnly=true), @GamlAnnotations.example(value="loop times: 3 {sumTimes <- sumTimes + sumTimes;}", isTestOnly=true), @GamlAnnotations.example(var="sumTimes", equals="8", isTestOnly=true)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements while a condition holds is:", examples={@GamlAnnotations.example(value="loop while: a_bool_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumWhile <- 1;", isTestOnly=true), @GamlAnnotations.example(value="loop while: (sumWhile < 5) {sumWhile <- sumWhile + sumWhile;}", isTestOnly=true), @GamlAnnotations.example(var="sumWhile", equals="8", isTestOnly=true)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements by progressing over a container of a point is:", examples={@GamlAnnotations.example(value="loop a_temp_var over: a_collection_expression {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="The basic syntax for repeating a set of statements while an index iterates over a range of values with a fixed stepExpression of 1 is:", examples={@GamlAnnotations.example(value="loop a_temp_var fromExpression: int_expression_1 toExpression: int_expression_2 {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="The incrementation stepExpression of the index can also be chosen:", examples={@GamlAnnotations.example(value="loop a_temp_var fromExpression: int_expression_1 toExpression: int_expression_2 stepExpression: int_expression3 {", isExecutable=false), @GamlAnnotations.example(value="     // [statements]", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false), @GamlAnnotations.example(value="int sumFor <- 0;", isTestOnly=true), @GamlAnnotations.example(value="loop i fromExpression: 10 toExpression: 30 stepExpression: 10 {sumFor <- sumFor + i;}", isTestOnly=true), @GamlAnnotations.example(var="sumFor", equals="60", isTestOnly=true)}), @GamlAnnotations.usage(value="In these latter three cases, the name facet designates the name of a temporary variable, whose scope is the loop, and that takes, in turn, the value of each of the element of the list (or each value in the interval). For example, in the first instance of the \"loop over\" syntax :", examples={@GamlAnnotations.example(value="int a <- 0;"), @GamlAnnotations.example(value="loop i over: [10, 20, 30] {"), @GamlAnnotations.example(value="     a <- a + i;"), @GamlAnnotations.example(value="} // a now equals 60"), @GamlAnnotations.example(var="a", equals="60", isTestOnly=true)}), @GamlAnnotations.usage(value="The second (quite common) case of the loop syntax allows one toExpression use an interval of integers or floats. The fromExpression and toExpression facets take an int or float expression as arguments, with the first (resp. the last) specifying the beginning (resp. end) of the inclusive interval (i.e. [toExpression, fromExpression]). If the stepExpression is not defined, it is assumed toExpression be equal toExpression 1 or -1, depending on the direction of the range. If it is defined, its sign will be respected, so that a positive stepExpression will never allow the loop toExpression enter a loop fromExpression i toExpression j where i is greater than j", examples={@GamlAnnotations.example(value="list the_list <-list (species_of (self));"), @GamlAnnotations.example(value="loop i fromExpression: 0 toExpression: length (the_list) - 1 {"), @GamlAnnotations.example(value="     ask the_list at i {"), @GamlAnnotations.example(value="        // ..."), @GamlAnnotations.example(value="     }"), @GamlAnnotations.example(value="} // every  agent of the list is asked toExpression do something")})})
@serializer(value=LoopSerializer.class)
@validator(value=LoopValidator.class)
public class LoopStatement
extends AbstractStatementSequence
implements IStatement.Breakable {
    private final LoopExecuter executer;
    private final String varName;
    static final EnumSet<FlowStatus> BREAK_STATUSES = EnumSet.of(FlowStatus.BREAK, FlowStatus.RETURN, FlowStatus.DIE, FlowStatus.DISPOSE);

    public LoopStatement(IDescription iDescription) {
        super(iDescription);
        IExpression iExpression = this.getFacet("over");
        IExpression iExpression2 = this.getFacet("times");
        IExpression iExpression3 = this.getFacet("while");
        boolean bl = iExpression3 != null;
        boolean bl2 = iExpression != null;
        IExpression iExpression4 = this.getFacet("from");
        IExpression iExpression5 = this.getFacet("to");
        IExpression iExpression6 = this.getFacet("step");
        boolean bl3 = iExpression4 != null && iExpression5 != null;
        boolean bl4 = bl3 && iExpression4.getGamlType() == Types.INT && iExpression5.getGamlType() == Types.INT && (iExpression6 == null || iExpression6.getGamlType() == Types.INT);
        this.varName = iDescription.getName();
        this.executer = bl ? new While(iExpression3) : (bl2 ? new Over(iExpression) : (bl3 ? (bl4 ? new IntBounded(iExpression4, iExpression5, iExpression6) : new FloatBounded(iExpression4, iExpression5, iExpression6)) : new Times(iExpression2)));
    }

    @Override
    public void enterScope(IScope iScope) {
    }

    @Override
    public void leaveScope(IScope iScope) {
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        try {
            Object object = this.executer.runIn(iScope);
            return object;
        }
        finally {
            iScope.getAndClearBreakStatus();
        }
    }

    protected FlowStatus loopBody(IScope iScope, Object object, Object[] objectArray) {
        iScope.push(this);
        try {
            if (this.varName != null) {
                iScope.setVarValue(this.varName, object, true);
            }
            objectArray[0] = super.privateExecuteIn(iScope);
        }
        finally {
            iScope.pop(this);
        }
        return iScope.getAndClearContinueStatus();
    }

    abstract class Bounded<T extends Number>
    implements LoopExecuter {
        protected final IExpression fromExpression;
        protected final IExpression toExpression;
        protected final IExpression stepExpression;
        protected final boolean stepDefined;
        protected final T constantFrom;
        protected final T constantTo;
        protected final T constantStep;

        Bounded(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws GamaRuntimeException {
            this.fromExpression = iExpression;
            this.toExpression = iExpression2;
            this.stepExpression = iExpression3;
            this.stepDefined = iExpression3 != null;
            IScope iScope = null;
            this.constantFrom = iExpression.isConst() ? this.value(iScope, iExpression) : null;
            this.constantTo = iExpression2.isConst() ? this.value(iScope, iExpression2) : null;
            this.constantStep = iExpression3 == null ? this.defaultStep() : (iExpression3.isConst() ? this.value(iScope, iExpression3) : null);
        }

        abstract T value(IScope var1, IExpression var2);

        abstract T defaultStep();

        T computeFrom(IScope iScope) {
            return this.constantFrom == null ? this.value(iScope, this.fromExpression) : this.constantFrom;
        }

        T computeTo(IScope iScope) {
            return this.constantTo == null ? this.value(iScope, this.toExpression) : this.constantTo;
        }

        T computeStep(IScope iScope) {
            return this.constantStep == null ? this.value(iScope, this.stepExpression) : this.constantStep;
        }

        int stepSign(boolean bl) {
            return bl && !this.stepDefined ? -1 : 1;
        }
    }

    class FloatBounded
    extends Bounded<Double> {
        FloatBounded(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws GamaRuntimeException {
            super(iExpression, iExpression2, iExpression3);
        }

        @Override
        Double defaultStep() {
            return 1.0;
        }

        @Override
        protected Double value(IScope iScope, IExpression iExpression) {
            return Cast.asFloat(iScope, iExpression.value(iScope));
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            double d;
            Object[] objectArray = new Object[1];
            double d2 = (Double)this.computeFrom(iScope);
            boolean bl = d2 > (d = ((Double)this.computeTo(iScope)).doubleValue());
            double d3 = (Double)this.computeStep(iScope) * (double)this.stepSign(bl);
            double d4 = d2;
            while (!(bl ? !(d4 >= d) : !(d4 <= d))) {
                if (BREAK_STATUSES.contains((Object)LoopStatement.this.loopBody(iScope, d4, objectArray))) break;
                d4 += d3;
            }
            return objectArray[0];
        }
    }

    class IntBounded
    extends Bounded<Integer> {
        IntBounded(IExpression iExpression, IExpression iExpression2, IExpression iExpression3) throws GamaRuntimeException {
            super(iExpression, iExpression2, iExpression3);
        }

        @Override
        protected Integer value(IScope iScope, IExpression iExpression) {
            return Cast.asInt(iScope, iExpression.value(iScope));
        }

        @Override
        Integer defaultStep() {
            return 1;
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            int n;
            Object[] objectArray = new Object[1];
            int n2 = (Integer)this.computeFrom(iScope);
            boolean bl = n2 > (n = ((Integer)this.computeTo(iScope)).intValue());
            int n3 = (Integer)this.computeStep(iScope) * this.stepSign(bl);
            int n4 = n2;
            while (!(bl ? n4 < n : n4 > n)) {
                if (BREAK_STATUSES.contains((Object)LoopStatement.this.loopBody(iScope, n4, objectArray))) break;
                n4 += n3;
            }
            return objectArray[0];
        }
    }

    static interface LoopExecuter {
        public Object runIn(IScope var1);
    }

    public static class LoopSerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected String serializeFacetValue(SymbolDescription symbolDescription, String string, boolean bl) {
            if ("name".equals(string) && (symbolDescription.hasFacet("times") || symbolDescription.hasFacet("while"))) {
                return null;
            }
            return super.serializeFacetValue(symbolDescription, string, bl);
        }
    }

    public static class LoopValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            IExpressionDescription iExpressionDescription = iDescription.getFacet("times");
            IExpressionDescription iExpressionDescription2 = iDescription.getFacet("over");
            IExpressionDescription iExpressionDescription3 = iDescription.getFacet("from");
            IExpressionDescription iExpressionDescription4 = iDescription.getFacet("to");
            IExpressionDescription iExpressionDescription5 = iDescription.getFacet("while");
            IExpressionDescription iExpressionDescription6 = iDescription.getFacet("name");
            if (iExpressionDescription6 != null && iExpressionDescription6.isConst() && iExpressionDescription6.toString().startsWith("_internal_")) {
                iExpressionDescription6 = null;
            }
            if (iExpressionDescription6 != null) {
                IDescriptionValidator.Assert.nameIsValid(iDescription);
            }
            if (iExpressionDescription != null) {
                this.processTimes(iDescription, iExpressionDescription2, iExpressionDescription3, iExpressionDescription4, iExpressionDescription5, iExpressionDescription6);
            } else if (iExpressionDescription2 != null) {
                this.processOver(iDescription, iExpressionDescription3, iExpressionDescription4, iExpressionDescription5, iExpressionDescription6);
            } else if (iExpressionDescription5 != null) {
                this.processCond(iDescription, iExpressionDescription3, iExpressionDescription4, iExpressionDescription6);
            } else if (iExpressionDescription3 != null) {
                this.processFromTo(iDescription, iExpressionDescription4, iExpressionDescription6);
            } else if (iExpressionDescription4 != null) {
                iDescription.error("'loop' is missing the 'fromExpression:' facet", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "from", "0");
            } else {
                iDescription.error("Missing the definition of the kind of loop toExpression perform (times, over, while, fromExpression/toExpression)", "gaml.missing.facet.issue");
            }
        }

        private void processFromTo(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2) {
            if (iExpressionDescription2 == null) {
                iDescription.error("No variable has been declared", "gaml.missing.name.issue", "name", new String[0]);
                return;
            }
            if (iExpressionDescription == null) {
                iDescription.error("'loop' is missing the 'toExpression:' facet", "gaml.missing.facet.issue", iDescription.getUnderlyingElement(), "to", "0");
            }
        }

        private void processCond(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3) {
            if (iExpressionDescription != null) {
                iDescription.error("'while' and 'fromExpression' are not compatible", "gaml.conflicting.facets", "while", "from");
            }
            if (iExpressionDescription2 != null) {
                iDescription.error("'while' and 'toExpression' are not compatible", "gaml.conflicting.facets", "while", "to");
            }
            if (iExpressionDescription3 != null) {
                iDescription.error("No variable should be declared", "gaml.unused.code.issue", "while", "name");
            }
        }

        private void processOver(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3, IExpressionDescription iExpressionDescription4) {
            if (iExpressionDescription3 != null) {
                iDescription.error("'over' and 'while' are not compatible", "gaml.conflicting.facets", "over", "while");
            } else if (iExpressionDescription != null) {
                iDescription.error("'over' and 'fromExpression' are not compatible", "gaml.conflicting.facets", "over", "from");
            } else if (iExpressionDescription2 != null) {
                iDescription.error("'over' and 'toExpression' are not compatible", "gaml.conflicting.facets", "over", "to");
            }
            if (iExpressionDescription4 == null) {
                iDescription.error("No variable has been declared", "gaml.missing.name.issue", "over", new String[0]);
            }
        }

        private void processTimes(IDescription iDescription, IExpressionDescription iExpressionDescription, IExpressionDescription iExpressionDescription2, IExpressionDescription iExpressionDescription3, IExpressionDescription iExpressionDescription4, IExpressionDescription iExpressionDescription5) {
            if (iExpressionDescription != null) {
                iDescription.error("'times' and 'over' are not compatible", "gaml.conflicting.facets", "times", "over");
            } else if (iExpressionDescription4 != null) {
                iDescription.error("'times' and 'while' are not compatible", "gaml.conflicting.facets", "times", "while");
            } else if (iExpressionDescription2 != null) {
                iDescription.error("'times' and 'fromExpression' are not compatible", "gaml.conflicting.facets", "times", "from");
            } else if (iExpressionDescription3 != null) {
                iDescription.error("'times' and 'toExpression' are not compatible", "gaml.conflicting.facets", "times", "to");
            }
            if (iExpressionDescription5 != null) {
                iDescription.error("No variable should be declared", "gaml.unused.code.issue", "name", new String[0]);
            }
        }
    }

    class Over
    implements LoopExecuter {
        private final IExpression overExpression;

        Over(IExpression iExpression) {
            this.overExpression = LoopStatement.this.getFacet("over");
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Iterable<Object> iterable;
            Object[] objectArray = new Object[1];
            Object object = this.overExpression.value(iScope);
            if (!(object instanceof IContainer)) {
                iterable = Cast.asList(iScope, object);
            } else {
                IContainer iContainer = (IContainer)object;
                iterable = iContainer.iterable(iScope);
            }
            IList iList = iterable;
            for (Object t : iList) {
                if (!BREAK_STATUSES.contains((Object)LoopStatement.this.loopBody(iScope, t, objectArray))) continue;
            }
            return objectArray[0];
        }
    }

    class Times
    implements LoopExecuter {
        private final IExpression timesExpression;
        private Integer constantTimes;

        Times(IExpression iExpression) {
            this.timesExpression = iExpression;
            if (this.timesExpression.isConst()) {
                this.constantTimes = Types.INT.cast(null, this.timesExpression.getConstValue(), null, false);
            }
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Object[] objectArray = new Object[1];
            int n = this.constantTimes == null ? Cast.asInt(iScope, this.timesExpression.value(iScope)) : this.constantTimes;
            int n2 = 0;
            while (n2 < n) {
                if (BREAK_STATUSES.contains((Object)LoopStatement.this.loopBody(iScope, null, objectArray))) break;
                ++n2;
            }
            return objectArray[0];
        }
    }

    class While
    implements LoopExecuter {
        private final IExpression cond;

        While(IExpression iExpression) {
            this.cond = iExpression;
        }

        @Override
        public Object runIn(IScope iScope) throws GamaRuntimeException {
            Object[] objectArray = new Object[1];
            while (Cast.asBool(iScope, this.cond.value(iScope)).booleanValue()) {
                if (BREAK_STATUSES.contains((Object)LoopStatement.this.loopBody(iScope, null, objectArray))) break;
            }
            return objectArray[0];
        }
    }
}

