/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.gaml.expressions.IExpression;
import gama.gaml.types.GamaType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.ParametricType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="container", id=16, wraps={IContainer.class}, kind=102, concept={"type", "container"}, doc={@GamlAnnotations.doc(value="Generic super-type of all the container types (list, graph, matrix, etc.)")})
public class GamaContainerType<T extends IContainer<?, ?>>
extends GamaType<T>
implements IContainerType<T> {
    @Override
    @GamlAnnotations.doc(value="Allows to cast the argument to a container. If the argument is already a container, returns it, otherwise cast it to a list")
    public T cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return (T)this.cast(iScope, object, object2, (IType)this.getKeyType(), (IType)this.getContentType(), bl);
    }

    @Override
    public int getNumberOfParameters() {
        return 1;
    }

    @Override
    public T cast(IScope iScope, Object object, Object object2, IType<?> iType, IType<?> iType2, boolean bl) throws GamaRuntimeException {
        return (T)(object instanceof IContainer ? (IContainer)object : (IList)Types.get(5).cast(iScope, object, null, bl));
    }

    @Override
    public T getDefault() {
        return null;
    }

    @Override
    public IContainerType<T> getGamlType() {
        return this;
    }

    @Override
    public boolean isContainer() {
        return true;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public boolean isFixedLength() {
        return false;
    }

    @Override
    public IType<?> contentsTypeIfCasting(IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        if (iType.isContainer() || iType.isAgentType() || iType.isCompoundType()) {
            return iType.getContentType();
        }
        return iType;
    }

    @Override
    public IContainerType<?> typeIfCasting(IExpression iExpression) {
        return (IContainerType)super.typeIfCasting(iExpression);
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    public IContainerType<?> of(IType<?> iType) {
        IType<?> iType2 = this.getKeyType();
        IType<?> iType3 = iType;
        if (iType3 == Types.NO_TYPE) {
            if (iType2 == Types.NO_TYPE) {
                return this;
            }
            iType3 = this.getContentType();
        }
        return ParametricType.createParametricType(this, iType2, iType3);
    }

    @Override
    public IContainerType<?> of(IType<?> iType, IType<?> iType2) {
        IType<?> iType3 = iType;
        IType<?> iType4 = iType2;
        if (iType4 == Types.NO_TYPE) {
            if (iType3 == Types.NO_TYPE) {
                return this;
            }
            iType4 = this.getContentType();
        }
        if (iType3 == Types.NO_TYPE) {
            iType3 = this.getKeyType();
        }
        return ParametricType.createParametricType(this, iType3, iType4);
    }
}

