/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.GamaDate;
import gama.dependencies.kml.AltitudeMode;
import gama.dependencies.kml.ColorMode;
import gama.dependencies.kml.Document;
import gama.dependencies.kml.Feature;
import gama.dependencies.kml.Folder;
import gama.dependencies.kml.IconStyle;
import gama.dependencies.kml.Kml;
import gama.dependencies.kml.LinearRing;
import gama.dependencies.kml.Link;
import gama.dependencies.kml.Location;
import gama.dependencies.kml.Model;
import gama.dependencies.kml.MultiGeometry;
import gama.dependencies.kml.Orientation;
import gama.dependencies.kml.Placemark;
import gama.dependencies.kml.Scale;
import gama.dependencies.kml.Style;
import gama.dev.DEBUG;
import gama.gaml.operators.spatial.SpatialProjections;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.MultiPoint;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.Polygon;

public class GamaKmlExport {
    private final Kml kml = new Kml();
    private final Document doc = this.kml.createAndSetDocument();
    private KmlFolder defolder;
    private final HashMap<String, KmlFolder> folders = new HashMap();

    public KmlFolder addFolder(String string, GamaDate gamaDate, GamaDate gamaDate2) {
        KmlFolder kmlFolder = new KmlFolder(this.doc, string, this.dateToKml(gamaDate), this.dateToKml(gamaDate2));
        this.folders.put(string, kmlFolder);
        return kmlFolder;
    }

    public void add3DModel(IScope iScope, GamaPoint gamaPoint, double d, double d2, GamaDate gamaDate, GamaDate gamaDate2, String string) {
        this.getDefaultFolder().add3DModel(iScope, gamaPoint, d, d2, this.dateToKml(gamaDate), this.dateToKml(gamaDate2), string);
    }

    public void addGeometry(IScope iScope, String string, GamaDate gamaDate, GamaDate gamaDate2, IShape iShape, String string2, double d) {
        this.getDefaultFolder().addGeometry(iScope, string, this.dateToKml(gamaDate), this.dateToKml(gamaDate2), iShape, string2, d);
    }

    public void defStyle(String string, double d, GamaColor gamaColor, GamaColor gamaColor2) {
        Style style = this.doc.createAndAddStyle().withId(string);
        style.createAndSetLineStyle().withColor(this.kmlColor(gamaColor)).withWidth(d);
        style.createAndSetPolyStyle().withColor(this.kmlColor(gamaColor2)).withColorMode(ColorMode.NORMAL);
    }

    private static String toHex2Digit(int n) {
        String string = "";
        if (n % 256 < 16) {
            string = "0";
        }
        return string + Integer.toHexString(n % 256);
    }

    public String kmlColor(GamaColor gamaColor) {
        return GamaKmlExport.toHex2Digit(gamaColor.alpha()) + GamaKmlExport.toHex2Digit(gamaColor.blue()) + GamaKmlExport.toHex2Digit(gamaColor.green()) + GamaKmlExport.toHex2Digit(gamaColor.red());
    }

    public void defIconStyle(String string, String string2, double d, double d2) {
        Style style = this.doc.createAndAddStyle().withId(string);
        IconStyle iconStyle = style.createAndSetIconStyle().withScale(d).withHeading(d2);
        iconStyle.createAndSetIcon().withHref(string2);
    }

    public void saveAsKml(IScope iScope, String string) {
        try {
            if (!string.isEmpty()) {
                this.kml.marshal(new File(string));
            } else {
                DEBUG.OUT((Object)"Failed to save the kml file : no valid file name was provided.");
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw GamaRuntimeException.error("Failed to open " + string + " for saving to KML.", iScope);
        }
    }

    public void saveAsKmz(IScope iScope, String string) {
        try {
            if (!string.isEmpty()) {
                this.kml.marshalAsKmz(string, new Kml[0]);
            } else {
                DEBUG.OUT((Object)"Failed to save the kmz file : no valid file name was provided.");
            }
        }
        catch (IOException iOException) {
            throw GamaRuntimeException.error("Failed to open " + string + " for saving to KMZ.", iScope);
        }
    }

    public void hideFolder(String string) {
        KmlFolder kmlFolder = this.getFolder(string);
        kmlFolder.setVisibility(false);
    }

    public void showFolder(String string) {
        KmlFolder kmlFolder = this.getFolder(string);
        kmlFolder.setVisibility(true);
    }

    protected KmlFolder getDefaultFolder() {
        if (this.defolder == null) {
            this.defolder = new KmlFolder(this.doc, "kml");
            this.folders.put("kml", this.defolder);
        }
        return this.defolder;
    }

    protected KmlFolder getFolder(String string) {
        KmlFolder kmlFolder = this.folders.get(string);
        if (kmlFolder == null) {
            kmlFolder = new KmlFolder(this.doc, string);
            this.folders.put(string, kmlFolder);
        }
        return kmlFolder;
    }

    protected String dateToKml(GamaDate gamaDate) {
        return gamaDate.toISOString();
    }

    public void addLabel(IScope iScope, GamaPoint gamaPoint, GamaDate gamaDate, GamaDate gamaDate2, String string, String string2, String string3) {
        this.getDefaultFolder().addLabel(iScope, gamaPoint, this.dateToKml(gamaDate), this.dateToKml(gamaDate2), string, string2, string3);
    }

    public void addLabel(IScope iScope, String string, GamaPoint gamaPoint, GamaDate gamaDate, GamaDate gamaDate2, String string2, String string3, String string4) {
        this.getFolder(string).addLabel(iScope, gamaPoint, this.dateToKml(gamaDate), this.dateToKml(gamaDate2), string2, string3, string4);
    }

    public class KmlFolder {
        private static final String EPSG_4326 = "EPSG:4326";
        Folder fold;
        static final String ERR_HEADER = "Kml Export: ";

        public KmlFolder(Document document, String string, String string2, String string3) {
            this.fold = document.createAndAddFolder();
            this.fold.withName(string).createAndSetTimeSpan().withBegin(string2).withEnd(string3);
        }

        public KmlFolder(Document document, String string) {
            this.fold = document.createAndAddFolder();
            this.fold.withName(string);
        }

        public void addLabel(IScope iScope, GamaPoint gamaPoint, String string, String string2, String string3, String string4, String string5) {
            Placemark placemark = this.fold.createAndAddPlacemark().withStyleUrl("#" + string5);
            placemark.createAndSetTimeSpan().withBegin(string).withEnd(string2);
            gama.dependencies.kml.Point point = placemark.createAndSetPoint();
            point.setExtrude(Boolean.valueOf(true));
            point.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            GamaPoint gamaPoint2 = SpatialProjections.transform_CRS(iScope, gamaPoint, EPSG_4326).getCentroid();
            point.addToCoordinates(gamaPoint2.x, gamaPoint2.y, gamaPoint2.z);
            placemark.setName(string3);
            placemark.setDescription(string4);
        }

        public void add3DModel(IScope iScope, GamaPoint gamaPoint, double d, double d2, String string, String string2, String string3) {
            Placemark placemark = this.fold.createAndAddPlacemark();
            placemark.createAndSetTimeSpan().withBegin(string).withEnd(string2);
            Model model = placemark.createAndSetModel();
            model.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
            GamaPoint gamaPoint2 = SpatialProjections.transform_CRS(iScope, gamaPoint, EPSG_4326).getCentroid();
            Location location = new Location();
            location.setLongitude(gamaPoint2.x);
            location.setLatitude(gamaPoint2.y);
            location.setAltitude(gamaPoint2.z);
            model.setLocation(location);
            model.setScale(new Scale().withX(d2).withY(d2).withZ(d2));
            model.setLink(new Link().withHref(string3));
            model.setOrientation(new Orientation().withHeading(d));
        }

        public void addGeometry(IScope iScope, String string, String string2, String string3, IShape iShape, String string4, double d) {
            Placemark placemark = this.fold.createAndAddPlacemark().withStyleUrl("#" + string4);
            placemark.setName(string);
            placemark.createAndSetTimeSpan().withBegin(string2).withEnd(string3);
            IShape iShape2 = SpatialProjections.transform_CRS(iScope, iShape, EPSG_4326);
            Geometry geometry = iShape2.getInnerGeometry();
            if (geometry instanceof Point) {
                Point point = (Point)geometry;
                this.addPoint(placemark, point, d);
            } else if (geometry instanceof LineString) {
                LineString lineString = (LineString)geometry;
                this.addLine(placemark, lineString, d);
            } else if (geometry instanceof Polygon) {
                Polygon polygon = (Polygon)geometry;
                this.addPolygon(placemark, polygon, d);
            } else if (geometry instanceof MultiPoint) {
                MultiPoint multiPoint = (MultiPoint)geometry;
                this.addMultiPoint(placemark, multiPoint, d);
            } else if (geometry instanceof MultiLineString) {
                MultiLineString multiLineString = (MultiLineString)geometry;
                this.addMultiLine(placemark, multiLineString, d);
            } else if (geometry instanceof MultiPolygon) {
                MultiPolygon multiPolygon = (MultiPolygon)geometry;
                this.addMultiPolygon(placemark, multiPolygon, d);
            }
        }

        public void setVisibility(boolean bl) {
            this.fold.setVisibility(Boolean.valueOf(bl));
            for (Feature feature : this.fold.getFeature()) {
                feature.setVisibility(Boolean.valueOf(bl));
            }
        }

        public void addPoint(Placemark placemark, Point point, double d) {
            gama.dependencies.kml.Point point2 = placemark.createAndSetPoint();
            this.fillPoint(point2, point, d);
        }

        public void fillPoint(gama.dependencies.kml.Point point, Point point2, double d) {
            Coordinate coordinate = point2.getCoordinate();
            if (d > 0.0) {
                point.setExtrude(Boolean.valueOf(true));
                point.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
                point.addToCoordinates(coordinate.x, coordinate.y, d);
            } else {
                point.addToCoordinates(coordinate.x, coordinate.y);
            }
        }

        public void addLine(Placemark placemark, LineString lineString, double d) {
            gama.dependencies.kml.LineString lineString2 = placemark.createAndSetLineString();
            this.fillLine(lineString2, lineString, d);
        }

        public void fillLine(gama.dependencies.kml.LineString lineString, LineString lineString2, double d) {
            if (d > 0.0) {
                lineString.setExtrude(Boolean.valueOf(true));
                lineString.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
                Coordinate[] coordinateArray = lineString2.getCoordinates();
                int n = coordinateArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Coordinate coordinate = coordinateArray[n2];
                    lineString.addToCoordinates(coordinate.x, coordinate.y, d);
                    ++n2;
                }
            } else {
                Coordinate[] coordinateArray = lineString2.getCoordinates();
                int n = coordinateArray.length;
                int n3 = 0;
                while (n3 < n) {
                    Coordinate coordinate = coordinateArray[n3];
                    lineString.addToCoordinates(coordinate.x, coordinate.y);
                    ++n3;
                }
            }
        }

        public void addPolygon(Placemark placemark, Polygon polygon, double d) {
            gama.dependencies.kml.Polygon polygon2 = placemark.createAndSetPolygon();
            this.fillPolygon(polygon2, polygon, d);
        }

        public void fillPolygon(gama.dependencies.kml.Polygon polygon, Polygon polygon2, double d) {
            LinearRing linearRing = polygon.createAndSetOuterBoundaryIs().createAndSetLinearRing();
            if (d > 0.0) {
                polygon.setExtrude(Boolean.valueOf(true));
                polygon.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
                var9_5 = polygon2.getExteriorRing().getCoordinates();
                var8_7 = var9_5.length;
                var7_10 = 0;
                while (var7_10 < var8_7) {
                    var6_12 = var9_5[var7_10];
                    linearRing.addToCoordinates(var6_12.x, var6_12.y, d);
                    ++var7_10;
                }
            } else {
                polygon.setTessellate(Boolean.valueOf(true));
                var9_5 = polygon2.getExteriorRing().getCoordinates();
                var8_7 = var9_5.length;
                var7_10 = 0;
                while (var7_10 < var8_7) {
                    var6_12 = var9_5[var7_10];
                    linearRing.addToCoordinates(var6_12.x, var6_12.y);
                    ++var7_10;
                }
            }
            int n = 0;
            while (n < polygon2.getNumInteriorRing()) {
                LinearRing linearRing2 = polygon.createAndAddInnerBoundaryIs().createAndSetLinearRing();
                if (d > 0.0) {
                    polygon.setExtrude(Boolean.valueOf(true));
                    polygon.setAltitudeMode(AltitudeMode.RELATIVE_TO_GROUND);
                    var11_15 = polygon2.getInteriorRingN(n).getCoordinates();
                    var10_14 = var11_15.length;
                    var9_6 = 0;
                    while (var9_6 < var10_14) {
                        Coordinate coordinate = var11_15[var9_6];
                        linearRing2.addToCoordinates(coordinate.x, coordinate.y, d);
                        ++var9_6;
                    }
                } else {
                    polygon.setTessellate(Boolean.valueOf(true));
                    var11_15 = polygon2.getInteriorRingN(n).getCoordinates();
                    var10_14 = var11_15.length;
                    var9_6 = 0;
                    while (var9_6 < var10_14) {
                        Coordinate coordinate = var11_15[var9_6];
                        linearRing2.addToCoordinates(coordinate.x, coordinate.y);
                        ++var9_6;
                    }
                }
                ++n;
            }
        }

        public void addMultiPoint(Placemark placemark, MultiPoint multiPoint, double d) {
            int n = multiPoint.getNumGeometries();
            MultiGeometry multiGeometry = placemark.createAndSetMultiGeometry();
            int n2 = 0;
            while (n2 < n) {
                gama.dependencies.kml.Point point = multiGeometry.createAndAddPoint();
                this.fillPoint(point, (Point)multiPoint.getGeometryN(n2), d);
                ++n2;
            }
        }

        public void addMultiLine(Placemark placemark, MultiLineString multiLineString, double d) {
            int n = multiLineString.getNumGeometries();
            MultiGeometry multiGeometry = placemark.createAndSetMultiGeometry();
            int n2 = 0;
            while (n2 < n) {
                gama.dependencies.kml.LineString lineString = multiGeometry.createAndAddLineString();
                this.fillLine(lineString, (LineString)multiLineString.getGeometryN(n2), d);
                ++n2;
            }
        }

        public void addMultiPolygon(Placemark placemark, MultiPolygon multiPolygon, double d) {
            int n = multiPolygon.getNumGeometries();
            MultiGeometry multiGeometry = placemark.createAndSetMultiGeometry();
            int n2 = 0;
            while (n2 < n) {
                gama.dependencies.kml.Polygon polygon = multiGeometry.createAndAddPolygon();
                this.fillPolygon(polygon, (Polygon)multiPolygon.getGeometryN(n2), d);
                ++n2;
            }
        }
    }
}

