/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulationSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.expressions.IExpression;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.type(name="species", id=14, wraps={ISpecies.class}, kind=104, concept={"type", "species"}, doc={@GamlAnnotations.doc(value="Meta-type of the species present in the GAML language")})
public class GamaSpeciesType
extends GamaContainerType<ISpecies> {
    @Override
    @GamlAnnotations.doc(value="casting of the operand to a species.", usages={@GamlAnnotations.usage(value="if the operand is nil, returns nil;"), @GamlAnnotations.usage(value="if the operand is an agent, returns its species;"), @GamlAnnotations.usage(value="if the operand is a string, returns the species with this name (nil if not found);"), @GamlAnnotations.usage(value="otherwise, returns nil")}, examples={@GamlAnnotations.example(value="species(self)", equals="the species of the current agent", isExecutable=false), @GamlAnnotations.example(value="species('node')", equals="node", isExecutable=false), @GamlAnnotations.example(value="species([1,5,9,3])", equals="nil", isExecutable=false), @GamlAnnotations.example(value="species(node1)", equals="node", isExecutable=false)})
    public ISpecies cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        ISpecies iSpecies;
        ISpecies iSpecies2 = object == null ? this.getDefault() : (object instanceof ISpecies ? (ISpecies)object : (object instanceof IAgent ? ((IAgent)object).getSpecies() : (object instanceof String ? (iScope.getModel() != null ? iScope.getModel().getSpecies((String)object) : this.getDefault()) : (iSpecies = this.getDefault()))));
        if (object instanceof IPopulationSet) {
            iSpecies = ((IPopulationSet)object).getSpecies();
        }
        return iSpecies;
    }

    @Override
    public ISpecies cast(IScope iScope, Object object, Object object2, IType iType, IType iType2, boolean bl) {
        ISpecies iSpecies = this.cast(iScope, object, object2, bl);
        if (iSpecies == null && iType2.isAgentType()) {
            return iScope.getModel().getSpecies(iType2.getName());
        }
        return iSpecies;
    }

    @Override
    public ISpecies getDefault() {
        return null;
    }

    @Override
    public IType getContentType() {
        return Types.get(11);
    }

    @Override
    public IType getKeyType() {
        return Types.INT;
    }

    @Override
    public boolean isDrawable() {
        return true;
    }

    @Override
    public IType contentsTypeIfCasting(IExpression iExpression) {
        IType<?> iType = iExpression.getGamlType();
        if (iType.isAgentType()) {
            return iType;
        }
        switch (iExpression.getGamlType().id()) {
            case 14: {
                return iType.getContentType();
            }
            case 4: {
                return Types.AGENT;
            }
        }
        return iExpression.getGamlType();
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }
}

