/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.core.kernel.experiment.ExperimentAgent;
import gama.core.kernel.experiment.IExperimentController;
import gama.core.kernel.experiment.IExperimentPlan;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;

public class HeadlessExperimentController
implements IExperimentController {
    private final IExperimentPlan experiment;
    private ExperimentAgent agent;

    public HeadlessExperimentController(IExperimentPlan iExperimentPlan) {
        this.experiment = iExperimentPlan;
    }

    @Override
    public IExperimentPlan getExperiment() {
        return this.experiment;
    }

    @Override
    public void close() {
        this.experiment.dispose();
    }

    @Override
    public void schedule(ExperimentAgent experimentAgent) {
        block3: {
            this.agent = experimentAgent;
            IScope iScope = experimentAgent.getScope();
            try {
                if (!iScope.init(experimentAgent).passed()) {
                    iScope.setDisposeStatus();
                }
            }
            catch (Throwable throwable) {
                if (throwable instanceof GamaRuntimeException) break block3;
                GAMA.reportError(iScope, GamaRuntimeException.create(throwable, iScope), true);
            }
        }
    }

    @Override
    public void dispose() {
        this.agent = null;
    }

    @Override
    public boolean processOpen(boolean bl) {
        return true;
    }

    @Override
    public boolean processPause(boolean bl) {
        return true;
    }

    @Override
    public boolean processReload(boolean bl) {
        return true;
    }

    @Override
    public boolean processStep(boolean bl) {
        return true;
    }

    @Override
    public boolean processBack(boolean bl) {
        return true;
    }

    @Override
    public boolean processStartPause(boolean bl) {
        return true;
    }

    @Override
    public boolean processStart(boolean bl) {
        if (this.agent == null) {
            return false;
        }
        IScope iScope = this.agent.getScope();
        try {
            while (iScope.step(this.agent).passed()) {
            }
        }
        catch (Throwable throwable) {
            if (!(throwable instanceof GamaRuntimeException)) {
                GAMA.reportError(iScope, GamaRuntimeException.create(throwable, iScope), true);
            }
            return false;
        }
        return true;
    }
}

