/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import gama.core.kernel.simulation.SimulationAgent;
import gama.core.metamodel.topology.grid.IDiffusionTarget;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;

public class FieldDiffuser {
    static LoadingCache<SimulationAgent, FieldDiffuser> CACHE = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<SimulationAgent, FieldDiffuser>(){

        public FieldDiffuser load(SimulationAgent simulationAgent) {
            FieldDiffuser fieldDiffuser = new FieldDiffuser(simulationAgent.getScope());
            DEBUG.OUT((Object)("Field Diffuser created for " + String.valueOf(simulationAgent)));
            simulationAgent.postEndAction(iScope -> fieldDiffuser.diffuse());
            simulationAgent.postDisposeAction(iScope -> {
                CACHE.invalidate((Object)simulationAgent);
                return null;
            });
            return fieldDiffuser;
        }
    });
    protected final ListMultimap<DiffusionContext, GridDiffusion> diffusionsMap = MultimapBuilder.hashKeys((int)10).arrayListValues().build();
    protected DiffusionContext context;
    protected GridDiffusion diffusion;
    private float proportion;
    final IScope scope;
    double[] input;
    double[] output;

    public static FieldDiffuser getDiffuser(IScope iScope) {
        try {
            return (FieldDiffuser)CACHE.get((Object)iScope.getSimulation());
        }
        catch (ExecutionException executionException) {
            executionException.printStackTrace();
            return null;
        }
    }

    public boolean compareArrays(double[][] dArray, double[][] dArray2) {
        if (dArray == null) {
            return dArray2 == null;
        }
        if (dArray2 == null || dArray.length != dArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            if (!Arrays.equals(dArray[n], dArray2[n])) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public void addDiffusion(String string, IDiffusionTarget iDiffusionTarget, boolean bl, boolean bl2, double[][] dArray, double[][] dArray2, double d, boolean bl3) {
        GridDiffusion gridDiffusion = new GridDiffusion(bl, bl2, dArray, dArray2, d, bl3);
        DiffusionContext diffusionContext = new DiffusionContext(this.scope, string, iDiffusionTarget);
        if (this.diffusionsMap.containsKey((Object)diffusionContext)) {
            List list = this.diffusionsMap.get((Object)diffusionContext);
            for (GridDiffusion gridDiffusion2 : list) {
                if (gridDiffusion2 == gridDiffusion || gridDiffusion2.useConvolution != gridDiffusion.useConvolution || !this.compareArrays(gridDiffusion2.mask, gridDiffusion.mask) || gridDiffusion2.isGradient != gridDiffusion.isGradient || gridDiffusion2.avoidMask != gridDiffusion.avoidMask) continue;
                this.diffusionsMap.remove((Object)diffusionContext, (Object)gridDiffusion2);
                int n = gridDiffusion2.diffusionMatrix.length;
                int n2 = 0;
                int n3 = 0;
                if (gridDiffusion2.diffusionMatrix.length < gridDiffusion.diffusionMatrix.length) {
                    n = gridDiffusion.diffusionMatrix.length;
                    n2 = (gridDiffusion.diffusionMatrix.length - gridDiffusion2.diffusionMatrix.length) / 2;
                } else if (gridDiffusion2.diffusionMatrix.length > gridDiffusion.diffusionMatrix.length) {
                    n = gridDiffusion.diffusionMatrix.length;
                    n3 = (gridDiffusion2.diffusionMatrix.length - gridDiffusion.diffusionMatrix.length) / 2;
                }
                int n4 = gridDiffusion2.diffusionMatrix[0].length;
                int n5 = 0;
                int n6 = 0;
                if (gridDiffusion2.diffusionMatrix[0].length < gridDiffusion.diffusionMatrix[0].length) {
                    n4 = gridDiffusion.diffusionMatrix[0].length;
                    n5 = (gridDiffusion.diffusionMatrix[0].length - gridDiffusion2.diffusionMatrix[0].length) / 2;
                } else if (gridDiffusion2.diffusionMatrix[0].length > gridDiffusion.diffusionMatrix[0].length) {
                    n4 = gridDiffusion2.diffusionMatrix[0].length;
                    n6 = (gridDiffusion2.diffusionMatrix[0].length - gridDiffusion.diffusionMatrix[0].length) / 2;
                }
                double[][] dArray3 = new double[n][n4];
                int n7 = 0;
                while (n7 < n) {
                    int n8 = 0;
                    while (n8 < n4) {
                        double d2 = 0.0;
                        int n9 = gridDiffusion2.diffusionMatrix.length - n + n7 + n2;
                        int n10 = gridDiffusion2.diffusionMatrix[0].length - n4 + n8 + n5;
                        if (n9 >= 0 && n9 < gridDiffusion2.diffusionMatrix.length && n10 >= 0 && n10 < gridDiffusion2.diffusionMatrix[0].length) {
                            d2 += gridDiffusion2.diffusionMatrix[n9][n10];
                        }
                        int n11 = gridDiffusion.diffusionMatrix.length - n + n7 + n3;
                        int n12 = gridDiffusion.diffusionMatrix[0].length - n4 + n8 + n6;
                        if (n11 >= 0 && n11 < gridDiffusion.diffusionMatrix.length && n12 >= 0 && n12 < gridDiffusion.diffusionMatrix[0].length) {
                            d2 += gridDiffusion.diffusionMatrix[n11][n12];
                        }
                        dArray3[n7][n8] = d2;
                        ++n8;
                    }
                    ++n7;
                }
                gridDiffusion.diffusionMatrix = dArray3;
            }
        }
        this.diffusionsMap.put((Object)diffusionContext, (Object)gridDiffusion);
    }

    public FieldDiffuser(IScope iScope) {
        this.scope = iScope;
    }

    public void loadGridProperties(DiffusionContext diffusionContext) {
        this.context = diffusionContext;
    }

    public boolean loadDiffProperties(GridDiffusion gridDiffusion) {
        this.diffusion = gridDiffusion;
        if (gridDiffusion.avoidMask) {
            this.proportion = 0.0f;
            double[][] dArray = this.diffusion.diffusionMatrix;
            int n = this.diffusion.diffusionMatrix.length;
            int n2 = 0;
            while (n2 < n) {
                double[] dArray2 = dArray[n2];
                int n3 = 0;
                while (n3 < this.diffusion.diffusionMatrix[0].length) {
                    this.proportion = (float)((double)this.proportion + dArray2[n3]);
                    ++n3;
                }
                ++n2;
            }
        }
        this.context.target.getValuesInto(this.scope, this.context.varName, this.diffusion.minValue, this.input);
        return true;
    }

    public void diffusionWithConvolution() {
        int n = this.diffusion.diffusionMatrix.length;
        int n2 = this.diffusion.diffusionMatrix[0].length;
        int n3 = n2 / 2;
        int n4 = n / 2;
        int n5 = 0;
        while (n5 < this.context.nbCols) {
            int n6 = 0;
            while (n6 < this.context.nbRows) {
                double d = 0.0;
                ArrayList<int[]> arrayList = new ArrayList<int[]>();
                int n7 = 0;
                while (n7 < n) {
                    int n8 = 0;
                    while (n8 < n2) {
                        int n9 = n5 + n8 - n3;
                        int n10 = n6 + n7 - n4;
                        if (this.context.isTorus) {
                            if (n9 < 0) {
                                n9 = this.context.nbRows + n9;
                            } else if (n9 >= this.context.nbRows) {
                                n9 -= this.context.nbRows;
                            }
                            if (n10 < 0) {
                                n10 = this.context.nbCols + n10;
                            } else if (n10 >= this.context.nbCols) {
                                n10 -= this.context.nbCols;
                            }
                        }
                        if (n9 >= 0 && n9 < this.context.nbCols && n10 >= 0 && n10 < this.context.nbRows && (this.diffusion.mask == null || this.diffusion.mask[n9][n10] == 1.0)) {
                            double d2 = this.output[n6 * this.context.nbCols + n5];
                            if (this.output[n6 * this.context.nbCols + n5] == -1.7976931348623157E308) {
                                this.output[n6 * this.context.nbCols + n5] = this.input[n10 * this.context.nbCols + n9] * this.diffusion.diffusionMatrix[n - n7 - 1][n2 - n8 - 1];
                            } else if (this.diffusion.isGradient) {
                                if (this.output[n6 * this.context.nbCols + n5] < this.input[n10 * this.context.nbCols + n9] * this.diffusion.diffusionMatrix[n - n7 - 1][n2 - n8 - 1]) {
                                    this.output[n6 * this.context.nbCols + n5] = this.input[n10 * this.context.nbCols + n9] * this.diffusion.diffusionMatrix[n - n7 - 1][n2 - n8 - 1];
                                }
                            } else {
                                int n11 = n6 * this.context.nbCols + n5;
                                this.output[n11] = this.output[n11] + this.input[n10 * this.context.nbCols + n9] * this.diffusion.diffusionMatrix[n - n7 - 1][n2 - n8 - 1];
                            }
                            if (this.diffusion.avoidMask && this.diffusion.mask != null && this.diffusion.mask[n5][n6] != 1.0) {
                                d += this.output[n6 * this.context.nbCols + n5];
                                this.output[n6 * this.context.nbCols + n5] = d2;
                                if (this.diffusion.mask[n9][n10] == 1.0) {
                                    arrayList.add(new int[]{n9, n10});
                                }
                            }
                        }
                        ++n8;
                    }
                    ++n7;
                }
                if (d != 0.0) {
                    double d3 = d * (double)this.proportion / (double)arrayList.size();
                    for (int[] nArray : arrayList) {
                        if (this.output[nArray[1] * this.context.nbCols + nArray[0]] == -1.7976931348623157E308) {
                            this.output[nArray[1] * this.context.nbCols + nArray[0]] = d3;
                            continue;
                        }
                        if (this.diffusion.isGradient) continue;
                        int n12 = nArray[1] * this.context.nbCols + nArray[0];
                        this.output[n12] = this.output[n12] + d3;
                    }
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void diffusionWithDotProduct() {
        int n = this.diffusion.diffusionMatrix.length;
        int n2 = this.diffusion.diffusionMatrix[0].length;
        int n3 = n2 / 2;
        int n4 = n / 2;
        int n5 = 0;
        while (n5 < this.context.nbRows) {
            int n6 = 0;
            while (n6 < this.context.nbCols) {
                if (this.diffusion.mask == null || this.diffusion.mask[n5][n6] == 1.0) {
                    double d = 0.0;
                    ArrayList<int[]> arrayList = new ArrayList<int[]>();
                    int n7 = 0;
                    while (n7 < n) {
                        int n8 = 0;
                        while (n8 < n2) {
                            int n9 = n5 + n8 - n3;
                            int n10 = n6 + n7 - n4;
                            if (this.context.isTorus) {
                                if (n9 < 0) {
                                    n9 = this.context.nbRows + n9;
                                } else if (n9 >= this.context.nbRows) {
                                    n9 -= this.context.nbRows;
                                }
                                if (n10 < 0) {
                                    n10 = this.context.nbCols + n10;
                                } else if (n10 >= this.context.nbCols) {
                                    n10 -= this.context.nbCols;
                                }
                            }
                            if (n9 >= 0 && n9 < this.context.nbCols && n10 >= 0 && n10 < this.context.nbRows) {
                                double d2 = this.output[n10 * this.context.nbCols + n9];
                                int n11 = n10 * this.context.nbCols + n9;
                                int n12 = n6 * this.context.nbCols + n5;
                                double d3 = this.diffusion.diffusionMatrix[n7][n8];
                                if (this.output[n11] == -1.7976931348623157E308) {
                                    this.output[n11] = this.input[n12] * d3;
                                } else if (this.diffusion.isGradient) {
                                    if (this.output[n11] < this.input[n12] * d3) {
                                        this.output[n11] = this.input[n12] * d3;
                                    }
                                } else {
                                    int n13 = n11;
                                    this.output[n13] = this.output[n13] + this.input[n12] * d3;
                                }
                                if (this.diffusion.avoidMask && this.diffusion.mask != null && this.diffusion.mask[n9][n10] != 1.0) {
                                    d += this.output[n11];
                                    this.output[n11] = d2;
                                    if (this.diffusion.mask[n5][n6] == 1.0) {
                                        arrayList.add(new int[]{n5, n6});
                                    }
                                }
                            }
                            ++n8;
                        }
                        ++n7;
                    }
                    if (d != 0.0) {
                        double d4 = d * (double)this.proportion / (double)arrayList.size();
                        for (int[] nArray : arrayList) {
                            if (this.output[nArray[1] * this.context.nbCols + nArray[0]] == -1.7976931348623157E308) {
                                this.output[nArray[1] * this.context.nbCols + nArray[0]] = d4;
                                continue;
                            }
                            if (this.diffusion.isGradient) continue;
                            int n14 = nArray[1] * this.context.nbCols + nArray[0];
                            this.output[n14] = this.output[n14] + d4;
                        }
                    }
                }
                ++n6;
            }
            ++n5;
        }
    }

    public void finishDiffusion() {
        int n = 0;
        while (n < this.output.length) {
            block2: {
                double d;
                block4: {
                    block3: {
                        d = this.output[n];
                        if (d == -1.7976931348623157E308) break block2;
                        if (!this.diffusion.isGradient) break block3;
                        if (d <= this.input[n]) break block2;
                        if (d < this.diffusion.minValue) {
                            d = 0.0;
                        }
                        break block4;
                    }
                    d = Math.max(d, this.diffusion.minValue);
                }
                this.context.target.setValueAtIndex(this.scope, n, this.context.varName, d);
            }
            ++n;
        }
    }

    public Object diffuse() throws GamaRuntimeException {
        if (this.scope == null || this.scope.interrupted()) {
            return false;
        }
        this.diffusionsMap.asMap().forEach((diffusionContext, collection) -> {
            this.loadGridProperties((DiffusionContext)diffusionContext);
            int n = diffusionContext.nbCols * diffusionContext.nbRows;
            if (this.input != null && this.input.length == n) {
                Arrays.fill(this.input, 0.0);
            } else {
                this.input = new double[diffusionContext.nbCols * diffusionContext.nbRows];
                this.output = new double[diffusionContext.nbCols * diffusionContext.nbRows];
            }
            Arrays.fill(this.output, -1.7976931348623157E308);
            collection.forEach(gridDiffusion -> {
                this.loadDiffProperties((GridDiffusion)gridDiffusion);
                if (!gridDiffusion.useConvolution) {
                    this.diffusionWithDotProduct();
                } else {
                    this.diffusionWithConvolution();
                }
                this.finishDiffusion();
            });
        });
        this.diffusionsMap.clear();
        return null;
    }

    private static class DiffusionContext {
        int nbRows;
        int nbCols;
        boolean isTorus;
        IDiffusionTarget target;
        final String varName;

        public DiffusionContext(IScope iScope, String string, IDiffusionTarget iDiffusionTarget) {
            this.varName = string;
            this.nbRows = iDiffusionTarget.getRows(iScope);
            this.nbCols = iDiffusionTarget.getCols(iScope);
            this.isTorus = iScope.getSimulation().getTopology().isTorus();
            this.target = iDiffusionTarget;
        }

        public int hashCode() {
            return this.varName.hashCode() + this.target.hashCode();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof DiffusionContext)) {
                return false;
            }
            DiffusionContext diffusionContext = (DiffusionContext)object;
            return diffusionContext.varName.equals(this.varName) && diffusionContext.target.equals(this.target);
        }
    }

    private static class GridDiffusion {
        public boolean useConvolution = true;
        public boolean isGradient;
        public double[][] mask;
        public double[][] diffusionMatrix;
        public double minValue;
        public boolean avoidMask;

        public GridDiffusion(boolean bl, boolean bl2, double[][] dArray, double[][] dArray2, double d, boolean bl3) {
            this.useConvolution = bl;
            this.diffusionMatrix = dArray;
            this.mask = dArray2;
            this.isGradient = bl2;
            this.minValue = d;
            this.avoidMask = bl3;
        }
    }
}

