/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.grid;

import com.google.common.base.Predicates;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import gama.core.common.geometry.Envelope3D;
import gama.core.metamodel.agent.AbstractAgent;
import gama.core.metamodel.agent.GamlAgent;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.agent.IMacroAgent;
import gama.core.metamodel.population.GamaPopulation;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.population.PopulationNotifier;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.grid.GamaSpatialMatrix;
import gama.core.metamodel.topology.grid.GamlGridAgent;
import gama.core.metamodel.topology.grid.GridTopology;
import gama.core.metamodel.topology.grid.IGrid;
import gama.core.metamodel.topology.grid.IGridAgent;
import gama.core.metamodel.topology.grid.MinimalGridAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.file.GamaGridFile;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonObject;
import gama.core.util.matrix.IMatrix;
import gama.dev.DEBUG;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.ISpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.statements.RemoteSequence;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;

public class GridPopulation
implements IPopulation<IGridAgent> {
    private final PopulationNotifier notifier = new PopulationNotifier();
    GamaSpatialMatrix grid;
    protected IMacroAgent host;
    protected ITopology topology;
    protected final ISpecies species;
    protected final IVariable[] orderedVars;
    protected final IVariable[] updatableVars;
    protected final IContainerType<?> type;
    private final int hashCode;
    private final boolean isInitOverriden;
    private final boolean isStepOverriden;
    public final LinkedHashSet<String> orderedVarNames = new LinkedHashSet();
    protected int currentAgentIndex;

    static {
        DEBUG.OFF();
    }

    public static ITopology buildGridTopology(IScope iScope, ISpecies iSpecies, IAgent iAgent) {
        GridTopology gridTopology;
        IExpression iExpression = iSpecies.getFacet("width");
        Envelope3D envelope3D = iScope.getSimulation().getGeometry().getEnvelope();
        int n = iExpression == null ? (iSpecies.hasFacet("cell_width") ? (int)(envelope3D.getWidth() / Cast.asFloat(iScope, iSpecies.getFacet("cell_width").value(iScope))) : 100) : Cast.asInt(iScope, iExpression.value(iScope));
        iExpression = iSpecies.getFacet("height");
        int n2 = iExpression == null ? (iSpecies.hasFacet("cell_height") ? (int)(envelope3D.getHeight() / Cast.asFloat(iScope, iSpecies.getFacet("cell_height").value(iScope))) : 100) : Cast.asInt(iScope, iExpression.value(iScope));
        boolean bl = iAgent.getTopology().isTorus();
        iExpression = iSpecies.getFacet("use_individual_shapes");
        boolean bl2 = iExpression == null || Cast.asBool(iScope, iExpression.value(iScope)) != false;
        iExpression = iSpecies.getFacet("use_neighbors_cache");
        boolean bl3 = iExpression == null || Cast.asBool(iScope, iExpression.value(iScope)) != false;
        iExpression = iSpecies.getFacet("horizontal_orientation");
        boolean bl4 = iExpression == null || Cast.asBool(iScope, iExpression.value(iScope)) != false;
        iExpression = iSpecies.getFacet("optimizer");
        String string = iExpression == null ? "" : Cast.asString(iScope, iExpression.value(iScope));
        iExpression = iSpecies.getFacet("neighbors");
        boolean bl5 = iExpression == null || Cast.asInt(iScope, iExpression.value(iScope)) == 4;
        boolean bl6 = iExpression != null && Cast.asInt(iScope, iExpression.value(iScope)) == 6;
        iExpression = iSpecies.getFacet("files");
        List list = null;
        if (iExpression != null) {
            list = Cast.asList(iScope, iExpression.value(iScope));
        }
        if (list != null && !list.isEmpty()) {
            gridTopology = new GridTopology(iScope, (IShape)iAgent, (IList<GamaGridFile>)list, bl, bl5, bl2, bl3, string);
        } else {
            iExpression = iSpecies.getFacet("file");
            GamaGridFile gamaGridFile = (GamaGridFile)(iExpression != null ? iExpression.value(iScope) : null);
            gridTopology = gamaGridFile == null ? new GridTopology(iScope, iAgent, n, n2, bl, bl5, bl6, bl4, bl2, bl3, string) : new GridTopology(iScope, (IShape)iAgent, gamaGridFile, bl, bl5, bl2, bl3, string);
        }
        return gridTopology;
    }

    private GridPopulation(IMacroAgent iMacroAgent, ISpecies iSpecies) {
        Object object;
        this.host = iMacroAgent;
        this.species = iSpecies;
        SpeciesDescription speciesDescription = iSpecies.getDescription();
        IVariable[] iVariableArray = this.orderedVars = GamaPopulation.orderAttributes(this, speciesDescription, (com.google.common.base.Predicate<VariableDescription>)Predicates.alwaysTrue(), VariableDescription.INIT_DEPENDENCIES_FACETS);
        int n = this.orderedVars.length;
        int n2 = 0;
        while (n2 < n) {
            object = iVariableArray[n2];
            this.orderedVarNames.add(object.getName());
            ++n2;
        }
        this.updatableVars = GamaPopulation.orderAttributes(this, speciesDescription, (com.google.common.base.Predicate<VariableDescription>)((com.google.common.base.Predicate)VariableDescription::isUpdatable), VariableDescription.UPDATE_DEPENDENCIES_FACETS);
        this.type = Types.LIST.of(speciesDescription.getModelDescription().getTypeNamed(iSpecies.getName()));
        this.hashCode = Objects.hash(this.getSpecies(), this.getHost());
        object = new boolean[2];
        iSpecies.getDescription().visitChildren(arg_0 -> GridPopulation.lambda$1((boolean[])object, arg_0));
        this.isInitOverriden = object[0];
        this.isStepOverriden = object[1];
    }

    public GridPopulation(GamaSpatialMatrix gamaSpatialMatrix, ITopology iTopology, IMacroAgent iMacroAgent, ISpecies iSpecies) {
        this(iMacroAgent, iSpecies);
        this.grid = gamaSpatialMatrix;
        this.topology = iTopology;
    }

    @Override
    public Stream<IGridAgent> stream() {
        StreamEx streamEx = StreamEx.of((Object[])this.grid.matrix);
        return streamEx;
    }

    @Override
    public StreamEx<IGridAgent> stream(IScope iScope) {
        StreamEx streamEx = StreamEx.of((Object[])this.grid.matrix);
        return streamEx;
    }

    @Override
    public IList<IGridAgent> createAgents(IScope iScope, int n, List<? extends Map<String, Object>> list, boolean bl, boolean bl2, RemoteSequence remoteSequence) throws GamaRuntimeException {
        this.createAgents(iScope, null);
        for (Map<String, Object> map : list) {
            IAgent iAgent = this.getAgent((Integer)map.get("grid_x"), (Integer)map.get("grid_y"));
            if (iAgent == null) continue;
            iAgent.setAttributes(map);
        }
        return (IList)this.getAgents(iScope);
    }

    @Override
    public IList<IGridAgent> createAgents(IScope iScope, IContainer<?, ? extends IShape> iContainer) {
        int n = 0;
        while (n < this.grid.actualNumberOfCells) {
            IShape iShape = this.grid.matrix[n];
            Class<? extends IAgent> clazz = this.species.getDescription().getJavaBase();
            boolean bl = GamlAgent.class.isAssignableFrom(clazz);
            if (iShape != null) {
                AbstractAgent abstractAgent = bl ? new GamlGridAgent(this, n) : new MinimalGridAgent(this, n);
                this.grid.matrix[n] = abstractAgent;
            }
            ++n;
        }
        IVariable[] iVariableArray = this.orderedVars;
        int n2 = this.orderedVars.length;
        int n3 = 0;
        while (n3 < n2) {
            IVariable iVariable = iVariableArray[n3];
            int n4 = 0;
            while (n4 < this.grid.actualNumberOfCells) {
                IAgent iAgent = (IAgent)this.grid.matrix[n4];
                if (iAgent != null) {
                    iVariable.initializeWith(iScope, iAgent, null);
                }
                ++n4;
            }
            ++n3;
        }
        int n5 = 0;
        while (n5 < this.grid.actualNumberOfCells) {
            IAgent iAgent = (IAgent)this.grid.matrix[n5];
            if (iAgent != null) {
                iAgent.schedule(iScope);
            }
            ++n5;
        }
        this.notifier.notifyAgentsAdded(iScope, this, (IList)this.getAgents(iScope));
        return null;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return this.getName();
    }

    protected boolean stepAgents(IScope iScope) {
        return GamaExecutorService.step((IScope)iScope, (IShape[])this.grid.matrix, (ISpecies)this.getSpecies());
    }

    public int getNbCols() {
        return this.grid.numCols;
    }

    public int getNbRows() {
        return this.grid.numRows;
    }

    public IAgent getAgent(Integer n, Integer n2) {
        if (n >= this.getNbCols() || n < 0 || n2 >= this.getNbRows() || n2 < 0) {
            return null;
        }
        IShape iShape = this.grid.get(null, n, n2);
        return iShape == null ? null : iShape.getAgent();
    }

    public Double getGridValue(Integer n, Integer n2) {
        if (n >= this.getNbCols() || n < 0 || n2 >= this.getNbRows() || n2 < 0) {
            return 0.0;
        }
        return this.grid.getGridValue(n, n2);
    }

    @Override
    public IGridAgent getAgent(Integer n) {
        if (n >= this.size() || n < 0) {
            return null;
        }
        IShape iShape = this.grid.matrix[n];
        return (IGridAgent)(iShape == null ? null : iShape.getAgent());
    }

    @Override
    public IGridAgent getOrCreateAgent(IScope iScope, Integer n) {
        return this.getAgent(n);
    }

    @Override
    public boolean isGrid() {
        return true;
    }

    @Override
    public GridTopology getTopology() {
        return (GridTopology)this.topology;
    }

    @Override
    public void initializeFor(IScope iScope) throws GamaRuntimeException {
        this.topology.initialize(iScope, this);
    }

    @Override
    public IGridAgent getAgent(IScope iScope, GamaPoint gamaPoint) {
        return (IGridAgent)this.grid.getAgentAt(gamaPoint);
    }

    @Override
    public void killMembers() throws GamaRuntimeException {
        IShape[] iShapeArray = this.grid.matrix;
        int n = this.grid.matrix.length;
        int n2 = 0;
        while (n2 < n) {
            IShape iShape = iShapeArray[n2];
            if (iShape != null) {
                iShape.dispose();
            }
            ++n2;
        }
    }

    public synchronized IGridAgent[] toArray() {
        return (IGridAgent[])Arrays.copyOf(this.grid.matrix, this.grid.matrix.length, IGridAgent[].class);
    }

    @Override
    public void dispose() {
        this.killMembers();
        this.clear();
        if (this.topology != null) {
            this.topology.dispose();
            this.topology = null;
        }
    }

    @Override
    public int size() {
        return this.grid.actualNumberOfCells;
    }

    @Override
    public IGridAgent getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        if (iList == null) {
            return null;
        }
        int n = iList.length(iScope);
        if (n == 0) {
            return null;
        }
        int n2 = Cast.asInt(iScope, iList.get(iScope, 0));
        if (n == 1) {
            return this.getAgent(Cast.asInt(iScope, n2));
        }
        int n3 = Cast.asInt(iScope, iList.get(iScope, 1));
        IShape iShape = this.grid.get(iScope, n2, n3);
        if (iShape == null) {
            return null;
        }
        return (IGridAgent)iShape.getAgent();
    }

    @Override
    public IGridAgent get(IScope iScope, Integer n) throws GamaRuntimeException {
        return (IGridAgent)this.grid.matrix[n];
    }

    @Override
    public IGridAgent firstValue(IScope iScope) throws GamaRuntimeException {
        return (IGridAgent)this.grid._first(iScope);
    }

    @Override
    public IGridAgent lastValue(IScope iScope) throws GamaRuntimeException {
        return (IGridAgent)this.grid._last(iScope);
    }

    @Override
    public int length(IScope iScope) {
        return this.grid.actualNumberOfCells;
    }

    @Override
    public IGridAgent anyValue(IScope iScope) {
        return (IGridAgent)this.grid.anyValue(iScope);
    }

    @Override
    public Iterator<IGridAgent> iterator() {
        UnmodifiableIterator unmodifiableIterator = Iterators.forArray((Object[])this.grid.getMatrix());
        return unmodifiableIterator;
    }

    @Override
    public boolean containsKey(IScope iScope, Object object) {
        if (object instanceof Integer) {
            Integer n = (Integer)object;
            return IPopulation.super.containsKey(iScope, n);
        }
        if (object instanceof GamaPoint) {
            return this.grid.containsKey(iScope, object);
        }
        return false;
    }

    @Override
    public Iterable<IGridAgent> iterable(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false);
    }

    @Override
    public boolean isEmpty() {
        return this.grid._isEmpty(null);
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        return this.grid._isEmpty(iScope);
    }

    @Override
    public IList<IGridAgent> listValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        return this.grid._listValue(iScope, iType, false);
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, boolean bl) throws GamaRuntimeException {
        if (iType == null || iType.id() == 0 || iType.getSpeciesName() != null && iType.getSpeciesName().equals(this.getSpecies().getName())) {
            return this.grid;
        }
        return this.grid.matrixValue(iScope, iType, bl);
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) throws GamaRuntimeException {
        if (iType == null || iType.id() == 0 || iType.getSpeciesName() != null && iType.getSpeciesName().equals(this.getSpecies().getName())) {
            return this.grid;
        }
        return this.grid.matrixValue(iScope, iType, bl);
    }

    public void setGrid(IGrid iGrid) {
        this.grid = (GamaSpatialMatrix)iGrid;
        this.getTopology().setPlaces(iGrid);
    }

    @Override
    public int compareTo(IPopulation<IGridAgent> iPopulation) {
        return this.species == iPopulation.getSpecies() ? 0 : 1;
    }

    @Override
    public IContainerType<?> getGamlType() {
        return this.type;
    }

    @Override
    public boolean contains(Object object) {
        IGridAgent iGridAgent;
        return object instanceof IGridAgent && (iGridAgent = (IGridAgent)object).getPopulation() == this;
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return this.grid.matrix;
    }

    @Override
    public boolean add(IGridAgent iGridAgent) {
        return false;
    }

    @Override
    public boolean remove(Object object) {
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends IGridAgent> collection) {
        return false;
    }

    @Override
    public boolean addAll(int n, Collection<? extends IGridAgent> collection) {
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return false;
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        return false;
    }

    @Override
    public void clear() {
    }

    @Override
    public IGridAgent get(int n) {
        return (IGridAgent)this.grid.matrix[n];
    }

    @Override
    public IGridAgent set(int n, IGridAgent iGridAgent) {
        this.grid.matrix[n] = iGridAgent;
        return iGridAgent;
    }

    @Override
    public void add(int n, IGridAgent iGridAgent) {
    }

    @Override
    public IGridAgent remove(int n) {
        return null;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        while (n < this.grid.actualNumberOfCells) {
            if (this.grid.matrix[n] == object) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        return this.indexOf(object);
    }

    @Override
    public ListIterator<IGridAgent> listIterator() {
        ListIterator<IShape> listIterator = Arrays.asList(this.grid.matrix).listIterator(0);
        return listIterator;
    }

    @Override
    public ListIterator<IGridAgent> listIterator(int n) {
        ListIterator<IShape> listIterator = Arrays.asList(this.grid.matrix).listIterator(n);
        return listIterator;
    }

    @Override
    public List<IGridAgent> subList(int n, int n2) {
        List<IShape> list = Arrays.asList(this.grid.matrix).subList(n, n2);
        return list;
    }

    @Override
    public boolean init(IScope iScope) throws GamaRuntimeException {
        return true;
    }

    @Override
    public boolean step(IScope iScope) throws GamaRuntimeException {
        IExpression iExpression = this.species.getFrequency();
        if (iExpression != null) {
            int n = Cast.asInt(iScope, iExpression.value(iScope));
            int n2 = iScope.getClock().getCycle();
            if (n == 0 || n2 % n != 0) {
                return true;
            }
        }
        this.getSpecies().getArchitecture().preStep(iScope, this);
        return this.stepAgents(iScope);
    }

    @Override
    public Collection<? extends IPopulation<? extends IAgent>> getPopulations(IScope iScope) {
        return Collections.singleton(this);
    }

    @Override
    public boolean hasAgentList() {
        return true;
    }

    @Override
    public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
        IList<IShape> iList = GamaListFactory.create(iScope, this.getGamlType().getContentType(), this.grid.matrix);
        return iList;
    }

    @Override
    public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
        IAgent iAgent = iShape2.getAgent();
        if (iAgent == null || iAgent.getPopulation() != this || iAgent.dead()) {
            return false;
        }
        IAgent iAgent2 = iShape.getAgent();
        return iAgent != iAgent2;
    }

    @Override
    public void filter(IScope iScope, IShape iShape2, Collection<? extends IShape> collection) {
        IAgent iAgent = iShape2 == null ? null : iShape2.getAgent();
        collection.remove(iAgent);
        com.google.common.base.Predicate predicate = iShape -> {
            IAgent iAgent = iShape.getAgent();
            return iAgent == null || iAgent.dead() || iAgent.getPopulation() != this && (iAgent.getPopulation().getGamlType().getContentType() != this.getGamlType().getContentType() || !this.contains(iAgent));
        };
        collection.removeIf((Predicate<? extends IShape>)predicate);
    }

    @Override
    public void createVariablesFor(IScope iScope, IGridAgent iGridAgent) throws GamaRuntimeException {
        IVariable[] iVariableArray = this.orderedVars;
        int n = this.orderedVars.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable iVariable = iVariableArray[n2];
            iVariable.initializeWith(iScope, iGridAgent, null);
            ++n2;
        }
    }

    @Override
    public boolean hasVar(String string) {
        return this.species.getVar(string) != null;
    }

    @Override
    public IGridAgent createAgentAt(IScope iScope, int n, Map<String, Object> map, boolean bl, boolean bl2) throws GamaRuntimeException {
        ArrayList<Map<String, Object>> arrayList = new ArrayList<Map<String, Object>>();
        arrayList.add(map);
        int n2 = this.currentAgentIndex;
        this.currentAgentIndex = n;
        IList<IGridAgent> iList = this.createAgents(iScope, 1, arrayList, bl, bl2, null);
        this.currentAgentIndex = n2;
        return iList.firstValue(iScope);
    }

    @Override
    public String getName() {
        return this.species.getName();
    }

    @Override
    public boolean hasAspect(String string) {
        return this.species.hasAspect(string);
    }

    @Override
    public IExecutable getAspect(String string) {
        return this.species.getAspect(string);
    }

    @Override
    public Collection<String> getAspectNames() {
        return this.species.getAspectNames();
    }

    @Override
    public ISpecies getSpecies() {
        return this.species;
    }

    @Override
    public IVariable getVar(String string) {
        return this.species.getVar(string);
    }

    @Override
    public boolean hasUpdatableVariables() {
        return this.updatableVars.length > 0;
    }

    @Override
    public IMacroAgent getHost() {
        return this.host;
    }

    @Override
    public void setHost(IMacroAgent iMacroAgent) {
        this.host = iMacroAgent;
    }

    @Override
    public void addListener(IPopulation.Listener listener) {
        this.notifier.addListener(listener);
    }

    @Override
    public void removeListener(IPopulation.Listener listener) {
        this.notifier.removeListener(listener);
    }

    @Override
    public void updateVariables(IScope iScope, IAgent iAgent) {
        IVariable[] iVariableArray = this.updatableVars;
        int n = this.updatableVars.length;
        int n2 = 0;
        while (n2 < n) {
            IVariable iVariable = iVariableArray[n2];
            Throwable throwable = null;
            Object var8_9 = null;
            try (StopWatch stopWatch = GAMA.benchmark(iScope, iVariable);){
                iScope.setCurrentSymbol(iVariable);
                iScope.setAgentVarValue(iAgent, iVariable.getName(), iVariable.getUpdatedValue(iScope));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        iScope.setCurrentSymbol(null);
    }

    public String toString() {
        return "Population of " + this.species.getName();
    }

    @Override
    public boolean isInitOverriden() {
        return this.isInitOverriden;
    }

    @Override
    public boolean isStepOverriden() {
        return this.isStepOverriden;
    }

    @Override
    public final int hashCode() {
        return this.hashCode;
    }

    @Override
    public final boolean equals(Object object) {
        return object == this;
    }

    @Override
    public void removeAllOccurrencesOfValue(IScope iScope, Object object) {
    }

    @Override
    public void removeValues(IScope iScope, IContainer iContainer) {
    }

    @Override
    public void removeValue(IScope iScope, Object object) {
    }

    @Override
    public void addValues(IScope iScope, IContainer iContainer) {
    }

    @Override
    public void addValueAtIndex(IScope iScope, Object object, IGridAgent iGridAgent) {
    }

    @Override
    public void addValue(IScope iScope, IGridAgent iGridAgent) {
    }

    @Override
    public JsonObject serializeToJson(Json json) {
        return (JsonObject)IPopulation.super.serializeToJson(json).add("cols", json.valueOf(this.getNbCols())).add("rows", json.valueOf(this.getNbRows()));
    }

    private static /* synthetic */ boolean lambda$1(boolean[] blArray, IDescription iDescription) {
        if (iDescription instanceof ActionDescription && !iDescription.isBuiltIn()) {
            String string = iDescription.getName();
            if ("_init_".equals(string)) {
                blArray[0] = true;
            } else if ("_step_".equals(string)) {
                blArray[1] = true;
            }
        }
        return true;
    }
}

