/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import com.google.common.primitives.Ints;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.outputs.IOutput;
import gama.core.outputs.LayeredDisplayData;
import gama.core.outputs.LayeredDisplayOutput;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.expressions.IExpression;
import one.util.streamex.StreamEx;

@GamlAnnotations.inside(symbols={"display"})
public abstract class AbstractLayerStatement
extends Symbol
implements ILayerStatement {
    LayeredDisplayOutput output;

    public boolean isToCreate() {
        return true;
    }

    public AbstractLayerStatement(IDescription iDescription) throws GamaRuntimeException {
        super(iDescription);
        this.setName(iDescription.getName());
    }

    @Override
    public IExpression getRefreshFacet() {
        return this.getFacet("refresh");
    }

    @Override
    public int compareTo(ILayerStatement iLayerStatement) {
        return Ints.compare((int)this.getOrder(), (int)iLayerStatement.getOrder());
    }

    @Override
    public final boolean init(IScope iScope) {
        return this._init(iScope);
    }

    protected abstract boolean _init(IScope var1);

    @Override
    public void setDisplayOutput(IOutput iOutput) {
        this.output = (LayeredDisplayOutput)iOutput;
    }

    public LayeredDisplayOutput getDisplayOutput() {
        return this.output;
    }

    public LayeredDisplayData getLayeredDisplayData() {
        if (this.output == null) {
            return null;
        }
        return this.output.getData();
    }

    @Override
    public final boolean step(IScope iScope) throws GamaRuntimeException {
        if (!iScope.interrupted()) {
            return this._step(iScope);
        }
        return false;
    }

    protected abstract boolean _step(IScope var1);

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    public static class OpenGLSpecificLayerValidator
    implements IDescriptionValidator<StatementDescription> {
        void warnIfNotOpenGL(StatementDescription statementDescription) {
            IDescription iDescription = statementDescription.getEnclosingDescription();
            if (!this.isOpenGL(iDescription)) {
                statementDescription.warning(statementDescription.getKeyword() + " layers can only be used in OpenGL displays", "gaml.wrong.type.issue");
            }
        }

        private boolean isOpenGL(IDescription iDescription2) {
            boolean bl;
            IDescription iDescription3 = iDescription2;
            String string = iDescription3.getLitteral("type");
            if (string != null) {
                return "3d".equals(string) || "opengl".equals(string);
            }
            String string2 = iDescription3.getLitteral("parent");
            boolean bl2 = bl = !"2d".equals(GamaPreferences.Displays.CORE_DISPLAY.getValue());
            if (string2 == null) {
                return bl;
            }
            if ((iDescription3 = (IDescription)StreamEx.of(iDescription3.getEnclosingDescription().getChildrenWithKeyword("display").iterator()).findFirst(iDescription -> iDescription.getName().equals(string2)).get()) == null) {
                return bl;
            }
            return this.isOpenGL(iDescription3);
        }

        @Override
        public void validate(StatementDescription statementDescription) {
            this.warnIfNotOpenGL(statementDescription);
        }
    }
}

