/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.core.util.matrix.IMatrix;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaMatrixType;
import gama.gaml.types.IContainerType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Map;
import java.util.Objects;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="key", type=-399, doc={@GamlAnnotations.doc(value="Returns the key of this pair (can be nil)")}), @GamlAnnotations.variable(name="value", type=-299, doc={@GamlAnnotations.doc(value="Returns the value of this pair (can be nil)")})})
public class GamaPair<K, V>
implements IContainer<Integer, Object>,
IContainer.Addressable<Integer, Object>,
Map.Entry<K, V> {
    public static final String KEY = "key";
    public static final String VALUE = "value";
    private final IContainerType type;
    public K key;
    public V value;

    public GamaPair(K k, V v, IType iType, IType iType2) {
        this.key = k;
        this.value = v;
        this.type = Types.PAIR.of(iType, iType2);
    }

    public GamaPair(IScope iScope, K k, V v, IType iType, IType iType2) {
        this.key = iType.cast(iScope, k, null, false);
        this.value = iType2.cast(iScope, v, null, false);
        this.type = Types.PAIR.of(iType, iType2);
    }

    public boolean equals(GamaPair gamaPair) {
        return Objects.equals(this.key, gamaPair.key) && Objects.equals(this.value, gamaPair.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.key, this.value);
    }

    @Override
    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof GamaPair) {
            return this.equals((GamaPair)object);
        }
        return false;
    }

    @Override
    public IContainerType getGamlType() {
        return this.type;
    }

    @Override
    @GamlAnnotations.getter(value="key")
    public K getKey() {
        return this.key;
    }

    public K first() {
        return this.key;
    }

    @Override
    @GamlAnnotations.getter(value="value")
    public V getValue() {
        return this.value;
    }

    public V last() {
        return this.value;
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return Cast.asString(iScope, this.key) + "::" + Cast.asString(iScope, this.value);
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return StringUtils.toGaml(this.key, bl) + "::" + StringUtils.toGaml(this.value, bl);
    }

    public String toString() {
        return (this.key == null ? "nil" : this.key.toString()) + "::" + (this.value == null ? "nil" : this.value.toString());
    }

    @Override
    public GamaPair<K, V> copy(IScope iScope) {
        return new GamaPair<K, V>(this.key, this.value, this.type.getKeyType(), this.type.getContentType());
    }

    @Override
    public V setValue(V v) {
        this.value = v;
        return v;
    }

    @Override
    public Object get(IScope iScope, Integer n) throws GamaRuntimeException {
        return n == 0 ? this.key : this.value;
    }

    @Override
    public Object getFromIndicesList(IScope iScope, IList iList) throws GamaRuntimeException {
        return null;
    }

    @Override
    public boolean contains(IScope iScope, Object object) throws GamaRuntimeException {
        return object == null ? this.key == null || this.value == null : object.equals(this.key) || object.equals(this.value);
    }

    @Override
    public Object firstValue(IScope iScope) throws GamaRuntimeException {
        return this.key;
    }

    @Override
    public Object lastValue(IScope iScope) throws GamaRuntimeException {
        return this.value;
    }

    @Override
    public int length(IScope iScope) {
        return 2;
    }

    @Override
    public boolean isEmpty(IScope iScope) {
        return false;
    }

    @Override
    public IContainer reverse(IScope iScope) throws GamaRuntimeException {
        return new GamaPair<V, K>(this.value, this.key, this.type.getContentType(), this.type.getKeyType());
    }

    @Override
    public Object anyValue(IScope iScope) {
        int n = iScope.getRandom().between(0, 1);
        return n == 0 ? this.key : this.value;
    }

    @Override
    public IList listValue(IScope iScope, IType iType, boolean bl) {
        return GamaListFactory.wrap(iType, iType.cast(iScope, this.key, null, bl), iType.cast(iScope, this.value, null, bl));
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, boolean bl) {
        return GamaMatrixType.from(iScope, this.listValue(iScope, iType, bl), iType, null);
    }

    @Override
    public IMatrix matrixValue(IScope iScope, IType iType, GamaPoint gamaPoint, boolean bl) {
        return GamaMatrixType.from(iScope, this.listValue(iScope, iType, bl), iType, gamaPoint);
    }

    @Override
    public IMap mapValue(IScope iScope, IType iType, IType iType2, boolean bl) {
        IMap iMap = GamaMapFactory.create(iType, iType2);
        iMap.setValueAtIndex(iScope, (Object)this.key, this.value);
        return iMap;
    }

    @Override
    public Iterable iterable(IScope iScope) {
        return this.listValue(iScope, Types.NO_TYPE, false);
    }

    @Override
    public boolean containsKey(IScope iScope, Object object) throws GamaRuntimeException {
        return Objects.equals(this.key, object);
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), KEY, this.key, VALUE, this.value);
    }
}

