/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.core.util.file.IGamaFileMetaData;
import gama.dev.DEBUG;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;

public abstract class GamaFileMetaData
implements IGamaFileMetaData {
    public long fileModificationStamp;
    boolean hasFailed;

    public GamaFileMetaData(long l) {
        this.fileModificationStamp = l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T extends IGamaFileMetaData> T from(String string, long l, Class<T> clazz, boolean bl) {
        IGamaFileMetaData iGamaFileMetaData = null;
        try {
            Constructor<T> constructor = clazz.getDeclaredConstructor(String.class);
            iGamaFileMetaData = (IGamaFileMetaData)constructor.newInstance(string);
            boolean bl2 = iGamaFileMetaData.hasFailed();
            if (bl2 || bl || iGamaFileMetaData.getModificationStamp() == l) return (T)iGamaFileMetaData;
            return null;
        }
        catch (Exception exception) {
            DEBUG.ERR((Object)("Error loading metadata " + string + " : " + exception.getClass().getSimpleName() + ":" + exception.getMessage()));
            if (!(exception instanceof InvocationTargetException) || exception.getCause() == null) return (T)iGamaFileMetaData;
            exception.getCause().printStackTrace();
            return (T)iGamaFileMetaData;
        }
    }

    public GamaFileMetaData(String string) {
        String string2 = StringUtils.substringBefore((String)string, (String)"_!_");
        if ("failed".equals(string2)) {
            this.hasFailed = true;
        } else {
            this.fileModificationStamp = string2 == null || string2.isEmpty() ? 0L : Long.parseLong(string2);
        }
    }

    @Override
    public boolean hasFailed() {
        return this.hasFailed;
    }

    protected String[] split(String string) {
        return StringUtils.splitByWholeSeparatorPreserveAllTokens((String)string, (String)"_!_");
    }

    @Override
    public long getModificationStamp() {
        return this.fileModificationStamp;
    }

    @Override
    public Object getThumbnail() {
        return null;
    }

    @Override
    public String toPropertyString() {
        if (this.hasFailed) {
            return "failed";
        }
        return String.valueOf(this.fileModificationStamp);
    }

    @Override
    public void setModificationStamp(long l) {
        this.fileModificationStamp = l;
    }
}

