/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.core.util.file.GamaGisFile;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.wfs.GML;
import org.locationtech.jts.geom.Envelope;
import org.xml.sax.SAXException;

@GamlAnnotations.file(name="gml", extensions={"gml"}, buffer_type=5, buffer_content=13, buffer_index=1, concept={"gml", "file"}, doc={@GamlAnnotations.doc(value="Represents a Geography Markup Language (GML) file as defined by the Open Geospatial Consortium. See https://en.wikipedia.org/wiki/Geography_Markup_Language for more information.")})
public class GamaGMLFile
extends GamaGisFile {
    @GamlAnnotations.doc(value="This file constructor allows to read a gml file", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\");", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string) throws GamaRuntimeException {
        super(iScope, string, (Integer)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a gml file and specifying the coordinates system code, as an int (epsg code)", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\", 32648);", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string, Integer n) throws GamaRuntimeException {
        super(iScope, string, n);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a gml file and specifying the coordinates system code (epg,...,), as a string", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\", \"EPSG:32648\");", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string, String string2) throws GamaRuntimeException {
        super(iScope, string, string2);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a gml file and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\", true);", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string, boolean bl) throws GamaRuntimeException {
        super(iScope, string, (Integer)null, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a gml file, specifying the coordinates system code, as an int (epsg code) and take a potential z value (not taken in account by default)", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\", 32648, true);", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string, Integer n, boolean bl) throws GamaRuntimeException {
        super(iScope, string, n, bl);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read a gml file, specifying the coordinates system code (epg,...,), as a string and take a potential z value (not taken in account by default", examples={@GamlAnnotations.example(value="file f <- gml_file(\"file.gml\", \"EPSG:32648\",true);", isExecutable=false)})
    public GamaGMLFile(IScope iScope, String string, String string2, boolean bl) throws GamaRuntimeException {
        super(iScope, string, string2, bl);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.EMPTY_LIST;
    }

    @Override
    protected SimpleFeatureCollection getFeatureCollection(IScope iScope) {
        GML gML = new GML(GML.Version.GML3);
        try {
            SimpleFeatureCollection simpleFeatureCollection = gML.decodeFeatureCollection((InputStream)new FileInputStream(this.getFile(iScope)));
            this.computeProjection(iScope, Envelope3D.of((Envelope)simpleFeatureCollection.getBounds()));
            return simpleFeatureCollection;
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            throw GamaRuntimeException.create(exception, iScope);
        }
    }
}

