/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions;

import com.google.common.collect.Iterables;
import gama.core.common.interfaces.IDisposable;
import gama.core.common.interfaces.ITyped;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.IExecutionContext;
import gama.core.util.IMap;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.StringBasedExpressionDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IExpressionCompiler;
import gama.gaml.expressions.IExpressionFactory;
import gama.gaml.expressions.data.ListExpression;
import gama.gaml.expressions.data.MapExpression;
import gama.gaml.expressions.operators.PrimitiveOperator;
import gama.gaml.expressions.types.SkillConstantExpression;
import gama.gaml.expressions.types.SpeciesConstantExpression;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.expressions.variables.AgentVariableExpression;
import gama.gaml.expressions.variables.EachExpression;
import gama.gaml.expressions.variables.GlobalVariableExpression;
import gama.gaml.expressions.variables.MyselfExpression;
import gama.gaml.expressions.variables.SelfExpression;
import gama.gaml.expressions.variables.SuperExpression;
import gama.gaml.expressions.variables.TempVariableExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.statements.ActionStatement;
import gama.gaml.statements.Arguments;
import gama.gaml.types.IType;
import gama.gaml.types.Signature;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class GamlExpressionFactory
implements IExpressionFactory {
    static ThreadLocal<IExpressionCompiler> parser;

    static {
        DEBUG.ON();
    }

    public static void registerParserProvider(final ParserProvider parserProvider) {
        parser = new ThreadLocal(){

            protected IExpressionCompiler initialValue() {
                return parserProvider.get();
            }
        };
    }

    private IExpressionCompiler getParser() {
        return parser.get();
    }

    @Override
    public void resetParser() {
        parser.get().dispose();
        parser.remove();
    }

    @Override
    public UnitConstantExpression createUnit(Object object, IType iType, String string, String string2, String string3, boolean bl, String[] stringArray) {
        UnitConstantExpression unitConstantExpression = UnitConstantExpression.create(object, iType, string, string2, bl, stringArray);
        if (string3 != null && !string3.isEmpty()) {
            unitConstantExpression.setDeprecated(string3);
        }
        return unitConstantExpression;
    }

    @Override
    public ConstantExpression createConst(Object object, IType iType) {
        return this.createConst(object, iType, null);
    }

    @Override
    public SpeciesConstantExpression createSpeciesConstant(IType iType) {
        if (iType.getGamlType() != Types.SPECIES) {
            return null;
        }
        SpeciesDescription speciesDescription = iType.getContentType().getSpecies();
        if (speciesDescription == null) {
            return null;
        }
        return new SpeciesConstantExpression(speciesDescription.getName(), iType, speciesDescription);
    }

    @Override
    public ConstantExpression createConst(Object object, IType iType, String string) {
        if (iType.getGamlType() == Types.SPECIES) {
            return this.createSpeciesConstant(iType);
        }
        if (iType == Types.SKILL) {
            return new SkillConstantExpression((String)object, iType);
        }
        if (object == null) {
            return NIL_EXPR;
        }
        if (object instanceof Boolean) {
            return (Boolean)object != false ? TRUE_EXPR : FALSE_EXPR;
        }
        return new ConstantExpression(object, iType, string);
    }

    @Override
    public UnitConstantExpression getUnitExpr(String string) {
        return GAML.UNITS.get(string);
    }

    @Override
    public IExpression createExpr(IExpressionDescription iExpressionDescription, IDescription iDescription) {
        return this.getParser().compile(iExpressionDescription, iDescription);
    }

    @Override
    public IExpression createExpr(String string, IDescription iDescription) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return this.getParser().compile(StringBasedExpressionDescription.create(string), iDescription);
    }

    @Override
    public IExpression createExpr(String string, IDescription iDescription, IExecutionContext iExecutionContext) {
        if (string == null || string.isEmpty()) {
            return null;
        }
        return this.getParser().compile(string, iDescription, iExecutionContext);
    }

    @Override
    public Arguments createArgumentMap(ActionDescription actionDescription, IExpressionDescription iExpressionDescription, IDescription iDescription) {
        if (iExpressionDescription == null) {
            return null;
        }
        return this.getParser().parseArguments(actionDescription, iExpressionDescription.getTarget(), iDescription, false);
    }

    @Override
    public IExpression createVar(String string, IType iType, boolean bl, int n, IDescription iDescription) {
        return switch (n) {
            case 0 -> GlobalVariableExpression.create(string, iType, bl, iDescription.getModelDescription());
            case 1 -> new AgentVariableExpression(string, iType, bl, iDescription);
            case 2 -> new TempVariableExpression(string, iType, iDescription);
            case 3 -> new EachExpression(string, iType);
            case 4 -> new SelfExpression(iType);
            case 5 -> new SuperExpression(iType);
            case 6 -> new MyselfExpression(iType, iDescription);
            default -> null;
        };
    }

    @Override
    public IExpression createList(Iterable<? extends IExpression> iterable) {
        return ListExpression.create(iterable);
    }

    public IExpression createList(IExpression[] iExpressionArray) {
        return ListExpression.create(iExpressionArray);
    }

    @Override
    public IExpression createMap(Iterable<? extends IExpression> iterable) {
        return MapExpression.create(iterable);
    }

    @Override
    public boolean hasExactOperator(String string, IExpression iExpression) {
        IMap<Signature, OperatorProto> iMap = GAML.OPERATORS.get(string);
        if (iExpression == null || iMap == null) {
            return false;
        }
        return iMap.containsKey(new Signature(iExpression).simplified());
    }

    @Override
    public boolean hasOperator(String string, Signature signature) {
        if (signature == null || signature.size() == 0 || !GAML.OPERATORS.containsKey(string)) {
            return false;
        }
        IMap<Signature, OperatorProto> iMap = GAML.OPERATORS.get(string);
        Signature signature3 = signature.simplified();
        boolean bl = Iterables.any(iMap.keySet(), signature2 -> signature3.matchesDesiredSignature((Signature)signature2));
        if (!bl) {
            bl = Iterables.any(iMap.keySet(), signature2 -> Signature.varArgFrom(signature3).matchesDesiredSignature((Signature)signature2));
        }
        return bl;
    }

    @Override
    public IExpression createOperator(String string, IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
        String string2;
        OperatorProto operatorProto;
        Object object;
        ITyped iTyped;
        if (iExpressionArray == null || iExpressionArray.length == 0 || !GAML.OPERATORS.containsKey(string)) {
            return this.emitError(string, iDescription, eObject, iExpressionArray == null ? new IExpression[]{} : iExpressionArray);
        }
        Object object2 = iExpressionArray;
        int n = iExpressionArray.length;
        int n2 = 0;
        while (n2 < n) {
            iTyped = object2[n2];
            if (iTyped == null) {
                return this.emitError(string, iDescription, eObject, iExpressionArray);
            }
            ++n2;
        }
        iTyped = GAML.OPERATORS.get(string);
        if (!iTyped.containsKey(object = Signature.createSimplified(iExpressionArray))) {
            Object object3;
            Signature signature = object;
            int n3 = Integer.MAX_VALUE;
            for (Map.Entry entry : iTyped.entrySet()) {
                object3 = (Signature)entry.getKey();
                if (!signature.matchesDesiredSignature((Signature)object3)) continue;
                int n4 = ((Signature)object3).distanceTo(signature);
                if (n4 == 0) {
                    n3 = 0;
                    object = object3;
                    break;
                }
                if (n4 >= n3) continue;
                n3 = n4;
                object = object3;
            }
            if (n3 == Integer.MAX_VALUE) {
                Map.Entry entry;
                entry = Signature.varArgFrom(signature);
                for (Map.Entry entry2 : iTyped.entrySet()) {
                    Signature signature2 = (Signature)entry2.getKey();
                    if (!((Signature)((Object)entry)).matchesDesiredSignature(signature2)) continue;
                    return this.createOperator(string, iDescription, eObject, this.createList(iExpressionArray));
                }
                return this.emitError(string, iDescription, eObject, iExpressionArray);
            }
            int n5 = 0;
            while (n5 < iExpressionArray.length) {
                IType iType = signature.get(n5);
                IType iType2 = this.findCoercingType(iDescription, eObject, iType, (IType)(object3 = ((Signature)object).get(n5)), iExpressionArray[n5]);
                if (iType2 != null) {
                    iExpressionArray[n5] = this.createAs(iDescription, iExpressionArray[n5], this.createTypeExpression(iType2));
                }
                ++n5;
            }
        }
        if ((object2 = (operatorProto = (OperatorProto)iTyped.get(object)).create(iDescription, eObject, iExpressionArray)) != null && (string2 = operatorProto.getDeprecated()) != null) {
            iDescription.warning(operatorProto.getName() + " is deprecated: " + string2, "gaml.deprecated.code.issue", eObject, new String[0]);
        }
        return object2;
    }

    private IType findCoercingType(IDescription iDescription, EObject eObject, IType iType, IType iType2, IExpression iExpression) {
        if (iType == Types.INT && iType2 == Types.FLOAT) {
            return Types.FLOAT;
        }
        if (iType == Types.FLOAT && iType2 == Types.INT) {
            iDescription.info("'" + iExpression.serializeToGaml(false) + "' will be  truncated to int.", "gaml.unmatched.operands.issue", eObject, new String[0]);
            return Types.INT;
        }
        return null;
    }

    private IExpression emitError(String string, IDescription iDescription, EObject eObject, IExpression ... iExpressionArray) {
        IMap<Signature, OperatorProto> iMap = GAML.OPERATORS.get(string);
        Signature signature = new Signature(iExpressionArray).simplified();
        StringBuilder stringBuilder = new StringBuilder("No operator found for applying '").append(string).append("' to ").append(signature);
        if (iMap != null) {
            stringBuilder.append(" (operators available for ").append(Arrays.toString(iMap.keySet().toArray())).append(")");
        }
        iDescription.error(stringBuilder.toString(), "gaml.unmatched.operands.issue", eObject, new String[0]);
        return null;
    }

    @Override
    public IExpression createAs(IDescription iDescription, IExpression iExpression, IExpression iExpression2) {
        return OperatorProto.AS.create(iDescription, null, iExpression, iExpression2);
    }

    @Override
    public IExpression createAction(String string, IDescription iDescription, ActionDescription actionDescription, IExpression iExpression, Arguments arguments) {
        if (actionDescription.verifyArgs(iDescription, arguments)) {
            return new PrimitiveOperator(iDescription, actionDescription, iExpression, arguments, iExpression instanceof SuperExpression);
        }
        return null;
    }

    @Override
    public IExpression createTypeExpression(IType iType) {
        return iType.getExpression();
    }

    @Override
    public IExpression createTemporaryActionForAgent(IAgent iAgent, String string, IExecutionContext iExecutionContext) {
        IDisposable iDisposable2;
        SpeciesDescription speciesDescription = iAgent.getSpecies().getDescription();
        ActionDescription actionDescription = (ActionDescription)DescriptionFactory.create("action", (IDescription)speciesDescription, (Iterable<IDescription>)Collections.EMPTY_LIST, "type", "unknown", "name", "__synthetic__action__");
        List<IDescription> list = this.getParser().compileBlock(string, speciesDescription, iExecutionContext);
        for (IDisposable iDisposable2 : list) {
            actionDescription.addChild((IDescription)iDisposable2);
        }
        actionDescription.validate();
        speciesDescription.addChild(actionDescription);
        iDisposable2 = (ActionStatement)actionDescription.compile();
        iAgent.getSpecies().addTemporaryAction((ActionStatement)iDisposable2);
        return this.getParser().compile("__synthetic__action__()", speciesDescription, null);
    }

    public static interface ParserProvider {
        public IExpressionCompiler get();
    }
}

