/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.BufferingController;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import gama.gaml.operators.Strings;
import gama.gaml.statements.AbstractStatementSequence;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The color with wich the message will be displayed. Note that different simulations will have different (default) colors to use for this purpose if this facet is not specified")}), @GamlAnnotations.facet(name="end", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The string to be appened at the end of the message. By default it's a new line character: '\\n' or '\\r\\n' depending on the operating system.")}), @GamlAnnotations.facet(name="buffering", type={4}, optional=true, doc={@GamlAnnotations.doc(value="Allows to specify a buffering strategy to write in the console. Accepted values are `per_cycle` and `per_simulation`, `no_buffering`. In the case of `per_cycle` or `per_simulation`, all the write operations in the simulation which used these values would be executed all at once at the end of the cycle or simulation while keeping the initial order. In case of 'per_agent' all operations will be released when the agent is killed (or the simulation ends). Those strategies can be used to optimise a simulation's execution time on models that extensively write in files. The `no_buffering` (which is the system's default) will directly write into the file.")}), @GamlAnnotations.facet(name="message", type={0}, optional=true, doc={@GamlAnnotations.doc(value="A message to display alongside the results. Should concisely describe the contents of the benchmark")}), @GamlAnnotations.facet(name="repeat", type={1}, optional=true, doc={@GamlAnnotations.doc(value="An int expression describing how many executions of the block must be handled. The output in this case will return the min, max and average durations")})}, omissible="message")
@GamlAnnotations.inside(kinds={3, 11, 6})
@GamlAnnotations.doc(value="Displays in the console the duration in ms of the execution of the statements included in the block. It is possible to indicate, with the 'repeat' facet, how many times the sequence should be run")
public class BenchmarkStatement
extends AbstractStatementSequence {
    final IExpression repeat = this.getFacet("repeat");
    final IExpression message = this.getFacet("message");
    final IExpression color = this.getFacet("color");
    final IExpression bufferingStrategy = this.getFacet("buffering");
    final IExpression end = this.getFacet("end");

    public BenchmarkStatement(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        int n = this.repeat == null ? 1 : Cast.asInt(iScope, this.repeat.value(iScope));
        GamaColor gamaColor = null;
        if (this.color != null) {
            gamaColor = (GamaColor)this.color.value(iScope);
        }
        BufferingController.BufferingStrategies bufferingStrategies = BufferingController.stringToBufferingStrategies(iScope, (String)GamaPreferences.get("pref_write_buffering_strategy").value(iScope));
        if (this.bufferingStrategy != null) {
            bufferingStrategies = BufferingController.stringToBufferingStrategies(iScope, Cast.asString(iScope, this.bufferingStrategy.value(iScope)));
        }
        double d = 9.223372036854776E18;
        int n2 = 0;
        double d2 = -9.223372036854776E18;
        int n3 = 0;
        double d3 = 0.0;
        int n4 = 0;
        while (n4 < n) {
            long l = System.nanoTime();
            super.privateExecuteIn(iScope);
            long l2 = System.nanoTime();
            double d4 = (double)(l2 - l) / 1000000.0;
            if (d > d4) {
                d = d4;
                n2 = n4;
            }
            if (d2 < d4) {
                d2 = d4;
                n3 = n4;
            }
            d3 += d4;
            ++n4;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.message == null ? "Execution time " : Cast.asString(iScope, this.message.value(iScope)));
        stringBuilder.append(" (over ").append(n).append(" iteration(s)): min = ").append(d).append(" ms (iteration #").append(n2).append(") | max = ").append(d2).append(" ms (iteration #").append(n3).append(") | average = ").append(d3 / (double)n).append("ms");
        if (this.end != null) {
            stringBuilder.append(Cast.asString(iScope, this.end));
        } else {
            stringBuilder.append(Strings.LN);
        }
        GAMA.getBufferingController().askWriteConsole(iScope, stringBuilder, gamaColor, bufferingStrategies);
        return stringBuilder.toString();
    }
}

