/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.variables;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.ISkill;
import gama.core.common.interfaces.IVarAndActionSupport;
import gama.core.common.util.JavaUtils;
import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.runtime.GAMA;
import gama.core.runtime.IScope;
import gama.core.runtime.benchmark.StopWatch;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;
import gama.core.util.IList;
import gama.dev.DEBUG;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.GamaHelper;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.IGamaHelper;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.ConstantExpressionDescription;
import gama.gaml.descriptions.ExperimentDescription;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.data.ListExpression;
import gama.gaml.expressions.units.TimeUnitConstantExpression;
import gama.gaml.operators.Cast;
import gama.gaml.species.AbstractSpecies;
import gama.gaml.statements.IExecutable;
import gama.gaml.types.GamaListType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import gama.gaml.variables.IVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-203}, optional=false, doc={@GamlAnnotations.doc(value="The name of the attribute")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of this attribute. Can be combined with facets 'of' and 'index' to describe container types")}), @GamlAnnotations.facet(name="of", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the elements contained in the type of this attribute if it is a container type")}), @GamlAnnotations.facet(name="index", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="The type of the index used to retrieve elements if the type of the attribute is a container type")}), @GamlAnnotations.facet(name="init", type={0}, optional=true, doc={@GamlAnnotations.doc(value="The initial value of the attribute. Same as <- ")}), @GamlAnnotations.facet(name="<-", internal=true, type={0}, optional=true, doc={@GamlAnnotations.doc(value="The initial value of the attribute. Same as init:")}), @GamlAnnotations.facet(name="update", type={0}, optional=true, doc={@GamlAnnotations.doc(value="An expression that will be evaluated each cycle to compute a new value for the attribute")}), @GamlAnnotations.facet(name="on_change", type={0}, optional=true, doc={@GamlAnnotations.doc(value="Provides a block of statements that will be executed whenever the value of the attribute changes")}), @GamlAnnotations.facet(name="function", type={0}, optional=true, doc={@GamlAnnotations.doc(value="Used to specify an expression that will be evaluated each time the attribute is accessed. This facet is incompatible with both 'init:', 'update:' and 'on_change:' (or the equivalent final block)")}), @GamlAnnotations.facet(name="->", internal=true, type={1, 2, 7, 23}, optional=true, doc={@GamlAnnotations.doc(value="Used to specify an expression that will be evaluated each time the attribute is accessed. Equivalent to 'function:'. This facet is incompatible with both 'init:' and 'update:' and 'on_change:' (or the equivalent final block)")}), @GamlAnnotations.facet(name="const", type={3}, optional=true, doc={@GamlAnnotations.doc(value="Indicates whether this attribute can be subsequently modified or not")}), @GamlAnnotations.facet(name="among", type={5}, optional=true, doc={@GamlAnnotations.doc(value="A list of constant values among which the attribute can take its value")})}, omissible="name")
@GamlAnnotations.inside(kinds={0, 13, 1})
@GamlAnnotations.doc(value="Declaration of an attribute of a species or an experiment")
@validator(value=VarValidator.class)
public class Variable
extends Symbol
implements IVariable {
    protected IExpression initExpression;
    protected final IExpression updateExpression;
    protected final IExpression amongExpression;
    protected final IExpression functionExpression;
    protected final IExpression onChangeExpression;
    protected IType type;
    protected final boolean isNotModifiable;
    public IGamaHelper getter;
    public IGamaHelper initer;
    public IGamaHelper setter;
    public Map<GamaHelper, IVarAndActionSupport> listeners;
    protected ISkill gSkill;
    protected ISkill sSkill;
    private IExecutable on_changer;
    protected String parameter;
    protected String category;
    protected boolean mustNotifyOfChanges;

    static {
        DEBUG.OFF();
    }

    public Variable(IDescription iDescription) {
        super(iDescription);
        VariableDescription variableDescription = (VariableDescription)iDescription;
        this.setName(iDescription.getName());
        this.parameter = variableDescription.getParameterName();
        this.category = this.getLiteral("category", null);
        this.updateExpression = this.getFacet("update");
        this.functionExpression = this.getFacet("function");
        this.initExpression = this.getFacet("init");
        this.amongExpression = this.getFacet("among");
        this.onChangeExpression = this.getFacet("on_change");
        this.isNotModifiable = variableDescription.isNotModifiable();
        this.type = variableDescription.getGamlType();
    }

    private void buildHelpers(AbstractSpecies abstractSpecies) {
        this.getter = this.getDescription().getGetter();
        if (this.getter != null) {
            this.gSkill = abstractSpecies.getSkillInstanceFor(this.getter.getSkillClass());
        }
        this.initer = this.getDescription().getIniter();
        this.setter = this.getDescription().getSetter();
        if (this.setter != null) {
            this.sSkill = abstractSpecies.getSkillInstanceFor(this.setter.getSkillClass());
        }
        this.addListeners(abstractSpecies);
        this.mustNotifyOfChanges = this.listeners != null && this.listeners.size() > 0 || this.onChangeExpression != null || this.on_changer != null;
    }

    private void addListeners(AbstractSpecies abstractSpecies) {
        SpeciesDescription speciesDescription = abstractSpecies.getDescription();
        Class<? extends IAgent> clazz = speciesDescription.getJavaBase();
        if (clazz == null) {
            return;
        }
        ArrayList<GamaHelper> arrayList = new ArrayList<GamaHelper>();
        Iterable iterable = Iterables.transform(speciesDescription.getSkills(), IDescription.TO_CLASS);
        if (GAML.LISTENERS_BY_NAME.containsKey((Object)this.getName())) {
            DEBUG.OUT((Object)("Listeners found for " + this.getName()));
            List<Class> object = JavaUtils.collectImplementationClasses(clazz, iterable, GAML.LISTENERS_BY_NAME.get((Object)this.getName()));
            if (!object.isEmpty()) {
                for (Object object2 : object) {
                    Set set = GAML.LISTENERS_BY_CLASS.get(object2);
                    for (GamaHelper gamaHelper : set) {
                        if (!gamaHelper.getName().equals(this.getName())) continue;
                        DEBUG.OUT((Object)("--> Adding listener found in " + ((Class)object2).getSimpleName()));
                        arrayList.add(gamaHelper);
                    }
                }
            }
        }
        if (!arrayList.isEmpty()) {
            this.listeners = new HashMap<GamaHelper, IVarAndActionSupport>();
            for (GamaHelper gamaHelper : arrayList) {
                this.listeners.put(gamaHelper, abstractSpecies.getSkillInstanceFor(gamaHelper.getSkillClass()));
            }
        }
    }

    protected Object coerce(IAgent iAgent, IScope iScope, Object object) throws GamaRuntimeException {
        return this.type.cast(iScope, object, null, false);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.isNotModifiable() ? "const" : "var");
        stringBuilder.append(" ").append(this.type).append("[").append(this.getName()).append("]");
        return stringBuilder.toString();
    }

    @Override
    public void setValue(IScope iScope, Object object) {
        ConstantExpressionDescription constantExpressionDescription = ConstantExpressionDescription.create(object);
        this.initExpression = constantExpressionDescription.getExpression();
        this.setFacet("init", constantExpressionDescription);
    }

    @Override
    public void dispose() {
        super.dispose();
        this.initer = null;
        this.getter = null;
        this.setter = null;
        this.sSkill = null;
        this.gSkill = null;
    }

    @Override
    public boolean isParameter() {
        return this.getDescription().isParameter();
    }

    @Override
    public VariableDescription getDescription() {
        return (VariableDescription)this.description;
    }

    @Override
    public boolean isUpdatable() {
        return this.updateExpression != null && !this.isNotModifiable;
    }

    @Override
    public boolean isFunction() {
        return this.functionExpression != null;
    }

    @Override
    public IType getType() {
        return this.type;
    }

    @Override
    public void initializeWith(IScope iScope, IAgent iAgent, Object object) throws GamaRuntimeException {
        try {
            try {
                Throwable throwable = null;
                Object var5_7 = null;
                try (StopWatch stopWatch = GAMA.benchmark(iScope, this);){
                    iScope.setCurrentSymbol(this);
                    if (object != null) {
                        this._setVal(iAgent, iScope, object);
                    } else if (this.initExpression != null) {
                        this._setVal(iAgent, iScope, iScope.evaluate(this.initExpression, iAgent).getValue());
                    } else if (this.initer != null) {
                        Object t = this.initer.run(iScope, iAgent, this.gSkill == null ? iAgent : this.gSkill);
                        this._setVal(iAgent, iScope, t);
                    } else {
                        this._setVal(iAgent, iScope, this.getType().getDefault());
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                gamaRuntimeException.addContext("in initializing attribute " + this.getName());
                throw gamaRuntimeException;
            }
        }
        finally {
            iScope.setCurrentSymbol(null);
        }
    }

    @Override
    public String getTitle() {
        return this.parameter;
    }

    @Override
    public String getCategory() {
        if (this.category == null) {
            this.category = IVariable.super.getCategory();
        }
        return this.category;
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public final void setVal(IScope iScope, IAgent iAgent, Object object) throws GamaRuntimeException {
        if (this.isNotModifiable) {
            return;
        }
        Object object2 = !this.mustNotifyOfChanges ? null : this.value(iScope, iAgent);
        this._setVal(iAgent, iScope, object);
        if (this.mustNotifyOfChanges && !Objects.equal((Object)object2, (Object)object)) {
            this.internalNotifyOfValueChange(iScope, iAgent, object2, object);
        }
    }

    private void internalNotifyOfValueChange(IScope iScope, IAgent iAgent, Object object, Object object2) {
        if (this.onChangeExpression != null) {
            if (this.on_changer == null) {
                this.on_changer = iAgent.getSpecies().getAction(Cast.asString(iScope, this.onChangeExpression.value(iScope)));
            }
            iScope.execute(this.on_changer, iAgent, null);
        }
        if (this.listeners != null) {
            this.listeners.forEach((gamaHelper, iVarAndActionSupport) -> gamaHelper.run(iScope, iAgent, iVarAndActionSupport == null ? iAgent : iVarAndActionSupport, object2));
        }
    }

    @Override
    public final void notifyOfValueChange(IScope iScope, IAgent iAgent, Object object, Object object2) {
        this.mustNotifyOfChanges = false;
        this.internalNotifyOfValueChange(iScope, iAgent, object, object2);
    }

    protected void _setVal(IAgent iAgent, IScope iScope, Object object) throws GamaRuntimeException {
        Object object2 = this.coerce(iAgent, iScope, object);
        object2 = this.checkAmong(iAgent, iScope, object2);
        if (this.setter != null) {
            this.setter.run(iScope, iAgent, this.sSkill == null ? iAgent : this.sSkill, object2);
        } else {
            iAgent.setAttribute(this.name, object2);
        }
    }

    protected Object checkAmong(IAgent iAgent, IScope iScope, Object object) throws GamaRuntimeException {
        if (this.amongExpression == null) {
            return object;
        }
        IList iList = Cast.asList(iScope, iScope.evaluate(this.amongExpression, iAgent).getValue());
        if (iList == null || iList.contains(object)) {
            return object;
        }
        if (iList.isEmpty()) {
            return null;
        }
        throw GamaRuntimeException.error("Value " + String.valueOf(object) + " is not included in the possible values [" + String.valueOf(iList) + "] of variable " + this.name, iScope);
    }

    @Override
    public Object value(IScope iScope) throws GamaRuntimeException {
        return this.value(iScope, iScope.getAgent());
    }

    @Override
    public Object value(IScope iScope, IAgent iAgent) throws GamaRuntimeException {
        if (this.getter != null) {
            return this.getter.run(iScope, iAgent, this.gSkill == null ? iAgent : this.gSkill);
        }
        if (this.functionExpression != null) {
            return iScope.evaluate(this.functionExpression, iAgent).getValue();
        }
        if (!iAgent.hasAttribute(this.name) && (this.isNotModifiable || this.initExpression != null && this.initExpression.isConst()) && !this.description.isBuiltIn()) {
            return this.getInitialValue(iScope);
        }
        return iAgent.getAttribute(this.name);
    }

    @Override
    public Object getUpdatedValue(IScope iScope) {
        return this.updateExpression.value(iScope);
    }

    @Override
    public Comparable getMinValue(IScope iScope) {
        return null;
    }

    @Override
    public Comparable getMaxValue(IScope iScope) {
        return null;
    }

    @Override
    public Comparable getStepValue(IScope iScope) {
        return null;
    }

    @Override
    public List getAmongValue(IScope iScope) {
        if (this.amongExpression == null) {
            return null;
        }
        try {
            return GamaListType.staticCast(iScope, this.amongExpression.value(iScope), this.getType(), false);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            return null;
        }
    }

    @Override
    public Object getInitialValue(IScope iScope) {
        if (this.initExpression != null) {
            try {
                return this.initExpression.value(iScope);
            }
            catch (GamaRuntimeException gamaRuntimeException) {
                return null;
            }
        }
        return this.value(iScope);
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return null;
    }

    @Override
    public void setUnitLabel(String string) {
    }

    @Override
    public boolean isEditable() {
        return !this.isNotModifiable;
    }

    @Override
    public boolean isDefined() {
        return true;
    }

    @Override
    public void setDefined(boolean bl) {
    }

    @Override
    public boolean acceptsSlider(IScope iScope) {
        return false;
    }

    @Override
    public void setEnclosing(ISymbol iSymbol) {
        if (iSymbol instanceof AbstractSpecies) {
            this.buildHelpers((AbstractSpecies)iSymbol);
        }
    }

    @Override
    public boolean isMicroPopulation() {
        VariableDescription variableDescription = this.getDescription();
        if (variableDescription == null) {
            return false;
        }
        return variableDescription.isSyntheticSpeciesContainer();
    }

    @Override
    public List<GamaColor> getColors(IScope iScope) {
        return null;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        return null;
    }

    @Override
    public boolean isNotModifiable() {
        return this.isNotModifiable;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return this.getDescription().isDefinedInExperiment();
    }

    @Override
    public void setValueNoCheckNoNotification(Object object) {
    }

    public static class VarValidator
    implements IDescriptionValidator {
        public static final List<String> assignmentFacets = Arrays.asList("value", "init", "function", "update", "min", "max");

        public void validate(IDescription iDescription) {
            VariableDescription variableDescription = (VariableDescription)iDescription;
            boolean bl = variableDescription.isExperimentParameter();
            String string = variableDescription.getName();
            if (string == null) {
                variableDescription.error("The attribute name is missing", "gaml.missing.name.issue");
                return;
            }
            if (!bl) {
                IExpression iExpression2;
                IType iType = variableDescription.getEnclosingDescription().getTypeNamed(string);
                if (iType != Types.NO_TYPE && !iType.isAgentType()) {
                    variableDescription.error(string + " is a type name. It cannot be used as an attribute name", "gaml.is.a.type.issue", "name", string);
                    return;
                }
                if (RESERVED.contains((Object)string)) {
                    variableDescription.error(string + " is a reserved keyword. It cannot be used as an attribute name", "gaml.is.reserved.issue", "name", string);
                    return;
                }
                if ("step".equals(string) && variableDescription.hasFacet("init") && !variableDescription.hasFacet("update") && (iExpression2 = variableDescription.getFacetExpr("init")).findAny(iExpression -> {
                    TimeUnitConstantExpression timeUnitConstantExpression;
                    return iExpression instanceof TimeUnitConstantExpression && !(timeUnitConstantExpression = (TimeUnitConstantExpression)iExpression).isConst();
                })) {
                    variableDescription.warning("Time dependent constants used to define the step at initialization are computed once based on the current_date. The resulting durations may be irrelevant after a few cycles. An 'update:' facet should be defined with the same expression to recompute the step every cycle", "gaml.conflicting.facets", "init", new String[0]);
                }
            }
            if (variableDescription.hasFacet("function") && (variableDescription.hasFacet("init") || variableDescription.hasFacet("update") || variableDescription.hasFacet("on_change"))) {
                variableDescription.error("A function cannot have an 'init', 'on_change' or 'update' facet", "gaml.remove.value.issue", "function", new String[0]);
                return;
            }
            if ("true".equals(variableDescription.getLitteral("const"))) {
                if (variableDescription.hasFacet("update")) {
                    variableDescription.warning("A constant attribute cannot have an update value (use init or <- instead)", "gaml.remove.const.issue", "update", new String[0]);
                } else {
                    if (variableDescription.hasFacet("function")) {
                        variableDescription.error("A function cannot be constant (use init or <- instead)", "gaml.remove.const.issue", "function", new String[0]);
                        return;
                    }
                    if (variableDescription.isParameter()) {
                        variableDescription.error("Parameter '" + variableDescription.getParameterName() + "'  cannot be declared as constant ", "gaml.remove.const.issue");
                        return;
                    }
                    if (variableDescription.hasFacet("on_change")) {
                        variableDescription.warning("A constant attribute cannot declare an 'on_change' facet", "gaml.remove.const.issue", "on_change", new String[0]);
                    }
                }
            }
            if (variableDescription.isParameter()) {
                this.assertCanBeParameter(variableDescription);
            } else {
                this.assertValueFacetsTypes(variableDescription, variableDescription.getGamlType());
            }
            this.assertAssignmentFacetsTypes(variableDescription);
            this.assertAmongValues(variableDescription);
        }

        public void assertAmongValues(VariableDescription variableDescription) {
            Object object;
            ListExpression listExpression;
            IExpression iExpression = variableDescription.getFacetExpr("among");
            IExpression iExpression2 = variableDescription.getFacetExpr("init");
            if (iExpression2 == null || !iExpression2.isConst()) {
                return;
            }
            if (iExpression instanceof ListExpression && !(listExpression = (ListExpression)iExpression).containsValue(object = iExpression2.getConstValue())) {
                if (listExpression.getElements().length == 0) {
                    variableDescription.error("No value of " + variableDescription.getName() + " can be chosen.", "gaml.not.among.issue", "among", new String[0]);
                } else {
                    variableDescription.warning("The initial value of " + variableDescription.getName() + " does not belong to the list of possible values. It will be initialized to " + listExpression.getElements()[0].serializeToGaml(true) + " instead.", "gaml.wrong.value", "init", String.valueOf(listExpression.getElements()[0].getConstValue()));
                }
            }
        }

        public void assertAssignmentFacetsTypes(VariableDescription variableDescription) {
            for (String string : assignmentFacets) {
                IDescriptionValidator.Assert.typesAreCompatibleForAssignment(string, variableDescription, variableDescription.getName(), variableDescription.getGamlType(), variableDescription.getFacet(string));
            }
        }

        public void assertValueFacetsTypes(VariableDescription variableDescription, IType<?> iType) {
            IExpression iExpression = variableDescription.getFacetExpr("among");
            if (iExpression != null && !iType.isAssignableFrom(iExpression.getGamlType().getContentType())) {
                variableDescription.error("Variable " + variableDescription.getName() + " of type " + String.valueOf(iType) + " cannot be chosen among " + iExpression.serializeToGaml(false), "gaml.not.among.issue", "among", new String[0]);
            }
        }

        public void assertCanBeParameter(VariableDescription variableDescription) {
            Double d;
            Object object2;
            Object object3;
            if ("parameter".equals(variableDescription.getKeyword())) {
                object3 = variableDescription.getLitteral("var");
                object2 = variableDescription.getModelDescription().getAttribute((String)object3);
                if (object2 == null) {
                    ExperimentDescription object4 = (ExperimentDescription)variableDescription.getEnclosingDescription();
                    object2 = object4.getAttribute((String)object3);
                    if (object2 == null) {
                        String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                        variableDescription.error(string + "cannot refer to the non-global variable " + (String)object3, "gaml.unknown.var.issue", "var", new String[0]);
                        return;
                    }
                    if (object4.isBatch().booleanValue()) {
                        String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                        variableDescription.warning((String)string + "refers to an experiment variable, which cannot be explored during batch experiments. Move " + (String)object3 + " to the global section if it makes sense.", "gaml.wrong.context.issue", "var", new String[0]);
                    }
                }
                if (variableDescription.getGamlType().equals(Types.NO_TYPE)) {
                    variableDescription.error("Impossible to determine the type of the parameter " + (String)object3, "gaml.unmatched.types.issue", "type", new String[0]);
                    return;
                }
                if (variableDescription.getGamlType().id() != ((SymbolDescription)object2).getGamlType().id()) {
                    String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                    variableDescription.error(string + "type must be the same as that of " + (String)object3, "gaml.unmatched.types.issue", "type", new String[0]);
                    return;
                }
                this.assertValueFacetsTypes(variableDescription, ((SymbolDescription)object2).getGamlType());
                if (variableDescription.isNotModifiable() || ((VariableDescription)object2).isNotModifiable()) {
                    String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                    variableDescription.info(string + "Since the variable is declared as const, this parameter will be read-only.", "gaml.remove.const.issue");
                }
            }
            this.assertValueFacetsTypes(variableDescription, variableDescription.getGamlType());
            object3 = variableDescription.getFacetExpr("init") != null ? variableDescription.getFacetExpr("init") : ((object2 = variableDescription.getFacetExpr("step")) != null && object2.isContextIndependant() ? ((d = Cast.asFloat(null, object2.getConstValue())) < 0.0 ? variableDescription.getFacetExpr("max") : variableDescription.getFacetExpr("min")) : variableDescription.getFacetExpr("min"));
            object2 = object3;
            if (object2 == null) {
                String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                variableDescription.error(string + " must have an initial or minimal value.", "gaml.no.init.issue", variableDescription.getUnderlyingElement(), StringUtils.toGaml(variableDescription.getGamlType().getDefault(), false));
                return;
            }
            for (String string : VariableDescription.INIT_DEPENDENCIES_FACETS) {
                IExpression iExpression = variableDescription.getFacetExpr(string);
                if (iExpression == null || iExpression.isAllowedInParameters()) continue;
                variableDescription.error(iExpression.serializeToGaml(true) + " cannot be used in the context of experiments. Please use a constant expression or redeclare this parameter in the experiments", "gaml.wrong.context.issue", string, new String[0]);
            }
            if (variableDescription.hasFacet("update") || variableDescription.isFunction()) {
                String string = "Parameter '" + variableDescription.getParameterName() + "' ";
                variableDescription.error(string + "cannot have an 'update' or 'function' facet", "gaml.remove.value.issue");
            }
        }
    }
}

