/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.exploration.morris;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.FileUtils;
import gama.core.kernel.batch.exploration.AExplorationAlgorithm;
import gama.core.kernel.batch.exploration.morris.Morris;
import gama.core.kernel.batch.exploration.sampling.MorrisSampling;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.gaml.compilation.ISymbol;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.FileNameUtils;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="sample", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="The size of the sample for Morris samples")}), @GamlAnnotations.facet(name="levels", type={-201}, optional=false, doc={@GamlAnnotations.doc(value="Number of level for the Morris method, can't be 1")}), @GamlAnnotations.facet(name="outputs", type={5}, of=4, optional=false, doc={@GamlAnnotations.doc(value="The list of output variables to analyze through morris method")}), @GamlAnnotations.facet(name="report", type={4}, optional=false, doc={@GamlAnnotations.doc(value="The path to the file where the Morris report will be written")}), @GamlAnnotations.facet(name="csv", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path of morris sample .csv file. If don't use, automatic morris sampling will be perform and saved in the corresponding file")}), @GamlAnnotations.facet(name="results", type={4}, optional=true, doc={@GamlAnnotations.doc(value="The path to the file where the automatic batch report will be written")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm runs a Morris exploration - it has been built upon the SILAB librairy - disabled the repeat facet of the experiment", usages={@GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method morris sample_size:100 nb_levels:4 outputs:['my_var'] report:'../path/to/report.txt;", isExecutable=false)})})
public class MorrisExploration
extends AExplorationAlgorithm {
    public static final String NB_LEVELS = "levels";
    protected static final String PARAMETER_CSV_PATH = "csv";
    protected List<IParameter.Batch> parameters;
    protected IList<String> outputs;
    protected List<ParametersSet> solutions;
    protected IMap<ParametersSet, Map<String, List<Object>>> res_outputs;
    protected List<String> ParametersNames;
    private int sample;
    private int nb_levels;
    private List<Map<String, Object>> samples;
    private Morris momo;

    public MorrisExploration(IDescription iDescription) {
        super(iDescription);
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public void explore(IScope iScope) {
        Object object;
        this.sample = Cast.asInt(iScope, this.getFacet("sample").value(iScope));
        this.nb_levels = Cast.asInt(iScope, this.getFacet(NB_LEVELS).value(iScope));
        if (this.hasFacet(PARAMETER_CSV_PATH)) {
            object = this.getFacet(PARAMETER_CSV_PATH);
            String string = FileUtils.constructAbsoluteFilePath(iScope, Cast.asString(iScope, object.value(iScope)), false);
            this.solutions = this.solutions == null ? this.buildParameterSetsFromCSV(iScope, string, new ArrayList<ParametersSet>()) : this.solutions;
        } else {
            this.solutions = this.buildParameterSets(iScope, new ArrayList<ParametersSet>(), 0);
        }
        this.currentExperiment.setSeeds(new Double[1]);
        this.currentExperiment.setKeepSimulations(false);
        this.res_outputs = this.currentExperiment.runSimulationsAndReturnResults(this.solutions);
        object = this.rebuildOutput(iScope, this.res_outputs);
        this.momo.setOutputs((Map<String, List<Double>>)object, iScope);
        int n = 0;
        for (Object object2 : this.res_outputs.values()) {
            n += ((List)object2.values().stream().findFirst().get()).size();
        }
        if (this.hasFacet("results")) {
            this.saveRawResults(iScope, this.res_outputs);
        }
        if (n == this.samples.size() && ((List)object.values().stream().findAny().get()).size() == this.samples.size()) {
            Object object2;
            this.momo.evaluate();
            object2 = Cast.asString(iScope, this.getFacet("report").value(iScope));
            File file = new File(FileUtils.constructAbsoluteFilePath(iScope, (String)object2, false));
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            if (file.exists()) {
                file.delete();
            }
            this.saveResults(file, iScope);
        }
    }

    @Override
    public List<ParametersSet> buildParameterSets(IScope iScope, List<ParametersSet> list, int n) {
        ArrayList<IParameter.Batch> arrayList = new ArrayList<IParameter.Batch>(this.currentExperiment.getParametersToExplore());
        this.parameters = this.parameters == null ? arrayList : this.parameters;
        ArrayList<String> arrayList2 = new ArrayList<String>();
        int n2 = 0;
        while (n2 < this.parameters.size()) {
            arrayList2.add(this.parameters.get(n2).getName());
            ++n2;
        }
        this.ParametersNames = arrayList2;
        this.outputs = Cast.asList(iScope, this.getFacet("outputs").value(iScope));
        List<Object> list2 = MorrisSampling.makeMorrisSampling(this.nb_levels, this.sample, this.parameters, iScope);
        this.samples = Cast.asList(iScope, list2.get(0));
        this.momo = new Morris(this.samples, this.nb_levels);
        return Cast.asList(iScope, list2.get(1));
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        final int n = Cast.asInt(batchAgent.getScope(), this.getFacet("sample").value(batchAgent.getScope()));
        final int n2 = Cast.asInt(batchAgent.getScope(), this.getFacet(NB_LEVELS).value(batchAgent.getScope()));
        list.add(new ParameterAdapter("Morris level", "morris", 4){

            @Override
            public Object value() {
                return n2;
            }
        });
        list.add(new ParameterAdapter("Morris sample", "morris", 4){

            @Override
            public Object value() {
                return MorrisExploration.this.solutions == null ? n * n2 : (MorrisExploration.this.solutions.size() == 0 ? MorrisExploration.this.sample : MorrisExploration.this.solutions.size());
            }
        });
    }

    private Map<String, List<Double>> rebuildOutput(IScope iScope, IMap<ParametersSet, Map<String, List<Object>>> iMap) {
        HashMap<String, List<Double>> hashMap = new HashMap<String, List<Double>>();
        for (String object : this.outputs) {
            hashMap.put(object, new ArrayList());
        }
        for (ParametersSet parametersSet : this.solutions) {
            for (String string : this.outputs) {
                try {
                    ((List)hashMap.get(string)).add(Cast.asFloat(iScope, ((List)((Map)iMap.get(parametersSet)).get(string)).get(0)));
                }
                catch (NullPointerException nullPointerException) {
                    return hashMap;
                }
            }
        }
        return hashMap;
    }

    private void saveResults(File file, IScope iScope) throws GamaRuntimeException {
        try {
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileWriter fileWriter = new FileWriter(file, StandardCharsets.UTF_8, false);){
                fileWriter.write(this.momo.buildReportString(FileNameUtils.getExtension((String)file.getPath())));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            throw GamaRuntimeException.error("File " + file.toString() + " not found", iScope);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<ParametersSet> buildParameterSetsFromCSV(IScope iScope, String string, List<ParametersSet> list) throws GamaRuntimeException {
        Object object;
        Object object2;
        ParametersSet parametersSet;
        Object object3;
        ArrayList<Map<String, Object>> arrayList;
        block27: {
            arrayList = new ArrayList<Map<String, Object>>();
            try {
                File file = new File(string);
                object3 = null;
                parametersSet = null;
                try {
                    object2 = new FileReader(file);
                    try {
                        object = new BufferedReader((Reader)object2);
                        try {
                            String string2;
                            String string3 = " ";
                            ArrayList<Object> arrayList2 = new ArrayList<Object>();
                            int n = 0;
                            while ((string2 = ((BufferedReader)object).readLine()) != null) {
                                block25: {
                                    Object object4;
                                    String[] stringArray;
                                    String[] stringArray2 = stringArray = string2.split(",");
                                    int n2 = stringArray.length;
                                    int n3 = 0;
                                    while (true) {
                                        if (n3 >= n2) {
                                            if (n > 0) {
                                                break;
                                            }
                                            break block25;
                                        }
                                        object4 = stringArray2[n3];
                                        if (n == 0) {
                                            arrayList2.add(object4);
                                        }
                                        ++n3;
                                    }
                                    object4 = new HashMap();
                                    n3 = 0;
                                    while (true) {
                                        if (n3 >= stringArray.length) {
                                            arrayList.add((Map<String, Object>)object4);
                                            break;
                                        }
                                        object4.put((String)arrayList2.get(n3), stringArray[n3]);
                                        ++n3;
                                    }
                                }
                                ++n;
                            }
                        }
                        finally {
                            if (object != null) {
                                ((BufferedReader)object).close();
                            }
                        }
                        if (object2 == null) break block27;
                    }
                    catch (Throwable throwable) {
                        if (object3 == null) {
                            object3 = throwable;
                        } else if (object3 != throwable) {
                            ((Throwable)object3).addSuppressed(throwable);
                        }
                        if (object2 == null) throw object3;
                        ((InputStreamReader)object2).close();
                        throw object3;
                    }
                    ((InputStreamReader)object2).close();
                }
                catch (Throwable throwable) {
                    if (object3 == null) {
                        object3 = throwable;
                        throw object3;
                    }
                    if (object3 == throwable) throw object3;
                    ((Throwable)object3).addSuppressed(throwable);
                    throw object3;
                }
            }
            catch (IOException iOException) {
                throw GamaRuntimeException.error("File " + string + " not found", iScope);
            }
        }
        this.samples = arrayList;
        object3 = arrayList.iterator();
        block12: while (object3.hasNext()) {
            Map map = (Map)object3.next();
            parametersSet = new ParametersSet();
            object = map.keySet().iterator();
            while (true) {
                if (!object.hasNext()) {
                    list.add(parametersSet);
                    continue block12;
                }
                Object v = map.get(object2 = (String)object.next());
                parametersSet.put((String)object2, v instanceof IExpression ? ((IExpression)v).value(iScope) : v);
            }
            break;
        }
        return list;
    }
}

