/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.batch.optimization;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.kernel.batch.StoppingCriterion;
import gama.core.kernel.batch.StoppingCriterionMaxIt;
import gama.core.kernel.batch.optimization.ALocalSearchAlgorithm;
import gama.core.kernel.experiment.BatchAgent;
import gama.core.kernel.experiment.IParameter;
import gama.core.kernel.experiment.ParameterAdapter;
import gama.core.kernel.experiment.ParametersSet;
import gama.core.runtime.IScope;
import gama.core.runtime.concurrent.GamaExecutorService;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.descriptions.IDescription;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-201}, optional=false, internal=true, doc={@GamlAnnotations.doc(value="The name of the method. For internal use only")}), @GamlAnnotations.facet(name="iter_max", type={1}, optional=true, doc={@GamlAnnotations.doc(value="number of iterations. this number corresponds to the number of \"moves\" in the parameter space. For each move, the algorithm will test the whole neighborhood of the current solution, each neighbor corresponding to a particular set of parameters and thus to a run. Thus, there can be several runs per iteration (maximum: 2^(number of parameters)).")}), @GamlAnnotations.facet(name="init_solution", type={10}, optional=true, doc={@GamlAnnotations.doc(value="init solution: key: name of the variable, value: value of the variable")}), @GamlAnnotations.facet(name="tabu_list_size", type={1}, optional=true, doc={@GamlAnnotations.doc(value="size of the tabu list")}), @GamlAnnotations.facet(name="maximize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to maximize")}), @GamlAnnotations.facet(name="minimize", type={2}, optional=true, doc={@GamlAnnotations.doc(value="the value the algorithm tries to minimize")}), @GamlAnnotations.facet(name="aggregation", type={-200}, optional=true, values={"min", "max", "avr"}, doc={@GamlAnnotations.doc(value="the agregation method")})}, omissible="name")
@GamlAnnotations.doc(value="This algorithm is an implementation of the Tabu Search algorithm. See the wikipedia article and [batch161 the batch dedicated page].", usages={@GamlAnnotations.usage(value="As other batch methods, the basic syntax of the tabu statement uses `method tabu` instead of the expected `tabu name: id` : ", examples={@GamlAnnotations.example(value="method tabu [facet: value];", isExecutable=false)}), @GamlAnnotations.usage(value="For example: ", examples={@GamlAnnotations.example(value="method tabu iter_max: 50 tabu_list_size: 5 maximize: food_gathered;", isExecutable=false)})})
public class TabuSearch
extends ALocalSearchAlgorithm {
    protected static final String ITER_MAX = "iter_max";
    protected static final String LIST_SIZE = "tabu_list_size";
    int tabuListSize = 5;
    StoppingCriterion stoppingCriterion = new StoppingCriterionMaxIt(50);
    int iterMax = 50;

    public TabuSearch(IDescription iDescription) {
        super(iDescription);
        this.initParams();
    }

    public boolean keepSol(ParametersSet parametersSet, Double d, Double d2) {
        boolean bl;
        boolean bl2 = bl = d > d2;
        return this.isMaximize() && bl || !this.isMaximize() && !bl;
    }

    @Override
    public ParametersSet findBestSolution(IScope iScope) throws GamaRuntimeException {
        this.initializeTestedSolutions();
        ParametersSet parametersSet = this.solutionInit;
        BatchAgent batchAgent = this.getCurrentExperiment();
        if (batchAgent == null) {
            return parametersSet;
        }
        ArrayList<ParametersSet> arrayList = new ArrayList<ParametersSet>();
        arrayList.add(parametersSet);
        double d = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet));
        this.testedSolutions.put(parametersSet, d);
        this.setBestSolution(new ParametersSet(parametersSet));
        this.setBestFitness(d);
        int n = 0;
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("Iteration", n);
        while (!this.stoppingCriterion.stopSearchProcess(hashtable)) {
            List<ParametersSet> list = this.neighborhood.neighbor(iScope, parametersSet);
            list.removeAll(arrayList);
            if (list.isEmpty()) {
                if (arrayList.isEmpty()) break;
                list.add((ParametersSet)arrayList.get(iScope.getRandom().between(0, arrayList.size() - 1)));
            }
            double d2 = this.isMaximize() ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            ParametersSet parametersSet2 = null;
            ++n;
            if (GamaExecutorService.shouldRunAllSimulationsInParallel(batchAgent) && !batchAgent.getParametersToExplore().isEmpty()) {
                ParametersSet parametersSet3 = this.testSolutions(list);
                var15_13 = parametersSet3.keySet().iterator();
                while (var15_13.hasNext()) {
                    ParametersSet parametersSet4 = var15_13.next();
                    if (!this.keepSol(parametersSet4, (Double)parametersSet3.get(parametersSet4), d2)) continue;
                    parametersSet2 = parametersSet4;
                }
            } else {
                for (ParametersSet parametersSet3 : list) {
                    if (parametersSet3 == null || (var15_13 = (Double)this.testedSolutions.get(parametersSet3)) != null && (Double)var15_13 != Double.MAX_VALUE) continue;
                    var15_13 = this.getFirstFitness(batchAgent.launchSimulationsWithSingleParametersSet(parametersSet3));
                    this.testedSolutions.put(parametersSet3, var15_13);
                    if (!this.keepSol(parametersSet3, (Double)var15_13, d2)) continue;
                    parametersSet2 = parametersSet3;
                }
            }
            if (parametersSet2 == null) break;
            parametersSet = parametersSet2;
            arrayList.add(parametersSet);
            if (arrayList.size() > this.tabuListSize) {
                arrayList.remove(0);
            }
            hashtable.put("Iteration", n);
        }
        return this.getBestSolution();
    }

    @Override
    public void initParams(IScope iScope) {
        IExpression iExpression;
        IExpression iExpression2 = this.getFacet(ITER_MAX);
        if (iExpression2 != null) {
            this.iterMax = Cast.asInt(iScope, iExpression2.value(iScope));
            this.stoppingCriterion = new StoppingCriterionMaxIt(this.iterMax);
        }
        if ((iExpression = this.getFacet(LIST_SIZE)) != null) {
            this.tabuListSize = Cast.asInt(iScope, iExpression.value(iScope));
        }
    }

    @Override
    public void addParametersTo(List<IParameter.Batch> list, BatchAgent batchAgent) {
        super.addParametersTo(list, batchAgent);
        list.add(new ParameterAdapter("Tabu list size", "Calibration experiment", 1){

            @Override
            public Object value() {
                return TabuSearch.this.tabuListSize;
            }
        });
        list.add(new ParameterAdapter("Maximum number of iterations", "Calibration experiment", 2){

            @Override
            public Object value() {
                return TabuSearch.this.iterMax;
            }
        });
    }
}

