/*
 * Decompiled with CFR 0.152.
 */
package gama.core.kernel.experiment;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.preferences.GamaPreferences;
import gama.core.kernel.experiment.ICategory;
import gama.core.runtime.IScope;
import gama.core.util.GamaColor;
import gama.gaml.compilation.ISymbol;
import gama.gaml.compilation.Symbol;
import gama.gaml.descriptions.IDescription;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-200}, optional=false, doc={@GamlAnnotations.doc(value="The title of the category displayed in the UI")}), @GamlAnnotations.facet(name="expanded", optional=true, type={3}, doc={@GamlAnnotations.doc(value="Whether the category is initially expanded or not")}), @GamlAnnotations.facet(name="color", type={6}, optional=true, doc={@GamlAnnotations.doc(value="The background color of the category in the UI")})}, omissible="name")
@GamlAnnotations.inside(kinds={13})
@GamlAnnotations.doc(value="Allows to define a category of parameters that will serve to group parameters in the UI. The category can be declared as initially expanded or closed (overriding the corresponding preference) and with a background color")
public class ExperimentParametersCategory
extends Symbol
implements ICategory {
    public ExperimentParametersCategory(IDescription iDescription) {
        super(iDescription);
        this.setName(this.getLiteral("name"));
    }

    @Override
    public void setChildren(Iterable<? extends ISymbol> iterable) {
    }

    @Override
    public boolean isExpanded(IScope iScope) {
        return this.getFacetValue(iScope, "expanded", GamaPreferences.Runtime.CORE_EXPAND_PARAMS.getValue());
    }

    @Override
    public String getTitle() {
        return this.getName();
    }

    @Override
    public String getUnitLabel(IScope iScope) {
        return null;
    }

    @Override
    public boolean isDefinedInExperiment() {
        return true;
    }

    @Override
    public GamaColor getColor(IScope iScope) {
        return this.getFacetValue(iScope, "color", null);
    }
}

