/*
 * Decompiled with CFR 0.152.
 */
package gama.core.messaging;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.interfaces.IValue;
import gama.core.common.util.StringUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.file.json.Json;
import gama.core.util.file.json.JsonValue;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.vars(value={@GamlAnnotations.variable(name="sender", type=0, doc={@GamlAnnotations.doc(value="Returns the sender that has sent this message")}), @GamlAnnotations.variable(name="contents", type=0, doc={@GamlAnnotations.doc(value="Returns the contents of this message, as a list of arbitrary objects")}), @GamlAnnotations.variable(name="unread", type=3, init="true", doc={@GamlAnnotations.doc(value="Returns whether this message is unread or not")}), @GamlAnnotations.variable(name="recention_timestamp", type=1, doc={@GamlAnnotations.doc(value="Returns the reception time stamp of this message (I.e. at what cycle it has been received)")}), @GamlAnnotations.variable(name="emission_timestamp", type=1, doc={@GamlAnnotations.doc(value="Returns the emission time stamp of this message (I.e. at what cycle it has been emitted)")})})
public class GamaMessage
implements IValue {
    public static final String CONTENTS = "contents";
    public static final String UNREAD = "unread";
    public static final String EMISSION_TIMESTAMP = "emission_timestamp";
    public static final String RECEPTION_TIMESTAMP = "recention_timestamp";
    public static final String SENDER = "sender";
    public static final String RECEIVERS = "receivers";
    private boolean unread;
    private Object sender;
    private Object receivers;
    protected Object contents;
    protected int emissionTimeStamp;

    public GamaMessage(IScope iScope, Object object, Object object2, Object object3) throws GamaRuntimeException {
        this.emissionTimeStamp = iScope.getClock().getCycle();
        this.unread = true;
        this.setSender(object);
        this.setReceivers(object2);
        this.setContents(object3);
    }

    @GamlAnnotations.getter(value="sender")
    public Object getSender() {
        return this.sender;
    }

    @GamlAnnotations.setter(value="sender")
    public void setSender(Object object) {
        this.sender = object;
    }

    @GamlAnnotations.getter(value="receivers")
    public Object getReceivers() {
        return this.receivers;
    }

    @GamlAnnotations.setter(value="receivers")
    public void setReceivers(Object object) {
        this.receivers = object;
    }

    @GamlAnnotations.getter(value="contents")
    public Object getContents(IScope iScope) {
        this.setUnread(false);
        return this.contents;
    }

    @GamlAnnotations.setter(value="contents")
    public void setContents(Object object) {
        this.contents = object;
    }

    @GamlAnnotations.getter(value="unread")
    public boolean isUnread() {
        return this.unread;
    }

    @GamlAnnotations.setter(value="unread")
    public void setUnread(boolean bl) {
        this.unread = bl;
    }

    @GamlAnnotations.getter(value="emission_timestamp")
    public int getEmissionTimestamp() {
        return this.emissionTimeStamp;
    }

    @GamlAnnotations.getter(value="recention_timestamp")
    public int getReceptionTimestamp() {
        return this.emissionTimeStamp;
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return StringUtils.toGaml(this.contents, bl);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "message[sender: " + String.valueOf(this.getSender()) + "; content: " + String.valueOf(this.getContents(iScope)) + "]";
    }

    @Override
    public GamaMessage copy(IScope iScope) throws GamaRuntimeException {
        return new GamaMessage(iScope, this.getSender(), this.getReceivers(), this.getContents(iScope));
    }

    @Override
    public IType<?> getGamlType() {
        return Types.get(24);
    }

    @Override
    public int intValue(IScope iScope) {
        return this.getEmissionTimestamp();
    }

    public void hasBeenReceived(IScope iScope) {
    }

    @Override
    public JsonValue serializeToJson(Json json) {
        return json.typedObject(this.getGamlType(), SENDER, this.sender, CONTENTS, this.contents, RECEPTION_TIMESTAMP, this.emissionTimeStamp, EMISSION_TIMESTAMP, this.emissionTimeStamp).add(RECEIVERS, this.receivers);
    }
}

