/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.graph;

import com.google.common.collect.Ordering;
import gama.core.common.interfaces.IValue;
import gama.core.common.preferences.GamaPreferences;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.AbstractTopology;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.filter.IAgentFilter;
import gama.core.metamodel.topology.filter.In;
import gama.core.metamodel.topology.graph.GamaSpatialGraph;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.Collector;
import gama.core.util.GamaListFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.path.GamaPath;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.PathFactory;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.locationtech.jts.geom.Coordinate;

public class GraphTopology
extends AbstractTopology {
    public GraphTopology(IScope iScope, IShape iShape, GamaSpatialGraph gamaSpatialGraph) {
        super(iScope, iShape, null);
        this.places = gamaSpatialGraph;
    }

    public GraphTopology(IScope iScope, GamaSpatialGraph gamaSpatialGraph) {
        this(iScope, iScope.getSimulation().getGeometry(), gamaSpatialGraph);
    }

    @Override
    protected boolean canCreateAgents() {
        return true;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    private IShape optimizedClosestTo(IShape iShape, List<IShape> list) {
        IShape iShape2 = null;
        GamaPoint gamaPoint = iShape.getLocation();
        double d = Double.MAX_VALUE;
        for (IShape iShape3 : list) {
            double d2 = gamaPoint.euclidianDistanceTo(iShape3.getLocation());
            if (!(d2 < d)) continue;
            d = d2;
            iShape2 = iShape3;
        }
        return iShape2;
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2) {
        Collection<Object> collection;
        Object object;
        double d;
        Object object222;
        GamaSpatialGraph gamaSpatialGraph = (GamaSpatialGraph)this.getPlaces();
        Object object3 = iShape;
        Object object4 = iShape2;
        boolean bl = gamaSpatialGraph.getVertexMap().containsKey(iShape2);
        boolean bl2 = gamaSpatialGraph.isEmpty(iScope) ? false : gamaSpatialGraph.getVertices().get(0) instanceof IAgent;
        boolean bl3 = bl2 == iShape2 instanceof IAgent;
        boolean bl4 = bl2 == iShape instanceof IAgent;
        boolean bl5 = gamaSpatialGraph.getVertexMap().containsKey(iShape);
        boolean bl6 = GamaPreferences.Experimental.PATH_COMPUTATION_OPTIMIZATION.getValue();
        if (bl5 && GamaPoint.TOLERANCE > 0.0) {
            for (Object object222 : gamaSpatialGraph.getVertexMap().keySet()) {
                if (!object222.equals(iShape)) continue;
                object3 = object222;
                break;
            }
        }
        if (bl && GamaPoint.TOLERANCE > 0.0) {
            for (Object object222 : gamaSpatialGraph.getVertexMap().keySet()) {
                if (!object222.equals(iShape2)) continue;
                object4 = object222;
                break;
            }
        }
        if (!bl4 && !bl5 || !bl3 && !bl) {
            for (Object object222 : gamaSpatialGraph.getVertices()) {
                if (((IShape)object222).getLocation().equals(iShape.getLocation())) {
                    object3 = (IShape)object222;
                    bl5 = true;
                }
                if (((IShape)object222).getLocation().equals(iShape2.getLocation())) {
                    object4 = (IShape)object222;
                    bl = true;
                }
                if (bl5 && bl) break;
            }
        }
        if (bl5 && bl) {
            return (GamaSpatialPath)gamaSpatialGraph.getPathComputer().computeShortestPathBetween(iScope, object3, object4);
        }
        object222 = null;
        Object object5 = null;
        boolean bl7 = gamaSpatialGraph.edgeSet().size() > 1000;
        double d2 = d = bl7 ? Math.sqrt(iScope.getSimulation().getArea()) / (double)gamaSpatialGraph.edgeSet().size() * 100.0 : -1.0;
        if (gamaSpatialGraph.isAgentEdge()) {
            double d3;
            object = In.edgesOf(this.getPlaces());
            if (!bl5) {
                object222 = this.getPathEdge(iScope, iShape);
                if (object222 == null) {
                    if (bl6) {
                        object222 = this.optimizedClosestTo(iShape, this.getPlaces().getEdges());
                    } else if (bl7 && !(collection = iScope.getSimulation().getAgent().getTopology().getNeighborsOf(iScope, iShape, d, (IAgentFilter)object)).isEmpty()) {
                        var20_20 = Double.MAX_VALUE;
                        for (IAgent iAgent : collection) {
                            d3 = iShape.euclidianDistanceTo(iAgent);
                            if (!(d3 < var20_20)) continue;
                            object222 = iAgent;
                            var20_20 = d3;
                        }
                    }
                    if (object222 == null) {
                        object222 = iScope.getSimulation().getAgent().getTopology().getAgentClosestTo(iScope, iShape, (IAgentFilter)object);
                    }
                }
                if (object222 == null) {
                    return null;
                }
            }
            if (!bl) {
                if (bl6) {
                    object5 = this.optimizedClosestTo(iShape2, this.getPlaces().getEdges());
                } else if (bl7 && !(collection = iScope.getSimulation().getAgent().getTopology().getNeighborsOf(iScope, iShape2, d, (IAgentFilter)object)).isEmpty()) {
                    var20_20 = Double.MAX_VALUE;
                    for (IAgent iAgent : collection) {
                        d3 = iShape2.euclidianDistanceTo(iAgent);
                        if (!(d3 < var20_20)) continue;
                        object5 = iAgent;
                        var20_20 = d3;
                    }
                }
                if (object5 == null) {
                    object5 = iScope.getSimulation().getAgent().getTopology().getAgentClosestTo(iScope, iShape2, (IAgentFilter)object);
                }
                if (object5 == null) {
                    return null;
                }
            }
        } else {
            double d4 = Double.MAX_VALUE;
            var20_20 = Double.MAX_VALUE;
            object222 = this.getPathEdge(iScope, iShape);
            if (object222 != null) {
                d4 = 0.0;
            }
            if (d4 > 0.0 && !bl5 || var20_20 > 0.0 && !bl) {
                for (Object e : gamaSpatialGraph.getEdges()) {
                    double d5;
                    IShape iShape3 = (IShape)e;
                    if (!bl5 && d4 > 0.0) {
                        double d6 = d5 = bl6 ? iShape3.getLocation().euclidianDistanceTo(iShape.getLocation()) : iShape3.euclidianDistanceTo(iShape);
                        if (d5 < d4) {
                            d4 = d5;
                            object222 = iShape3;
                        }
                    }
                    if (bl || !(var20_20 > 0.0)) continue;
                    double d7 = d5 = bl6 ? iShape3.getLocation().euclidianDistanceTo(iShape2.getLocation()) : iShape3.euclidianDistanceTo(iShape2);
                    if (!(d5 < var20_20)) continue;
                    var20_20 = d5;
                    object5 = iShape3;
                }
            }
            if (!bl5 && object222 == null || !bl && object5 == null) {
                return null;
            }
        }
        if (this.getPlaces().isDirected()) {
            IShape iShape4;
            IShape iShape5;
            object = new ArrayList();
            collection = new ArrayList();
            object.add(object222);
            if (!bl5 && (iShape5 = (IShape)gamaSpatialGraph.getEdge(gamaSpatialGraph.getEdgeTarget(object222), gamaSpatialGraph.getEdgeSource(object222))) != null && object222 != null && iShape5.euclidianDistanceTo(iShape) <= object222.euclidianDistanceTo(iShape)) {
                object.add(iShape5);
            }
            collection.add(object5);
            if (!bl && (iShape4 = (IShape)gamaSpatialGraph.getEdge(gamaSpatialGraph.getEdgeTarget(object5), gamaSpatialGraph.getEdgeSource(object5))) != null && iShape2 != null && object222 != null && iShape4.euclidianDistanceTo(iShape2) <= object222.euclidianDistanceTo(iShape2)) {
                collection.add(iShape4);
            }
            return this.pathBetweenCommonDirected(iScope, (List<IShape>)object, (List<IShape>)collection, (IShape)object3, (IShape)object4, bl5, bl);
        }
        return this.pathBetweenCommon(iScope, gamaSpatialGraph, (IShape)object222, (IShape)object5, (IShape)object3, (IShape)object4, bl5, bl);
    }

    public IShape getPathEdge(IScope iScope, IShape iShape) {
        if (iShape.getAgent() != null) {
            IShape iShape2 = (IShape)iShape.getAgent().getAttribute("current_edge");
            if (iShape2 != null && this.getPlaces().containsEdge(iShape2) && iShape.getLocation().euclidianDistanceTo(iShape2) < 0.1) {
                return iShape2;
            }
            GamaPath gamaPath = (GamaPath)iShape.getAgent().getAttribute("current_path");
            if (gamaPath != null && gamaPath.getTopology(iScope) != null && this.equals(gamaPath.getTopology(iScope)) && ((IShape)gamaPath.getStartVertex()).getLocation().equals(iShape.getLocation())) {
                int n = gamaPath.indexOf(iShape.getAgent());
                if (n >= gamaPath.getEdgeList().size()) {
                    return (IShape)gamaPath.getEdgeList().get(gamaPath.getEdgeList().size() - 1);
                }
                return (IShape)gamaPath.getEdgeList().get(n);
            }
        }
        return null;
    }

    public GamaSpatialPath pathBetweenCommon(IScope iScope, GamaSpatialGraph gamaSpatialGraph, IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4, boolean bl, boolean bl2) {
        IList<Object> iList = GamaListFactory.create(Types.GEOMETRY);
        if (bl && !bl2) {
            IShape iShape5 = (IShape)gamaSpatialGraph.getEdgeSource(iShape2);
            IShape iShape6 = (IShape)gamaSpatialGraph.getEdgeTarget(iShape2);
            double d = 0.0;
            boolean bl3 = true;
            if (iShape5 == iShape3) {
                d = this.lengthEdge(iShape2, iShape4, iShape6, iShape5);
            } else {
                IShape iShape7;
                iList = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape3, iShape5);
                boolean bl4 = iList.isEmpty();
                double d2 = d = bl4 ? Double.MAX_VALUE : this.pathlengthEdges(iList) + this.lengthEdge(iShape2, iShape4, iShape6, iShape5);
                if (!(bl4 || gamaSpatialGraph.getEdgeSource(iShape7 = (IShape)iList.get(iList.size() - 1)) != iShape6 && gamaSpatialGraph.getEdgeTarget(iShape7) != iShape6)) {
                    bl3 = false;
                }
            }
            if (bl3) {
                double d3 = 0.0;
                IList<Object> iList2 = GamaListFactory.create(Types.GEOMETRY);
                if (iShape6 == iShape3) {
                    d3 = this.lengthEdge(iShape2, iShape4, iShape5, iShape6);
                } else {
                    iList2 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape3, iShape6);
                    double d4 = d3 = iList2.isEmpty() ? Double.MAX_VALUE : this.pathlengthEdges(iList2) + this.lengthEdge(iShape2, iShape4, iShape5, iShape6);
                }
                if (d3 < d) {
                    iList = iList2;
                    d = d3;
                }
            }
            if (d == Double.MAX_VALUE) {
                return null;
            }
            if (iList.isEmpty() || iList.get(iList.size() - 1) != iShape2) {
                iList.add(iShape2);
            }
        } else if (!bl && bl2) {
            IShape iShape8 = (IShape)gamaSpatialGraph.getEdgeSource(iShape);
            IShape iShape9 = (IShape)gamaSpatialGraph.getEdgeTarget(iShape);
            double d = 0.0;
            boolean bl5 = true;
            if (iShape8 == iShape4) {
                d = this.lengthEdge(iShape, iShape3, iShape9, iShape8);
            } else {
                IShape iShape10;
                iList = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape8, iShape4);
                boolean bl6 = iList.isEmpty();
                double d5 = d = bl6 ? Double.MAX_VALUE : this.pathlengthEdges(iList) + this.lengthEdge(iShape, iShape3, iShape9, iShape8);
                if (!(bl6 || gamaSpatialGraph.getEdgeSource(iShape10 = (IShape)iList.get(0)) != iShape9 && gamaSpatialGraph.getEdgeTarget(iShape10) != iShape9)) {
                    bl5 = false;
                }
            }
            if (bl5) {
                double d6 = 0.0;
                IList<Object> iList3 = GamaListFactory.create(Types.GEOMETRY);
                if (iShape9 == iShape4) {
                    d6 = this.lengthEdge(iShape, iShape3, iShape8, iShape9);
                } else {
                    iList3 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape9, iShape4);
                    double d7 = d6 = iList3.isEmpty() ? Double.MAX_VALUE : this.pathlengthEdges(iList3) + this.lengthEdge(iShape, iShape3, iShape8, iShape9);
                }
                if (d6 < d) {
                    iList = iList3;
                    d = d6;
                }
            }
            if (d == Double.MAX_VALUE) {
                return null;
            }
            if (iList.isEmpty() || iList.get(0) != iShape) {
                iList.add(0, iShape);
            }
        } else {
            double d;
            IList<Object> iList4;
            IShape iShape11 = (IShape)gamaSpatialGraph.getEdgeSource(iShape);
            IShape iShape12 = (IShape)gamaSpatialGraph.getEdgeTarget(iShape);
            IShape iShape13 = (IShape)gamaSpatialGraph.getEdgeSource(iShape2);
            IShape iShape14 = (IShape)gamaSpatialGraph.getEdgeTarget(iShape2);
            double d8 = Double.MAX_VALUE;
            boolean bl7 = true;
            boolean bl8 = true;
            boolean bl9 = true;
            if (iShape11 == iShape13) {
                d8 = this.lengthEdge(iShape, iShape3, iShape12, iShape11) + this.lengthEdge(iShape2, iShape4, iShape14, iShape13);
            } else {
                IShape iShape15;
                IShape iShape16;
                iList = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape11, iShape13);
                boolean bl10 = iList.isEmpty();
                double d9 = this.lengthEdge(iShape, iShape3, iShape12, iShape11);
                double d10 = this.lengthEdge(iShape2, iShape4, iShape14, iShape13);
                double d11 = d8 = bl10 ? Double.MAX_VALUE : this.pathlengthEdges(iList) + d9 + d10;
                if (!bl10 && (iShape16 = (IShape)iList.get(0)) != (iShape15 = (IShape)iList.get(iList.size() - 1))) {
                    double d12;
                    boolean bl11 = gamaSpatialGraph.getEdgeSource(iShape16) == iShape12 || gamaSpatialGraph.getEdgeTarget(iShape16) == iShape12;
                    boolean bl12 = gamaSpatialGraph.getEdgeSource(iShape15) == iShape14 || gamaSpatialGraph.getEdgeTarget(iShape15) == iShape14;
                    double d13 = d8;
                    if (bl11) {
                        bl8 = false;
                        d12 = d8 - d9 - this.getPlaces().getEdgeWeight(iShape16) + this.lengthEdge(iShape, iShape3, iShape11, iShape12);
                        if (d13 > d12) {
                            d13 = d12;
                        }
                    }
                    if (bl12) {
                        bl7 = false;
                        d12 = d8 - d10 - this.getPlaces().getEdgeWeight(iShape15) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                        if (d13 > d12) {
                            d13 = d12;
                        }
                    }
                    if (bl11 && bl12) {
                        bl9 = false;
                        d12 = d8 - d9 - this.getPlaces().getEdgeWeight(iShape16) - d10 - this.getPlaces().getEdgeWeight(iShape15) + this.lengthEdge(iShape, iShape3, iShape11, iShape12) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                        if (d13 > d12) {
                            d13 = d12;
                        }
                    }
                    d8 = d13;
                }
            }
            if (bl8) {
                double d14 = 0.0;
                iList4 = GamaListFactory.create(Types.GEOMETRY);
                if (iShape12 == iShape13) {
                    d14 = this.lengthEdge(iShape, iShape3, iShape11, iShape12) + this.lengthEdge(iShape2, iShape4, iShape14, iShape13);
                } else {
                    IShape iShape17;
                    IShape iShape18;
                    iList4 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape12, iShape13);
                    boolean bl13 = iList4.isEmpty();
                    d = this.lengthEdge(iShape, iShape3, iShape11, iShape12);
                    double d15 = this.lengthEdge(iShape2, iShape4, iShape14, iShape13);
                    double d16 = d14 = bl13 ? Double.MAX_VALUE : this.pathlengthEdges(iList4) + d + d15;
                    if (!bl13 && (iShape18 = (IShape)iList4.get(0)) != (iShape17 = (IShape)iList4.get(iList4.size() - 1))) {
                        double d17;
                        boolean bl14 = gamaSpatialGraph.getEdgeSource(iShape18) == iShape11 || gamaSpatialGraph.getEdgeTarget(iShape18) == iShape11;
                        boolean bl15 = gamaSpatialGraph.getEdgeSource(iShape17) == iShape14 || gamaSpatialGraph.getEdgeTarget(iShape17) == iShape14;
                        double d18 = d14;
                        if (bl15) {
                            bl9 = false;
                            d17 = d14 - d15 - this.getPlaces().getEdgeWeight(iShape17) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                            if (d18 > d17) {
                                d18 = d17;
                            }
                        }
                        if (bl14 && bl15) {
                            bl7 = false;
                            d17 = d14 - d - this.getPlaces().getEdgeWeight(iShape18) - d15 - this.getPlaces().getEdgeWeight(iShape17) + this.lengthEdge(iShape, iShape3, iShape12, iShape11) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                            if (d18 > d17) {
                                d18 = d17;
                            }
                        }
                        d14 = d18;
                    }
                }
                if (d14 < d8) {
                    iList = iList4;
                    d8 = d14;
                }
            }
            if (bl7) {
                double d19 = 0.0;
                iList4 = GamaListFactory.create(Types.GEOMETRY);
                if (iShape11 == iShape14) {
                    d19 = this.lengthEdge(iShape, iShape3, iShape12, iShape11) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                } else {
                    iList4 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape11, iShape14);
                    boolean bl16 = iList4.isEmpty();
                    d = this.lengthEdge(iShape, iShape3, iShape12, iShape11);
                    double d20 = this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                    double d21 = d19 = bl16 ? Double.MAX_VALUE : this.pathlengthEdges(iList4) + d + d20;
                    if (!bl16) {
                        boolean bl17;
                        IShape iShape19 = (IShape)iList4.get(0);
                        boolean bl18 = bl17 = gamaSpatialGraph.getEdgeSource(iShape19) == iShape12 || gamaSpatialGraph.getEdgeTarget(iShape19) == iShape12;
                        if (bl17) {
                            bl9 = false;
                            double d22 = d19 - d - this.getPlaces().getEdgeWeight(iShape19) + this.lengthEdge(iShape, iShape3, iShape11, iShape12);
                            if (d19 > d22) {
                                d19 = d22;
                            }
                        }
                    }
                }
                if (d19 < d8) {
                    iList = iList4;
                    d8 = d19;
                }
            }
            if (bl9) {
                double d23 = 0.0;
                iList4 = GamaListFactory.create(Types.GEOMETRY);
                if (iShape12 == iShape14) {
                    d23 = this.lengthEdge(iShape, iShape3, iShape11, iShape12) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                } else {
                    iList4 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape12, iShape14);
                    double d24 = d23 = iList4.isEmpty() ? Double.MAX_VALUE : this.pathlengthEdges(iList4) + this.lengthEdge(iShape, iShape3, iShape11, iShape12) + this.lengthEdge(iShape2, iShape4, iShape13, iShape14);
                }
                if (d23 < d8) {
                    iList = iList4;
                    d8 = d23;
                }
            }
            if (d8 == Double.MAX_VALUE) {
                return null;
            }
            if (iList.isEmpty() || iList.get(0) != iShape) {
                iList.add(0, iShape);
            }
            if (iList.get(iList.size() - 1) != iShape2) {
                iList.add(iShape2);
            }
        }
        return PathFactory.newInstance(iScope, this, iShape3, iShape4, iList);
    }

    GamaSpatialPath pathFromEdgesUndirected(IScope iScope, IList<IShape> iList, IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4, boolean bl, boolean bl2, IShape iShape5, IShape iShape6, IShape iShape7, boolean bl3) {
        LinkedHashSet<Coordinate> linkedHashSet;
        LinkedHashSet<Coordinate> linkedHashSet2;
        IList<IShape> iList2 = iList;
        if (iList2.isEmpty() || iList2.get(0) == null) {
            return null;
        }
        if (!bl) {
            linkedHashSet2 = new LinkedHashSet<Coordinate>(Arrays.asList(((IShape)iList2.get(0)).getInnerGeometry().getCoordinates()));
            linkedHashSet = new LinkedHashSet<Coordinate>(Arrays.asList(iShape.getInnerGeometry().getCoordinates()));
            if (!linkedHashSet.equals(linkedHashSet2)) {
                double d = 0.0;
                double d2 = 1.0;
                IList<IShape> iList3 = null;
                if (bl3) {
                    d = this.pathlengthEdges(iList2) + this.lengthEdge(iShape, iShape3, iShape6, iShape5);
                    iList3 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape6, iShape7);
                    d2 = this.pathlengthEdges(iList3) + this.lengthEdge(iShape, iShape3, iShape5, iShape6);
                }
                if (d < d2 || iList3 == null || iList3.isEmpty() || iList3.get(0) == null) {
                    iList2.add(0, iShape);
                } else {
                    iList2 = iList3;
                    linkedHashSet2 = new LinkedHashSet<Coordinate>(Arrays.asList(((IShape)iList2.get(0)).getInnerGeometry().getCoordinates()));
                    if (!linkedHashSet.equals(linkedHashSet2)) {
                        iList2.add(0, iShape);
                    }
                }
            }
        }
        if (!bl2) {
            linkedHashSet2 = new LinkedHashSet<Coordinate>(Arrays.asList(((IShape)iList2.get(iList2.size() - 1)).getInnerGeometry().getCoordinates()));
            linkedHashSet = new LinkedHashSet<Coordinate>(Arrays.asList(iShape2.getInnerGeometry().getCoordinates()));
            if (!linkedHashSet.equals(linkedHashSet2)) {
                iList2.add(iShape2);
            }
        }
        return PathFactory.newInstance(iScope, this, iShape3, iShape4, iList2);
    }

    public double pathlengthEdges(IList<IShape> iList) {
        double d = 0.0;
        for (IShape iShape : iList) {
            d += this.getPlaces().getWeightOf(iShape).doubleValue();
        }
        return d;
    }

    public double lengthEdge(IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4) {
        double d = iShape3.getLocation().euclidianDistanceTo(iShape4.getLocation());
        return d == 0.0 ? 0.0 : this.getPlaces().getWeightOf(iShape) * iShape2.euclidianDistanceTo(iShape4.getLocation()) / d;
    }

    public GamaSpatialPath pathBetweenCommonDirected(IScope iScope, List<IShape> list, List<IShape> list2, IShape iShape, IShape iShape2, boolean bl, boolean bl2) {
        if (list.size() == 1 && list2.size() == 1) {
            return this.pathBetweenCommonDirected(iScope, list.get(0), list2.get(0), iShape, iShape2, bl, bl2);
        }
        double d = Double.MAX_VALUE;
        GamaSpatialPath gamaSpatialPath = null;
        for (IShape iShape3 : list) {
            for (IShape iShape4 : list2) {
                double d2;
                GamaSpatialPath gamaSpatialPath2 = this.pathBetweenCommonDirected(iScope, iShape3, iShape4, iShape, iShape2, bl, bl2);
                if (gamaSpatialPath2 == null || !((d2 = gamaSpatialPath2.getWeight()) < d)) continue;
                d = d2;
                gamaSpatialPath = gamaSpatialPath2;
            }
        }
        return gamaSpatialPath;
    }

    public GamaSpatialPath pathBetweenCommonDirected(IScope iScope, IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4, boolean bl, boolean bl2) {
        IShape iShape5;
        IShape iShape6;
        if (!bl && !bl2 && iShape.equals(iShape2) && iShape3.euclidianDistanceTo((GamaPoint)(iShape6 = new GamaPoint(iShape.getInnerGeometry().getCoordinates()[0]))) < iShape4.euclidianDistanceTo((GamaPoint)iShape6)) {
            IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
            iList.add(iShape);
            return PathFactory.newInstance(iScope, this, iShape3, iShape4, iList);
        }
        iShape6 = bl ? iShape3 : (IShape)this.getPlaces().getEdgeTarget(iShape);
        IShape iShape7 = iShape5 = bl2 ? iShape4 : (IShape)this.getPlaces().getEdgeSource(iShape2);
        if (iShape6.equals(iShape5)) {
            IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
            if (iShape != null) {
                iList.add(iShape);
            }
            if (iShape2 != null) {
                iList.add(iShape2);
            }
            return PathFactory.newInstance(iScope, this, iShape3, iShape4, iList);
        }
        IList<IShape> iList = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape6, iShape5);
        if (iList.isEmpty() || iList.get(0) == null) {
            return null;
        }
        if (!bl) {
            iList.add(0, iShape);
        }
        if (!bl2) {
            iList.add(iList.size(), iShape2);
        }
        return PathFactory.newInstance(iScope, this, iShape3, iShape4, iList);
    }

    public GamaSpatialPath pathBetween(IScope iScope, IShape iShape, IShape iShape2, IShape iShape3) {
        if (iShape.equals(iShape2)) {
            IList<IShape> iList = GamaListFactory.create(Types.GEOMETRY);
            if (iShape3 != null) {
                iList.add(iShape3);
            }
            return PathFactory.newInstance(iScope, this, iShape, iShape2, iList);
        }
        IList<IShape> iList = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape, iShape2);
        if (iShape3 != null) {
            iList = iList.listValue(iScope, Types.NO_TYPE, true);
            iList.addValueAtIndex(iScope, (Object)0, iShape3);
        }
        if (iList.isEmpty() || iList.get(0) == null) {
            return null;
        }
        return PathFactory.newInstance(iScope, this, iShape, iShape2, iList);
    }

    @Override
    public GamaSpatialPath pathBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        return this.pathBetween(iScope, (IShape)gamaPoint, (IShape)gamaPoint2);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "GraphTopology";
    }

    @Override
    protected String _toGaml(boolean bl) {
        return "GraphTopology";
    }

    @Override
    protected ITopology _copy(IScope iScope) {
        return new GraphTopology(iScope, this.environment, (GamaSpatialGraph)this.places);
    }

    public ISpatialGraph getPlaces() {
        return (GamaSpatialGraph)super.getPlaces();
    }

    @Override
    public boolean isValidLocation(IScope iScope, GamaPoint gamaPoint) {
        return this.isValidGeometry(iScope, gamaPoint.getGeometry());
    }

    @Override
    public boolean isValidGeometry(IScope iScope, IShape iShape) {
        for (IShape iShape2 : this.places.iterable(iScope)) {
            if (!iShape2.intersects(iShape)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Double distanceBetween(IScope iScope, IShape iShape, IShape iShape2) {
        GamaSpatialPath gamaSpatialPath = this.pathBetween(iScope, iShape, iShape2);
        if (gamaSpatialPath == null) {
            return Double.MAX_VALUE;
        }
        if (gamaSpatialPath.getEdgeList().isEmpty()) {
            return 0.0;
        }
        return gamaSpatialPath.getDistance(iScope);
    }

    @Override
    public Double distanceBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        GamaSpatialPath gamaSpatialPath = this.pathBetween(iScope, gamaPoint, gamaPoint2);
        if (gamaSpatialPath == null) {
            return Double.MAX_VALUE;
        }
        if (gamaSpatialPath.getEdgeList().isEmpty()) {
            return 0.0;
        }
        return gamaSpatialPath.getDistance(iScope);
    }

    @Override
    public Double directionInDegreesTo(IScope iScope, IShape iShape, IShape iShape2) {
        return this.root.directionInDegreesTo(iScope, iShape, iShape2);
    }

    @Override
    public Collection<IAgent> getAgentsIn(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, ITopology.SpatialRelation spatialRelation) {
        Collection<IAgent> collection = super.getAgentsIn(iScope, iShape, iAgentFilter, spatialRelation);
        collection.removeIf(iAgent -> iAgent.dead() || !this.isValidGeometry(iScope, (IShape)iAgent));
        return collection;
    }

    @Override
    public boolean isTorus() {
        return false;
    }

    public IList kPathsBetween(IScope iScope, IShape iShape, IShape iShape2, int n) {
        ISpatialGraph iSpatialGraph = this.getPlaces();
        if (iShape == iShape2) {
            return GamaListFactory.create();
        }
        boolean bl = iSpatialGraph.containsVertex(iShape);
        boolean bl2 = iSpatialGraph.containsVertex(iShape2);
        if (bl && bl2) {
            return iSpatialGraph.getPathComputer().computeKShortestPathsBetween(iScope, iShape, iShape2, n);
        }
        IShape iShape3 = null;
        IShape iShape4 = null;
        IAgentFilter iAgentFilter = In.edgesOf(this.getPlaces());
        if (!bl && (iShape3 = this.getPlaces().getEdgeSpecies() != null ? this.getAgentClosestTo(iScope, iShape, iAgentFilter) : this.shapeClosest(this.getPlaces().getEdges(), iShape)) == null) {
            return null;
        }
        if (!bl2 && (iShape4 = this.getPlaces().getEdgeSpecies() != null ? this.getAgentClosestTo(iScope, iShape2, iAgentFilter) : this.shapeClosest(this.getPlaces().getEdges(), iShape2)) == null) {
            return null;
        }
        if (this.getPlaces().isDirected()) {
            return this.KpathsBetweenCommonDirected(iScope, iShape3, iShape4, iShape, iShape2, bl, bl2, n);
        }
        return this.KpathsBetweenCommon(iScope, iShape3, iShape4, iShape, iShape2, bl, bl2, n);
    }

    public IShape shapeClosest(List<IShape> list, IShape iShape) {
        IShape iShape2 = null;
        double d = Double.MAX_VALUE;
        for (IShape iShape3 : list) {
            double d2 = iShape3.euclidianDistanceTo(iShape);
            if (!(d2 < d)) continue;
            d = d2;
            iShape2 = iShape3;
        }
        return iShape2;
    }

    @Override
    public IList<GamaSpatialPath> kPathsBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2, int n) {
        return this.kPathsBetween(iScope, gamaPoint.getGeometry(), gamaPoint2.getGeometry(), n);
    }

    public IList KpathsBetweenCommon(IScope iScope, IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4, boolean bl, boolean bl2, int n) {
        IValue iValue;
        IValue iValue2;
        IValue iValue3 = iShape3;
        IValue iValue4 = iShape3;
        IValue iValue5 = iShape4;
        if (!bl2) {
            iValue2 = null;
            iValue2 = (IShape)this.getPlaces().getEdgeSource(iShape2);
            iValue = (IShape)this.getPlaces().getEdgeTarget(iShape2);
            if (iValue2 == null || iValue == null) {
                return null;
            }
            iValue5 = iValue2;
            if (iValue2.getLocation().euclidianDistanceTo(iShape4.getLocation()) > iValue.getLocation().euclidianDistanceTo(iShape4.getLocation())) {
                iValue5 = iValue;
            }
        }
        if (!bl) {
            iValue2 = null;
            iValue2 = (IShape)this.getPlaces().getEdgeSource(iShape);
            iValue = (IShape)this.getPlaces().getEdgeTarget(iShape);
            if (iValue2 == null || iValue == null) {
                return null;
            }
            iValue3 = iValue2;
            iValue4 = iValue;
            if (iValue2.equals(iValue5) || !iValue.equals(iValue5) && iValue2.getLocation().euclidianDistanceTo(iShape3.getLocation()) > iValue.getLocation().euclidianDistanceTo(iShape3.getLocation())) {
                iValue3 = iValue;
                iValue4 = iValue2;
            }
        }
        iValue2 = this.getPlaces().getPathComputer().computeKBestRoutesBetween(iScope, iValue3, iValue5, n);
        iValue = GamaListFactory.create(Types.PATH);
        Iterator iterator = iValue2.iterator();
        while (iterator.hasNext()) {
            IList iList = (IList)iterator.next();
            GamaSpatialPath gamaSpatialPath = this.pathFromEdgesUndirected(iScope, iList, iShape, iShape2, iShape3, iShape4, bl, bl2, (IShape)iValue3, (IShape)iValue4, (IShape)iValue5, false);
            if (gamaSpatialPath == null) continue;
            iValue.add(gamaSpatialPath);
        }
        Collections.sort(iValue);
        return iValue;
    }

    public IList KpathsBetweenCommonDirected(IScope iScope, IShape iShape, IShape iShape2, IShape iShape3, IShape iShape4, boolean bl, boolean bl2, int n) {
        IShape iShape5;
        IShape iShape6;
        IList iList = GamaListFactory.create(Types.PATH);
        if (iShape.equals(iShape2) && iShape3.euclidianDistanceTo((GamaPoint)(iShape6 = new GamaPoint(iShape.getInnerGeometry().getCoordinates()[0]))) < iShape4.euclidianDistanceTo((GamaPoint)iShape6)) {
            IList<IShape> iList2 = GamaListFactory.create(Types.GEOMETRY);
            iList2.add(iShape);
            iList.add(PathFactory.newInstance(iScope, this, iShape3, iShape4, iList2));
            return iList;
        }
        iShape6 = bl ? iShape3 : (IShape)this.getPlaces().getEdgeTarget(iShape);
        IShape iShape7 = iShape5 = bl2 ? iShape4 : (IShape)this.getPlaces().getEdgeSource(iShape2);
        if (iShape6.equals(iShape5)) {
            IList<IShape> iList3 = GamaListFactory.create(Types.GEOMETRY);
            iList3.add(iShape);
            iList3.add(iShape2);
            iList.add(PathFactory.newInstance(iScope, this, iShape3, iShape4, iList3));
            return iList;
        }
        IList iList4 = this.getPlaces().getPathComputer().computeKBestRoutesBetween(iScope, iShape6, iShape5, n);
        for (IList iList2 : iList4) {
            IList<IShape> iList5 = this.getPlaces().getPathComputer().computeBestRouteBetween(iScope, iShape6, iShape5);
            if (iList5.isEmpty() || iList5.get(0) == null) continue;
            if (!bl) {
                iList5.add(0, iShape);
            }
            if (!bl2) {
                iList5.add(iList5.size(), iShape2);
            }
            GamaSpatialPath gamaSpatialPath = PathFactory.newInstance(iScope, this, iShape3, iShape4, iList5);
            iList.add(gamaSpatialPath);
        }
        Collections.sort(iList);
        return iList;
    }

    @Override
    public Collection<IAgent> getNeighborsOf(IScope iScope, IShape iShape, Double d, IAgentFilter iAgentFilter) throws GamaRuntimeException {
        ISpatialGraph iSpatialGraph = this.getPlaces();
        boolean bl = false;
        boolean bl2 = false;
        Throwable throwable = null;
        Object var9_10 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            IShape iShape2 = null;
            IShape iterator = null;
            if (iSpatialGraph.containsEdge(iShape)) {
                iShape2 = iShape;
            } else {
                double d2 = Double.POSITIVE_INFINITY;
                for (IShape object : iSpatialGraph.getEdges()) {
                    double d3 = object.euclidianDistanceTo(iShape);
                    if (!(d3 < d2)) continue;
                    d2 = d3;
                    iterator = object;
                }
                iShape2 = iShape.euclidianDistanceTo((IShape)iSpatialGraph.getEdgeSource(iterator)) < iShape.euclidianDistanceTo((IShape)iSpatialGraph.getEdgeTarget(iterator)) ? (IShape)iSpatialGraph.getEdgeSource(iterator) : (IShape)iSpatialGraph.getEdgeTarget(iterator);
            }
            if (iAgentFilter.getSpecies() != null) {
                bl = iAgentFilter.getSpecies() == iSpatialGraph.getEdgeSpecies();
                boolean bl3 = bl2 = iAgentFilter.getSpecies() == iSpatialGraph.getVertexSpecies();
            }
            if (bl) {
                Set<IShape> set = this.getNeighborsOfRec(iScope, iShape2, true, d, iSpatialGraph, new LinkedHashSet<IShape>());
                for (IShape iShape3 : set) {
                    asOrderedSet.add(iShape3.getAgent());
                }
                return asOrderedSet.items();
            }
            if (bl2) {
                Set<IShape> set = this.getNeighborsOfRec(iScope, iShape2, false, d, iSpatialGraph, new LinkedHashSet<IShape>());
                for (IShape iShape4 : set) {
                    asOrderedSet.add(iShape4.getAgent());
                }
                return asOrderedSet.items();
            }
            IContainer<Object, IAgent> iContainer = null;
            iContainer = iAgentFilter.getSpecies() != null ? iAgentFilter.getSpecies().getAgents(iScope) : iScope.getSimulation().getAgents(iScope);
            Set<IShape> set = this.getNeighborsOfRec(iScope, iShape2, true, d, iSpatialGraph, new LinkedHashSet<IShape>());
            for (Object object : iContainer.iterable(iScope)) {
                IShape iShape5 = (IShape)object;
                if (!iAgentFilter.accept(iScope, iShape, iShape5)) continue;
                IShape iShape6 = null;
                if (iSpatialGraph.getEdges().contains(iShape5)) {
                    iShape6 = iShape5;
                } else {
                    double d4 = Double.POSITIVE_INFINITY;
                    for (IShape iShape7 : iSpatialGraph.getEdges()) {
                        double d5 = iShape7.euclidianDistanceTo(iShape5);
                        if (!(d5 < d4)) continue;
                        d4 = d5;
                        iShape6 = iShape7;
                    }
                }
                if (!set.contains(iShape6) || !(this.distanceBetween(iScope, iShape, iShape5) <= d)) continue;
                asOrderedSet.add(iShape5.getAgent());
            }
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public Set<IShape> getNeighborsOfRec(IScope iScope, IShape iShape, boolean bl, double d, ISpatialGraph iSpatialGraph, Set<IShape> set) throws GamaRuntimeException {
        Throwable throwable = null;
        Object var9_9 = null;
        try (Collector.AsOrderedSet asOrderedSet = Collector.getOrderedSet();){
            Set set2;
            Set set3 = set2 = iSpatialGraph.isDirected() ? iSpatialGraph.outgoingEdgesOf(iShape) : iSpatialGraph.edgesOf(iShape);
            if (!bl) {
                asOrderedSet.add(iShape.getAgent());
            }
            for (IShape iShape2 : set2) {
                if (set.contains(iShape2)) continue;
                set.add(iShape2);
                double d2 = this.getPlaces().getEdgeWeight(iShape2);
                if (bl) {
                    asOrderedSet.add(iShape2);
                }
                if (!(d - d2 > 0.0)) continue;
                IShape iShape3 = null;
                iShape3 = iSpatialGraph.isDirected() ? (IShape)iSpatialGraph.getEdgeTarget(iShape2) : (iShape == iSpatialGraph.getEdgeTarget(iShape2) ? (IShape)iSpatialGraph.getEdgeSource(iShape2) : (IShape)iSpatialGraph.getEdgeTarget(iShape2));
                asOrderedSet.addAll(this.getNeighborsOfRec(iScope, iShape3, bl, d - d2, iSpatialGraph, set));
            }
            return asOrderedSet.items();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public IAgent getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter) {
        ArrayList<? extends IAgent> arrayList = new ArrayList<IAgent>();
        arrayList.addAll(iAgentFilter.getAgents(iScope).listValue(iScope, Types.AGENT, false));
        arrayList.remove(iShape);
        IAgent iAgent = null;
        double d = Double.POSITIVE_INFINITY;
        for (IAgent iAgent2 : arrayList) {
            Double d2 = this.distanceBetween(iScope, iShape, iAgent2);
            if (!(d2 < d)) continue;
            iAgent = iAgent2;
            d = d2;
            if (d2 == 0.0) break;
        }
        return iAgent;
    }

    @Override
    public Collection<IAgent> getAgentClosestTo(IScope iScope, IShape iShape, IAgentFilter iAgentFilter, int n) {
        ArrayList<? extends IAgent> arrayList = new ArrayList<IAgent>();
        arrayList.addAll(iAgentFilter.getAgents(iScope).listValue(iScope, Types.AGENT, false));
        arrayList.remove(iShape);
        iScope.getRandom().shuffleInPlace(arrayList);
        Ordering ordering = Ordering.natural().onResultOf(iAgent -> this.distanceBetween(iScope, iShape, (IShape)iAgent));
        if (arrayList.size() <= n) {
            Collections.sort(arrayList, ordering);
            return GamaListFactory.wrap(Types.AGENT, arrayList);
        }
        return GamaListFactory.wrap(Types.AGENT, ordering.leastOf(arrayList, n));
    }
}

