/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers;

import gama.core.common.interfaces.IGraphics;
import gama.core.common.interfaces.ILayer;
import gama.core.outputs.layers.ILayerData;
import gama.core.outputs.layers.ILayerStatement;
import gama.core.outputs.layers.LayerData;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.dev.DEBUG;

public abstract class AbstractLayer
implements ILayer {
    protected ILayerStatement definition;
    private String name;
    volatile boolean hasBeenDrawnOnce;
    volatile int counter;
    private final ILayerData data;

    static {
        DEBUG.ON();
    }

    public AbstractLayer(ILayerStatement iLayerStatement) {
        this.definition = iLayerStatement;
        if (this.definition != null) {
            this.setName(this.definition.getName());
        }
        this.data = this.createData();
    }

    @Override
    public ILayerStatement getDefinition() {
        return this.definition;
    }

    @Override
    public ILayerData getData() {
        return this.data;
    }

    protected ILayerData createData() {
        return new LayerData(this.definition);
    }

    @Override
    public void forceRedrawingOnce() {
        this.hasBeenDrawnOnce = false;
    }

    public void setHasBeenDrawnOnce() {
        this.hasBeenDrawnOnce = true;
    }

    @Override
    public void draw(IScope.IGraphicsScope iGraphicsScope, IGraphics iGraphics) throws GamaRuntimeException {
        if (this.data.compute(iGraphicsScope, iGraphics)) {
            this.forceRedrawingOnce();
        }
        if (!this.data.isVisible().booleanValue() || !iGraphics.is2D() && !this.data.isDynamic() && this.hasBeenDrawnOnce) {
            return;
        }
        iGraphics.setAlpha(1.0 - this.data.getTransparency(iGraphicsScope));
        iGraphics.beginDrawingLayer(this);
        this.privateDraw(iGraphicsScope, iGraphics);
        iGraphics.endDrawingLayer(this);
        if (!this.hasBeenDrawnOnce) {
            this.hasBeenDrawnOnce = true;
        }
    }

    protected boolean shouldDraw(IGraphics iGraphics) {
        if (!this.getData().isVisible().booleanValue() || iGraphics.isNotReadyToUpdate()) {
            return false;
        }
        return this.getData().isDynamic() || this.hasBeenDrawnOnce;
    }

    protected abstract void privateDraw(IScope.IGraphicsScope var1, IGraphics var2) throws GamaRuntimeException;

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final void setName(String string) {
        this.name = string;
    }
}

