/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.geometry.Envelope3D;
import gama.core.common.interfaces.IValue;
import gama.core.common.util.FileUtils;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaPair;
import gama.core.util.IList;
import gama.core.util.file.Gama3DGeometryFile;
import gama.core.util.file.MtlLoader;
import gama.dev.DEBUG;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.Types;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

@GamlAnnotations.file(name="obj", extensions={"obj", "OBJ"}, buffer_type=5, buffer_content=13, doc={@GamlAnnotations.doc(value="'.obj' files are files containing 3D geometries. The internal representation is a list of one geometry")})
public class GamaObjFile
extends Gama3DGeometryFile {
    public final ArrayList<double[]> setOfVertex = new ArrayList();
    public final ArrayList<double[]> setOfVertexNormals = new ArrayList();
    public final ArrayList<double[]> setOfVertexTextures = new ArrayList();
    public final ArrayList<int[]> faces = new ArrayList();
    public final ArrayList<int[]> facesTexs = new ArrayList();
    public final ArrayList<int[]> facesNorms = new ArrayList();
    public final ArrayList<String[]> matTimings = new ArrayList();
    public MtlLoader materials;
    public double toppoint = 0.0;
    public double bottompoint = 0.0;
    public double leftpoint = 0.0;
    public double rightpoint = 0.0;
    public double farpoint = 0.0;
    public double nearpoint = 0.0;
    public final String mtlPath;
    boolean loaded = false;

    @GamlAnnotations.doc(value="This file constructor allows to read an obj file. The associated mlt file have to have the same name as the file to be read.", examples={@GamlAnnotations.example(value="file f <- obj_file(\"file.obj\");", isExecutable=false)})
    public GamaObjFile(IScope iScope, String string) throws GamaRuntimeException {
        this(iScope, string, (GamaPair<Double, GamaPoint>)null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an obj file and apply an init rotation to it. The rotationis a pair angle::rotation vector. The associated mlt file have to have the same name as the file to be read.", examples={@GamlAnnotations.example(value="file f <- obj_file(\"file.obj\", 90.0::{-1,0,0});", isExecutable=false)})
    public GamaObjFile(IScope iScope, String string, GamaPair<Double, GamaPoint> gamaPair) throws GamaRuntimeException {
        this(iScope, string, string.replace(".obj", ".mtl"), gamaPair);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an obj file, using a specific mlt file", examples={@GamlAnnotations.example(value="file f <- obj_file(\"file.obj\",\"file.mlt\");", isExecutable=false)})
    public GamaObjFile(IScope iScope, String string, String string2) {
        this(iScope, string, string2, null);
    }

    @GamlAnnotations.doc(value="This file constructor allows to read an obj file, using a specific mlt file, and apply an init rotation to it. The rotationis a pair angle::rotation vector", examples={@GamlAnnotations.example(value="file f <- obj_file(\"file.obj\",\"file.mlt\", 90.0::{-1,0,0});", isExecutable=false)})
    public GamaObjFile(IScope iScope, String string, String string2, GamaPair<Double, GamaPoint> gamaPair) {
        super(iScope, string, gamaPair);
        this.mtlPath = string2 != null ? FileUtils.constructAbsoluteFilePath(iScope, string2, false) : null;
    }

    private void centerit() {
        double d = (this.rightpoint - this.leftpoint) / 2.0;
        double d2 = (this.toppoint - this.bottompoint) / 2.0;
        double d3 = (this.nearpoint - this.farpoint) / 2.0;
        int n = 0;
        while (n < this.setOfVertex.size()) {
            double[] dArray = new double[4];
            dArray[0] = this.setOfVertex.get(n)[0] - this.leftpoint - d;
            dArray[1] = this.setOfVertex.get(n)[1] - this.bottompoint - d2;
            dArray[2] = this.setOfVertex.get(n)[2] - this.farpoint - d3;
            this.setOfVertex.set(n, dArray);
            ++n;
        }
    }

    public void loadObject(IScope iScope, boolean bl) {
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new FileReader(this.getFile(iScope)));){
                this.loadObject(bufferedReader);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)"Failed to read file: ");
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG.ERR((Object)("Malformed OBJ file: \r \r" + numberFormatException.getMessage()));
        }
    }

    public void loadObject(BufferedReader bufferedReader) throws IOException {
        String string;
        if (this.loaded) {
            return;
        }
        int n = 0;
        boolean bl = true;
        while ((string = bufferedReader.readLine()) != null) {
            Object object;
            if (string.length() <= 0) continue;
            if ((string = string.trim()).startsWith("v ")) {
                string = string.substring(2);
                object = new StringTokenizer(string, " ");
                double[] dArray = new double[((StringTokenizer)object).countTokens()];
                int n2 = 0;
                while (((StringTokenizer)object).hasMoreTokens()) {
                    dArray[n2] = Double.parseDouble(((StringTokenizer)object).nextToken());
                    ++n2;
                }
                if (bl) {
                    this.rightpoint = dArray[0];
                    this.leftpoint = dArray[0];
                    this.toppoint = dArray[1];
                    this.bottompoint = dArray[1];
                    this.nearpoint = dArray[2];
                    this.farpoint = dArray[2];
                    bl = false;
                }
                if (dArray[0] > this.rightpoint) {
                    this.rightpoint = dArray[0];
                }
                if (dArray[0] < this.leftpoint) {
                    this.leftpoint = dArray[0];
                }
                if (dArray[1] > this.toppoint) {
                    this.toppoint = dArray[1];
                }
                if (dArray[1] < this.bottompoint) {
                    this.bottompoint = dArray[1];
                }
                if (dArray[2] > this.nearpoint) {
                    this.nearpoint = dArray[2];
                }
                if (dArray[2] < this.farpoint) {
                    this.farpoint = dArray[2];
                }
                this.setOfVertex.add(dArray);
                continue;
            }
            if (string.startsWith("vt")) {
                object = new double[4];
                string = string.substring(3);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n3 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n3] = Double.parseDouble(stringTokenizer.nextToken());
                    ++n3;
                }
                this.setOfVertexTextures.add((double[])object);
                continue;
            }
            if (string.startsWith("vn")) {
                object = new double[4];
                string = string.substring(3);
                StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
                int n4 = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    object[n4] = Double.parseDouble(stringTokenizer.nextToken());
                    ++n4;
                }
                this.setOfVertexNormals.add((double[])object);
                continue;
            }
            if (string.startsWith("f ")) {
                ++n;
                string = string.substring(2);
                object = new StringTokenizer(string, " ");
                int n5 = ((StringTokenizer)object).countTokens();
                int[] nArray = new int[n5];
                int[] nArray2 = new int[n5];
                int[] nArray3 = new int[n5];
                int n6 = 0;
                while (n6 < n5) {
                    char[] cArray = ((StringTokenizer)object).nextToken().toCharArray();
                    StringBuilder stringBuilder = new StringBuilder();
                    char c = 'x';
                    char[] cArray2 = cArray;
                    int n7 = cArray.length;
                    int n8 = 0;
                    while (n8 < n7) {
                        char c2 = cArray2[n8];
                        if (c2 == '/' && c == '/') {
                            stringBuilder.append('0');
                        }
                        c = c2;
                        stringBuilder.append(c);
                        ++n8;
                    }
                    StringTokenizer stringTokenizer = new StringTokenizer(stringBuilder.toString(), "/");
                    n8 = stringTokenizer.countTokens();
                    nArray[n6] = Integer.parseInt(stringTokenizer.nextToken());
                    nArray2[n6] = n8 > 1 ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                    nArray3[n6] = n8 > 2 ? Integer.parseInt(stringTokenizer.nextToken()) : 0;
                    ++n6;
                }
                this.faces.add(nArray);
                this.facesTexs.add(nArray2);
                this.facesNorms.add(nArray3);
                continue;
            }
            if (string.charAt(0) == 'm' && string.charAt(1) == 't' && string.charAt(2) == 'l' && string.charAt(3) == 'l' && string.charAt(4) == 'i' && string.charAt(5) == 'b') {
                if (this.mtlPath == null) continue;
                this.loadMaterials();
                continue;
            }
            if (string.charAt(0) != 'u' || string.charAt(1) != 's' || string.charAt(2) != 'e' || string.charAt(3) != 'm' || string.charAt(4) != 't' || string.charAt(5) != 'l') continue;
            object = new String[2];
            String[] stringArray = string.split("\\s+");
            object[0] = stringArray[1];
            object[1] = "" + n;
            this.matTimings.add((String[])object);
        }
        this.centerit();
        this.loaded = true;
    }

    @Override
    protected void fillBuffer(IScope iScope) throws GamaRuntimeException {
        IValue iValue;
        this.loadObject(iScope, false);
        this.setBuffer(GamaListFactory.create(Types.GEOMETRY));
        IList iList = GamaListFactory.create(Types.POINT);
        for (Object[] objectArray : this.setOfVertex) {
            iValue = new GamaPoint(objectArray[0], -objectArray[1], objectArray[2]);
            iList.add(iValue);
        }
        Iterator<double[]> iterator = this.faces.iterator();
        while (iterator.hasNext()) {
            Object[] objectArray;
            objectArray = (int[])iterator.next();
            iValue = GamaListFactory.create(Types.POINT);
            Object[] objectArray2 = objectArray;
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                double d = objectArray2[n2];
                iValue.add((IShape)iList.get((int)(d - true)));
                ((IList)this.getBuffer()).add(GamaGeometryType.buildPolygon((List<? extends IShape>)((Object)iValue)));
                ++n2;
            }
        }
        this.envelope = Envelope3D.of(this.leftpoint, this.rightpoint, this.bottompoint, this.toppoint, this.nearpoint, this.farpoint);
    }

    @Override
    public IList<String> getAttributes(IScope iScope) {
        return GamaListFactory.create();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadMaterials() {
        String string = this.mtlPath;
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try {
                FileReader fileReader = new FileReader(string);
                try {
                    try (BufferedReader bufferedReader = new BufferedReader(fileReader);){
                        this.materials = new MtlLoader(bufferedReader, this.mtlPath);
                    }
                    if (fileReader == null) return;
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    if (fileReader == null) throw throwable;
                    fileReader.close();
                    throw throwable;
                }
                fileReader.close();
                return;
            }
            catch (Throwable throwable3) {
                if (throwable == null) {
                    throwable = throwable3;
                    throw throwable;
                } else {
                    if (throwable == throwable3) throw throwable;
                    throwable.addSuppressed(throwable3);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            DEBUG.ERR((Object)("Could not open file: " + string));
            this.materials = null;
        }
    }
}

