/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.operators;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.ByteArrayZipper;
import gama.core.util.GamaListFactory;
import gama.core.util.IList;
import gama.gaml.operators.Cast;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.nio.charset.StandardCharsets;
import java.util.StringJoiner;
import java.util.StringTokenizer;
import java.util.regex.MatchResult;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class Strings {
    public static final String LN = System.lineSeparator();
    public static final String TAB = "\t";

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"}, doc={@GamlAnnotations.doc(value="Concatenates the two string operands")})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand and right-hand operand are a string, returns the concatenation of the two operands", examples={@GamlAnnotations.example(value="\"hello \" + \"World\"", equals="\"hello World\"")})})
    @GamlAnnotations.tests(value={@GamlAnnotations.test(value="'a'+'b'='ab'"), @GamlAnnotations.test(value="''+'' = ''"), @GamlAnnotations.test(value="string a <- 'a'; a + '' = a")})
    public static String opPlus(String string, String string2) {
        return string + string2;
    }

    @GamlAnnotations.operator(value={"+"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-hand operand is a string, returns the concatenation of the two operands (the left-hand one beind casted into a string)", examples={@GamlAnnotations.example(value="\"hello \" + 12", equals="\"hello 12\"")})})
    public static String opPlus(IScope iScope, String string, Object object) throws GamaRuntimeException {
        return string + Cast.asString(iScope, object);
    }

    @GamlAnnotations.operator(value={"concatenate"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="concatenates a list of string into a string. More efficient than looping over the list and adding the strings individually", examples={@GamlAnnotations.example(value="concatenate(['a','bc'])", equals="'abc'")})})
    public static String opConcatenate(IScope iScope, IList<String> iList) throws GamaRuntimeException {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : iList) {
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    @GamlAnnotations.operator(value={"concatenate"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="concatenates a list of string into a string, inserting the separator between each. More efficient than looping over the list and adding the strings individually", examples={@GamlAnnotations.example(value="concatenate(['a','bc', 'cd'], '--')", equals="'a--bc--cd'")})})
    public static String opConcatenateSep(IScope iScope, IList<String> iList, String string) throws GamaRuntimeException {
        StringJoiner stringJoiner = new StringJoiner(string);
        for (String string2 : iList) {
            stringJoiner.add(string2);
        }
        return stringJoiner.toString();
    }

    @GamlAnnotations.operator(value={"in"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are strings, returns true if the left-hand operand patterns is included in to the right-hand string;")}, examples={@GamlAnnotations.example(value=" 'bc' in 'abcded'", equals="true")})
    public static Boolean opIn(String string, String string2) {
        return string2.contains(string);
    }

    @GamlAnnotations.operator(value={"contains"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are strings, returns true if the right-hand operand contains the right-hand pattern;")}, examples={@GamlAnnotations.example(value="'abcded' contains 'bc'", equals="true")})
    public static Boolean opContains(String string, String string2) {
        return Strings.opIn(string2, string);
    }

    @GamlAnnotations.operator(value={"contains_any"}, can_be_const=true, expected_content_type={4}, concept={"string"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="\"abcabcabc\" contains_any [\"ca\",\"xy\"]", equals="true")})
    public static Boolean opContainsAny(String string, IList iList) {
        for (Object e : iList) {
            if (!(e instanceof String) || !Strings.opContains(string, (String)e).booleanValue()) continue;
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"contains_all"}, can_be_const=true, expected_content_type={4}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if the left-operand is a string, test whether the string contains all the element of the list;", examples={@GamlAnnotations.example(value="\"abcabcabc\" contains_all [\"ca\",\"xy\"]", equals="false")})})
    public static Boolean opContainsAll(String string, IList iList) {
        for (Object e : iList) {
            if (e instanceof String && Strings.opContains(string, (String)e).booleanValue()) continue;
            return false;
        }
        return true;
    }

    @GamlAnnotations.operator(value={"index_of"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are strings, returns the index within the left-hand string of the first occurrence of the given right-hand string", examples={@GamlAnnotations.example(value="\"abcabcabc\" index_of \"ca\"", equals="2")})})
    public static Integer opIndexOf(String string, String string2) {
        return string.indexOf(string2);
    }

    @GamlAnnotations.operator(value={"last_index_of"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if both operands are strings, returns the index within the left-hand string of the rightmost occurrence of the given right-hand string", examples={@GamlAnnotations.example(value="\"abcabcabc\" last_index_of \"ca\"", equals="5")})})
    public static Integer opLastIndexOf(String string, String string2) {
        return string.lastIndexOf(string2);
    }

    @GamlAnnotations.operator(value={"copy_between"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="copy_between(\"abcabcabc\", 2,6)", equals="\"cabc\"")})
    public static String opCopy(String string, Integer n, Integer n2) {
        int n3;
        int n4 = n < 0 ? 0 : n;
        int n5 = n3 = n2 > string.length() ? string.length() : n2.intValue();
        if (n4 >= n3) {
            return "";
        }
        return string.substring(n4, n3);
    }

    @GamlAnnotations.operator(value={"split_with", "tokenize"}, content_type=4, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns a list containing the sub-strings (tokens) of the left-hand operand delimited by each of the characters of the right-hand operand.", masterDoc=true, comment="Delimiters themselves are excluded from the resulting list.", examples={@GamlAnnotations.example(value="'to be or not to be,that is the question' split_with ' ,'", equals="['to','be','or','not','to','be','that','is','the','question']")})
    public static IList opTokenize(IScope iScope, String string, String string2) {
        return Strings.opTokenize(iScope, string, string2, false);
    }

    @GamlAnnotations.operator(value={"split_with", "tokenize"}, content_type=4, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns a list containing the sub-strings (tokens) of the left-hand operand delimited either by each of the characters of the right-hand operand (false) or by the whole right-hand operand (true).", usages={@GamlAnnotations.usage(value="when used  with an  additional boolean operand, it returns a list containing the sub-strings (tokens) of the left-hand operand delimited either by each of the characters of the right-hand operand (false) or by the whole right-hand operand (true).")}, examples={@GamlAnnotations.example(value="'aa::bb:cc' split_with ('::', true)", equals="['aa','bb:cc']"), @GamlAnnotations.example(value="'aa::bb:cc' split_with ('::', false)", equals="['aa','bb','cc']")})
    public static IList opTokenize(IScope iScope, String string, String string2, Boolean bl) {
        if (bl.booleanValue()) {
            return GamaListFactory.create(iScope, (IType)Types.STRING, string.split(string2));
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, string2);
        return GamaListFactory.create(iScope, (IType)Types.STRING, stringTokenizer);
    }

    @GamlAnnotations.operator(value={"replace"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns the string obtained by replacing by the third operand, in the first operand, all the sub-strings equal to the second operand", examples={@GamlAnnotations.example(value="replace('to be or not to be,that is the question','to', 'do')", equals="'do be or not do be,that is the question'")}, see={"replace_regex"})
    public static String opReplace(String string, String string2, String string3) {
        return string.replace(string2, string3);
    }

    @GamlAnnotations.operator(value={"replace_regex"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns the string obtained by replacing by the third operand, in the first operand, all the sub-strings that match the regular expression of the second operand", examples={@GamlAnnotations.example(value="replace_regex(\"colour, color\", \"colou?r\", \"col\")", equals="'col, col'")}, see={"replace"})
    public static String opReplaceRegex(String string, String string2, String string3) {
        return string.replaceAll(string2, string3);
    }

    @GamlAnnotations.operator(value={"regex_matches"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns the list of sub-strings of the first operand that match the regular expression provided in the second operand", examples={@GamlAnnotations.example(value="regex_matches(\"colour, color\", \"colou?r\")", equals="['colour','color']")}, see={"replace_regex"})
    public static IList<String> opRegexMatches(String string, String string2) {
        Pattern pattern;
        if (string2 == null || string2.isEmpty()) {
            return GamaListFactory.create();
        }
        try {
            pattern = Pattern.compile(string2);
        }
        catch (PatternSyntaxException patternSyntaxException) {
            return string.contains(string2) ? GamaListFactory.createWithoutCasting((IType)Types.STRING, string2) : GamaListFactory.create();
        }
        return GamaListFactory.wrap((IType)Types.STRING, pattern.matcher(string).results().map(MatchResult::group).toList());
    }

    /*
     * Unable to fully structure code
     */
    @GamlAnnotations.operator(value={"is_number"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="tests whether the operand represents a numerical value", comment="Note that the symbol . should be used for a float value (a string with , will not be considered as a numeric value). Symbols e and E are also accepted. A hexadecimal value should begin with #.", examples={@GamlAnnotations.example(value="is_number(\"test\")", equals="false"), @GamlAnnotations.example(value="is_number(\"123.56\")", equals="true"), @GamlAnnotations.example(value="is_number(\"-1.2e5\")", equals="true"), @GamlAnnotations.example(value="is_number(\"1,2\")", equals="false"), @GamlAnnotations.example(value="is_number(\"#12FA\")", equals="true")})
    public static Boolean isGamaNumber(String var0) {
        block19: {
            if (var0 == null) {
                return false;
            }
            var1_1 = var0.length();
            if (var1_1 == 0) {
                return false;
            }
            var2_2 = var1_1;
            var3_3 = false;
            var4_4 = false;
            var5_5 = false;
            var6_6 = false;
            v0 = var7_7 = var0.charAt(0) == '-' ? 1 : 0;
            if (var2_2 <= var7_7 + 1 || var0.charAt(var7_7) != '#') break block19;
            var8_8 = var7_7 + 1;
            if (var8_8 != var2_2) ** GOTO lbl20
            return false;
lbl-1000:
            // 1 sources

            {
                var9_10 = var0.charAt(var8_8);
                if (!(var9_10 >= '0' && var9_10 <= '9' || var9_10 >= 'a' && var9_10 <= 'f' || var9_10 >= 'A' && var9_10 <= 'F')) {
                    return false;
                }
                ++var8_8;
lbl20:
                // 2 sources

                ** while (var8_8 < var1_1)
            }
lbl21:
            // 1 sources

            return true;
        }
        --var2_2;
        var8_9 = var7_7;
        while (var8_9 < var2_2 || var8_9 < var2_2 + 1 && var5_5 && !var6_6) {
            var9_11 = var0.charAt(var8_9);
            if (var9_11 >= '0' && var9_11 <= '9') {
                var6_6 = true;
                var5_5 = false;
            } else {
                switch (var9_11) {
                    case '.': {
                        if (var4_4 || var3_3) {
                            return false;
                        }
                        var4_4 = true;
                        break;
                    }
                    case 'E': 
                    case 'e': {
                        if (var3_3 || !var6_6) {
                            return false;
                        }
                        var3_3 = true;
                        var5_5 = true;
                        break;
                    }
                    case '-': {
                        if (!var5_5) {
                            return false;
                        }
                        var5_5 = false;
                        var6_6 = false;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
            }
            ++var8_9;
        }
        if (var8_9 < var1_1) {
            var9_11 = var0.charAt(var8_9);
            if (var9_11 >= '0' && var9_11 <= '9') {
                return true;
            }
            if (var9_11 == 'e' || var9_11 == 'E') {
                return false;
            }
        }
        if (!var5_5 && var6_6) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"reverse"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if it is a string, reverse returns a new string with characters in the reversed order", examples={@GamlAnnotations.example(value="reverse ('abcd')", equals="'dcba'")})})
    public static String reverse(String string) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.reverse();
        return stringBuilder.toString();
    }

    @GamlAnnotations.operator(value={"empty"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if it is a string, empty returns true if the string does not contain any character, and false otherwise", examples={@GamlAnnotations.example(value="empty ('abced')", equals="false")})})
    public static Boolean isEmpty(String string) {
        if (string != null && string.isEmpty()) {
            return true;
        }
        return false;
    }

    @GamlAnnotations.operator(value={"first"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if it is a string, first returns a string composed of its first character", examples={@GamlAnnotations.example(value="first ('abce')", equals="'a'")})})
    public static String first(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        return String.valueOf(string.charAt(0));
    }

    @GamlAnnotations.operator(value={"last"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if it is a string, last returns a string composed of its last character, or an empty string if the operand is empty", examples={@GamlAnnotations.example(value="last ('abce')", equals="'e'")})})
    public static String last(String string) {
        if (string == null || string.isEmpty()) {
            return "";
        }
        return String.valueOf(string.charAt(string.length() - 1));
    }

    @GamlAnnotations.operator(value={"length"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="if it is a string, length returns the number of characters", examples={@GamlAnnotations.example(value="length (\"I am an agent\")", equals="13")})})
    public static Integer length(String string) {
        if (string == null) {
            return 0;
        }
        return string.length();
    }

    @GamlAnnotations.operator(value={"at", "@"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(examples={@GamlAnnotations.example(value="'abcdef' at 0", equals="'a'")})
    public static String get(String string, int n) {
        return n < string.length() && n >= 0 ? string.substring(n, n + 1) : "";
    }

    @GamlAnnotations.operator(value={"char"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(usages={@GamlAnnotations.usage(value="converts ACSII integer value to character", examples={@GamlAnnotations.example(value="char (34)", equals="'\"'")})})
    public static String asChar(Integer n) {
        if (n == null) {
            return "";
        }
        return Character.toString((char)n.byteValue());
    }

    @GamlAnnotations.operator(value={"indented_by"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Converts a (possibly multiline) string by indenting it by a number -- specified by the second operand -- of tabulations to the right", examples={@GamlAnnotations.example(value="\"my\" + indented_by(\"text\", 1)", equals="\"my\ttext\"")})
    public static String indent(String string, int n) {
        if (n <= 0) {
            return string;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(TAB);
            ++n2;
        }
        String string2 = stringBuilder.toString();
        return string.replaceAll("(?m)^", string2);
    }

    @GamlAnnotations.operator(value={"lower_case"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Converts all of the characters in the string operand to lower case", examples={@GamlAnnotations.example(value="lower_case(\"Abc\")", equals="'abc'")}, see={"upper_case"})
    public static String toLowerCase(String string) {
        if (string == null) {
            return string;
        }
        return string.toLowerCase();
    }

    @GamlAnnotations.operator(value={"upper_case"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Converts all of the characters in the string operand to upper case", examples={@GamlAnnotations.example(value="upper_case(\"Abc\")", equals="'ABC'")}, see={"lower_case"})
    public static String toUpperCase(String string) {
        if (string == null) {
            return string;
        }
        return string.toUpperCase();
    }

    @GamlAnnotations.operator(value={"capitalize"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns a string where the first letter is capitalized", examples={@GamlAnnotations.example(value="capitalize(\"abc\")", equals="'Abc'")}, see={"lower_case", "upper_case"})
    public static String capitalize(IScope iScope, String string) {
        if (string == null) {
            throw GamaRuntimeException.error("String cannot be null", iScope);
        }
        if (string.isEmpty()) {
            return string;
        }
        return string.substring(0, 1).toUpperCase().concat(string.substring(1));
    }

    @GamlAnnotations.operator(value={"compress", "zip"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns a string that represents the compressed form (using gzip) of the argument", see={"uncompress"})
    public static String zip(IScope iScope, String string) {
        if (string == null) {
            throw GamaRuntimeException.error("String cannot be null", iScope);
        }
        if (string.isEmpty()) {
            return string;
        }
        return new String(ByteArrayZipper.zip(string.getBytes()), StandardCharsets.ISO_8859_1);
    }

    @GamlAnnotations.operator(value={"uncompress", "decompress", "unzip"}, can_be_const=true, category={"Strings-related operators"}, concept={"string"})
    @GamlAnnotations.doc(value="Returns a string that represents the uncompressed form (using gzip) of the argument", see={"compress"})
    public static String unzip(IScope iScope, String string) {
        if (string == null) {
            throw GamaRuntimeException.error("String cannot be null", iScope);
        }
        if (string.isEmpty()) {
            return string;
        }
        return new String(ByteArrayZipper.unzip(string.getBytes(StandardCharsets.ISO_8859_1)), StandardCharsets.ISO_8859_1);
    }
}

