/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.IContainer;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.StatementDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.statements.AbstractContainerStatement;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="to", type={16, 14, 11, 13}, optional=false, doc={@GamlAnnotations.doc(value="the left member of the addition assignment ('cont << expr;') is an expression cont that evaluates to a container (list, map, matrix, graph) ")}), @GamlAnnotations.facet(name="item", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the right member of the addition assignment ('cont << expr;') is an expression expr that evaluates to the element(s) to be added to the container")}), @GamlAnnotations.facet(name="at", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the index at which to add the item can be specified using 'container[index]' and the symbol '+<-' must prefix the item (instead of '<<', which would be ambiguous if the container contains other containers)'")}), @GamlAnnotations.facet(name="all", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the symbol '<<+' allows to pass a container as item so as to add all its elements to the receiving container")})}, omissible="item")
@GamlAnnotations.doc(value="A statement used to add items to containers. It can be written using the classic syntax (`add ... to: ...`) or a compact one, which is now preferred.\n- To add an element to a container (other than a matrix), use `container << element;` or `container <+ element;` (classic form: `add element to: container;`) \n- To add all the elements contained in another container, use `container <<+ elements;` (classic form: `add all: elements to: container;`)\n- To add an element to a container at a certain index, use `container[index] +<- element;` (classic form: `add element at: index to: container;`)", usages={@GamlAnnotations.usage(value="The new element can be added either at the end of the container or at a particular position.", examples={@GamlAnnotations.example(value="expr_container << expr;    // Add expr at the end", isExecutable=false), @GamlAnnotations.example(value="expr_container[index] +<- expr;   // Add expr at position index", isExecutable=false)}), @GamlAnnotations.usage(value="For lists, the index can only be integers", examples={@GamlAnnotations.example(value="list<int> workingList <- [];"), @GamlAnnotations.example(value="workingList[0] +<- 0;", var="workingList", equals="[0]", returnType="null"), @GamlAnnotations.example(value="workingList[0] +<- 10;", var="workingList", equals="[10,0]", returnType="null"), @GamlAnnotations.example(value="workingList[2] +<- 20;", var="workingList", equals="[10,0,20]", returnType="null"), @GamlAnnotations.example(value="workingList <+ 50; // or workingList << 50;", var="workingList", equals="[10,0,20,50]", returnType="null"), @GamlAnnotations.example(value="workingList <<+ [60,70]; // Add all the values in the list", var="workingList", equals="[10,0,20,50,60,70]", returnType="null")}), @GamlAnnotations.usage(value="This statement can not be used on matrix. Please refer to the statement put."), @GamlAnnotations.usage(value="Case of a map: As a map is basically a list of pairs key::value, we can also use the add statement on it. It is important to note that the behavior of the statement is slightly different, in particular in the use of the at facet, which denotes the key of the pair.", examples={@GamlAnnotations.example(value="map<string,string> workingMap <- [];"), @GamlAnnotations.example(value="workingMap['x'] +<- 'val1'; //equivalent to workingMap['x'] <- 'val1'", var="workingMap", equals="[\"x\"::\"val1\"]", returnType="null")}), @GamlAnnotations.usage(value="If no index is provided, a pair (expr_item::expr_item) will be added to the map. An important exception is the case where the expr_item is a pair itself: in this case, the pair is added.", examples={@GamlAnnotations.example(value=" workingMap << 'val2';", var="workingMap", equals="[\"x\"::\"val1\", \"val2\"::\"val2\"]", returnType="null"), @GamlAnnotations.example(value="workingMap << \"5\"::\"val4\"; ", var="workingMap", equals="[\"x\"::\"val1\", \"val2\"::\"val2\", \"5\"::\"val4\"]", returnType="null")}), @GamlAnnotations.usage(value="Notice that, as the key should be unique, the addition of an item at an existing position (i.e. existing key) will only modify the value associated with the given key.", examples={@GamlAnnotations.example(value="workingMap['x'] +<- \"val3\";", var="workingMap", equals="[\"x\"::\"val3\", \"val2\"::\"val2\", \"5\"::\"val4\"]", returnType="null")}), @GamlAnnotations.usage(value="On a map, the all facet will add all the values of a container  in the map: if the argument is a map itself, all its pairs will be added, otherwise a set of pairs <cont_value, cont_value> will be added", examples={@GamlAnnotations.example(value="workingMap <<+ [\"val4\",\"val5\"];", var="workingMap", equals="[\"x\"::\"val3\", \"val2\"::\"val2\", \"5\"::\"val4\",\"val4\"::\"val4\",\"val5\"::\"val5\"]", returnType="null")}), @GamlAnnotations.usage(value="In case of a graph, it is advised to use the various edge(), node(), edges(), nodes() operators, which can build the correct objects to add to the graph ", examples={@GamlAnnotations.example(value="graph g <- as_edge_graph([{1,5}::{12,45}]);"), @GamlAnnotations.example(value="g << edge({1,5}::{2,3});"), @GamlAnnotations.example(value="g.vertices", returnType="list", equals="[{1,5},{12,45},{2,3}]"), @GamlAnnotations.example(value="g.edges", returnType="list", equals="[polyline({1.0,5.0}::{12.0,45.0}),polyline({1.0,5.0}::{2.0,3.0})]"), @GamlAnnotations.example(value="g << node({5,5});"), @GamlAnnotations.example(value="g.vertices", returnType="list", equals="[{1.0,5.0},{12.0,45.0},{2.0,3.0},{5.0,5.0}]"), @GamlAnnotations.example(value="g.edges", returnType="list", equals="[polyline({1.0,5.0}::{12.0,45.0}),polyline({1.0,5.0}::{2.0,3.0})]")})}, see={"put", "remove"})
@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@validator(value=AddValidator.class)
@serializer(value=AddSerializer.class)
public class AddStatement
extends AbstractContainerStatement {
    public AddStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("add to " + this.list.serializeToGaml(false));
    }

    @Override
    protected void apply(IScope iScope, Object object, Object object2, IContainer.Modifiable modifiable) throws GamaRuntimeException {
        if (!this.asAll) {
            if (object2 == null) {
                modifiable.addValue(iScope, object);
            } else {
                modifiable.addValueAtIndex(iScope, object2, object);
            }
        } else if (object instanceof IContainer) {
            modifiable.addValues(iScope, object2, (IContainer)object);
        }
    }

    public static class AddSerializer
    extends SymbolSerializer<StatementDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            IExpression iExpression = symbolDescription.getFacetExpr("item");
            IExpression iExpression2 = symbolDescription.getFacetExpr("to");
            IExpression iExpression3 = symbolDescription.getFacetExpr("all");
            IExpression iExpression4 = symbolDescription.getFacetExpr("at");
            boolean bl2 = iExpression3 != null && iExpression3.isConst() && "true".equals(iExpression3.literalValue());
            stringBuilder.append(iExpression2.serializeToGaml(false));
            if (iExpression4 != null) {
                stringBuilder.append('[').append(iExpression4.serializeToGaml(bl)).append(']');
            }
            stringBuilder.append(bl2 ? " <<+ " : " <+ ");
            stringBuilder.append(iExpression.serializeToGaml(bl)).append(';');
        }
    }

    public static class AddValidator
    extends AbstractContainerStatement.ContainerValidator {
        @Override
        public void validateIndexAndContentTypes(String string, IDescription iDescription, boolean bl) {
            IExpression iExpression = iDescription.getFacetExpr("item");
            IExpression iExpression2 = iDescription.getFacetExpr("to");
            IExpression iExpression3 = iDescription.getFacetExpr("all");
            if (iExpression == null) {
                return;
            }
            if (iExpression3 != null && iExpression3.isConst() && "true".equals(iExpression3.literalValue()) && !iExpression.getGamlType().isContainer()) {
                iDescription.warning("The use of 'all' will have no effect here, as " + iExpression.serializeToGaml(false) + " is not a container. Only this value will be added to " + iExpression2.serializeToGaml(false), "gaml.wrong.context.issue", "all", new String[0]);
                iDescription.removeFacets("all");
            }
            if (iExpression2.getGamlType().id() == 10 && iExpression.getGamlType().id() == 9) {
                IType<?> iType = iExpression2.getGamlType().getContentType();
                IType<?> iType2 = iExpression.getGamlType().getContentType();
                IType<?> iType3 = iExpression2.getGamlType().getKeyType();
                IType<?> iType4 = iExpression.getGamlType().getKeyType();
                if (iType != Types.NO_TYPE && !iType2.isTranslatableInto(iType)) {
                    iDescription.warning("The type of the contents of " + iExpression2.serializeToGaml(false) + " (" + String.valueOf(iType) + ") does not match with the type of the value of " + iExpression.serializeToGaml(false), "gaml.casting.issue", "item", iType.toString());
                }
                if (iType3 != Types.NO_TYPE && !iType3.isTranslatableInto(iType4)) {
                    iDescription.warning("The type of the index of " + iExpression2.serializeToGaml(false) + " (" + String.valueOf(iType3) + ") does not match with that of the key of " + iExpression.serializeToGaml(false) + " (" + String.valueOf(iType4) + ")", "gaml.casting.issue", "item", iType3.toString());
                }
            } else {
                super.validateIndexAndContentTypes(string, iDescription, bl);
            }
        }
    }
}

