/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.common.util.StringUtils;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.serializer;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.ModelDescription;
import gama.gaml.descriptions.SymbolDescription;
import gama.gaml.descriptions.SymbolSerializer;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.IVarExpression;
import gama.gaml.statements.AbstractStatement;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the name of an existing variable or attribute to be modified")}), @GamlAnnotations.facet(name="value", type={0}, optional=false, doc={@GamlAnnotations.doc(value="the value to affect to the variable or attribute")})}, omissible="name")
@GamlAnnotations.inside(kinds={3, 11, 6}, symbols={"chart"})
@validator(value=AssignmentValidator.class)
@GamlAnnotations.doc(value="Allows to assign a value to the variable or attribute specified")
@serializer(value=AssignmentSerializer.class)
public class SetStatement
extends AbstractStatement {
    protected final IVarExpression varExpr = (IVarExpression)this.getFacet("name");
    protected final IExpression value;

    public SetStatement(IDescription iDescription) {
        super(iDescription);
        this.setName("set" + this.getVarName());
        IExpression iExpression = this.getFacet("value");
        this.value = iExpression == null ? GAML.getExpressionFactory().createConst(this.varExpr.getGamlType().getDefault(), this.varExpr.getGamlType()) : iExpression;
    }

    @Override
    protected Object privateExecuteIn(IScope iScope) throws GamaRuntimeException {
        Object object = this.value.value(iScope);
        this.varExpr.setVal(iScope, object, false);
        return object;
    }

    public String getVarName() {
        if (this.varExpr != null) {
            return this.varExpr.literalValue();
        }
        return null;
    }

    public static class AssignmentSerializer
    extends SymbolSerializer<SymbolDescription> {
        @Override
        protected void serialize(SymbolDescription symbolDescription, StringBuilder stringBuilder, boolean bl) {
            if (symbolDescription == null) {
                return;
            }
            IExpressionDescription iExpressionDescription = symbolDescription.getFacet("value");
            if (iExpressionDescription == null) {
                return;
            }
            String string = iExpressionDescription.serializeToGaml(bl);
            if (string == null) {
                return;
            }
            stringBuilder.append(symbolDescription.getName());
            stringBuilder.append(" <- ");
            stringBuilder.append(string);
            stringBuilder.append(";");
        }
    }

    public static class AssignmentValidator
    implements IDescriptionValidator<IDescription> {
        @Override
        public void validate(IDescription iDescription) {
            IExpressionDescription iExpressionDescription = iDescription.getFacet("name");
            IExpression iExpression = iExpressionDescription.getExpression();
            if (!(iExpression instanceof IVarExpression)) {
                iDescription.error("The expression " + iDescription.getLitteral("name") + " is not a reference to a variable ", "name");
                return;
            }
            IVarExpression iVarExpression = (IVarExpression)iExpression;
            IExpressionDescription iExpressionDescription2 = iDescription.getFacet("value");
            if (iExpressionDescription2 != null) {
                IDescriptionValidator.Assert.typesAreCompatibleForAssignment("value", iDescription, StringUtils.toGaml(iExpression, false), iExpression.getGamlType(), iExpressionDescription2);
            }
            if (iVarExpression.getVar().isNotModifiable()) {
                iDescription.error("The variable " + iExpression.serializeToGaml(false) + " is a constant or a function and cannot be assigned a value.", "name");
            }
            if ("shape".equals(iVarExpression.getName()) && iDescription.getSpeciesContext() instanceof ModelDescription) {
                iDescription.warning("Dynamically changing the shape of the world can lead to unexpected results. It is advised to redefine the attribute instead (e.g. 'geometry shape <- " + (iExpressionDescription2 == null ? "..." : iExpressionDescription2.serializeToGaml(false)) + "')", "name");
            }
        }
    }
}

