/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.types;

import gama.annotations.precompiler.GamlAnnotations;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaDate;
import gama.core.util.IContainer;
import gama.core.util.IMap;
import gama.gaml.operators.Cast;
import gama.gaml.types.GamaType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.time.Clock;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;

@GamlAnnotations.type(name="date", id=23, wraps={GamaDate.class}, kind=101, concept={"type", "date", "time"}, doc={@GamlAnnotations.doc(value="GAML objects that represent a date")})
public class GamaDateType
extends GamaType<GamaDate> {
    public static final ZoneId DEFAULT_ZONE = Clock.systemDefaultZone().getZone();
    public static final ZoneOffset DEFAULT_OFFSET_IN_SECONDS = Clock.systemDefaultZone().getZone().getRules().getOffset(Instant.now(Clock.systemDefaultZone()));
    public static final GamaDate EPOCH = GamaDate.of(LocalDateTime.ofEpochSecond(0L, 0, DEFAULT_OFFSET_IN_SECONDS));

    @Override
    @GamlAnnotations.doc(value="Cast the argument into a date. If the argument is a date already, returns it, otherwise: if it is a container, casts its contents to integer numbers and tries to build a date from it (following the order 'year, month, day, hour, minute, second'); if it is a string, tries to decode it into a date using the format described in the preferences; otherwise cast the argument into a float number and interprets it as the number of milliseconds since the start of the simulation")
    public GamaDate cast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        return GamaDateType.staticCast(iScope, object, object2, bl);
    }

    public static GamaDate staticCast(IScope iScope, Object object, Object object2, boolean bl) throws GamaRuntimeException {
        if (object == null) {
            return null;
        }
        if (object instanceof GamaDate) {
            if (bl) {
                return new GamaDate(iScope, (GamaDate)object);
            }
            return (GamaDate)object;
        }
        if (object instanceof IContainer) {
            return new GamaDate(iScope, ((IContainer)object).listValue(iScope, Types.INT, false));
        }
        if (object instanceof String) {
            return new GamaDate(iScope, (String)object);
        }
        Double d = Cast.asFloat(iScope, object);
        return new GamaDate(iScope, d);
    }

    @Override
    public GamaDate getDefault() {
        return null;
    }

    @Override
    public IType<?> getContentType() {
        return Types.get(2);
    }

    @Override
    public boolean canCastToConst() {
        return false;
    }

    @Override
    public boolean isCompoundType() {
        return true;
    }

    @Override
    public GamaDate deserializeFromJson(IScope iScope, IMap<String, Object> iMap) {
        return GamaDate.fromISOString(Cast.asString(iScope, iMap.get("iso")));
    }
}

