/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common;

import gama.core.common.CompletionStatusMessage;
import gama.core.common.ErrorStatusMessage;
import gama.core.common.ExperimentStatusMessage;
import gama.core.common.IStatusMessage;
import gama.core.common.StatusMessage;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaColor;

public class StatusMessageFactory {
    private static IStatusMessage EXPERIMENT_UPDATE = new ExperimentStatusMessage();
    private static IStatusMessage IDLE = new IStatusMessage(){

        @Override
        public String message() {
            return "Idle";
        }
    };

    public static IStatusMessage INFORM(String string) {
        return new StatusMessage(string, IStatusMessage.StatusType.REGULAR, null, IStatusMessage.INFORM_COLOR, null, System.currentTimeMillis());
    }

    public static IStatusMessage ERROR(GamaRuntimeException gamaRuntimeException) {
        return new ErrorStatusMessage(gamaRuntimeException, System.currentTimeMillis());
    }

    public static IStatusMessage COMPLETION(String string, Double d) {
        return new CompletionStatusMessage(string, d, System.currentTimeMillis());
    }

    public static IStatusMessage CUSTOM(String string, IStatusMessage.StatusType statusType, String string2, GamaColor gamaColor) {
        return new StatusMessage(string, statusType, string2, gamaColor, null, System.currentTimeMillis());
    }

    public static IStatusMessage EXPERIMENT() {
        return EXPERIMENT_UPDATE;
    }

    public static IStatusMessage IDLE() {
        return IDLE;
    }
}

