/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.geometry;

import gama.core.common.geometry.GamaCoordinateSequence;
import gama.core.common.geometry.ICoordinates;
import gama.core.common.geometry.UniqueCoordinateSequence;
import gama.core.metamodel.shape.GamaPoint;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateSequenceFactory;

public class GamaCoordinateSequenceFactory
implements CoordinateSequenceFactory {
    public ICoordinates create(Coordinate[] coordinateArray) {
        if (coordinateArray.length == 1) {
            return new UniqueCoordinateSequence(3, coordinateArray[0]);
        }
        return new GamaCoordinateSequence(3, coordinateArray);
    }

    public ICoordinates create(GamaPoint[] gamaPointArray, boolean bl) {
        if (gamaPointArray.length == 1) {
            return new UniqueCoordinateSequence(3, gamaPointArray[0]);
        }
        return new GamaCoordinateSequence(3, bl, (Coordinate[])gamaPointArray);
    }

    public ICoordinates create(CoordinateSequence coordinateSequence) {
        if (coordinateSequence.size() == 1) {
            return new UniqueCoordinateSequence(coordinateSequence.getDimension(), coordinateSequence.getCoordinate(0));
        }
        if (coordinateSequence instanceof GamaCoordinateSequence) {
            GamaCoordinateSequence gamaCoordinateSequence = (GamaCoordinateSequence)coordinateSequence;
            return gamaCoordinateSequence.copy();
        }
        return new GamaCoordinateSequence(coordinateSequence.getDimension(), coordinateSequence.toCoordinateArray());
    }

    public ICoordinates create(int n, int n2) {
        if (n == 1) {
            return new UniqueCoordinateSequence(n2, new GamaPoint());
        }
        return new GamaCoordinateSequence(n2, n);
    }
}

