/*
 * Decompiled with CFR 0.152.
 */
package gama.core.common.preferences;

import gama.core.common.preferences.GamaPreferenceStore;
import gama.core.common.preferences.Pref;
import gama.core.common.util.FileUtils;
import gama.core.common.util.RandomUtils;
import gama.core.common.util.StringUtils;
import gama.core.outputs.layers.properties.ICameraDefinition;
import gama.core.runtime.PlatformHelper;
import gama.core.runtime.concurrent.BufferingController;
import gama.core.util.GamaColor;
import gama.core.util.GamaFont;
import gama.core.util.GamaMapFactory;
import gama.core.util.IMap;
import gama.core.util.file.GenericFile;
import gama.core.util.file.IGamaFile;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaMetaModel;
import gama.gaml.descriptions.PlatformSpeciesDescription;
import gama.gaml.operators.Strings;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.geotools.referencing.CRS;

public class GamaPreferences {
    public static final Pref.ValueProvider<GamaColor>[] BASIC_COLORS = new Pref.ValueProvider[]{() -> GamaColor.get(74, 97, 144), () -> GamaColor.get(66, 119, 42), () -> GamaColor.get(83, 95, 107), () -> GamaColor.get(195, 98, 43), () -> GamaColor.get(150, 132, 106)};
    public static final Pref.ValueProvider<GamaColor>[] QUALITATIVE_COLORS = new Pref.ValueProvider[]{() -> GamaColor.get(166, 206, 227), () -> GamaColor.get(31, 120, 180), () -> GamaColor.get(178, 223, 138), () -> GamaColor.get(51, 160, 44), () -> GamaColor.get(251, 154, 153), () -> GamaColor.get(227, 26, 28), () -> GamaColor.get(253, 191, 111), () -> GamaColor.get(255, 127, 0), () -> GamaColor.get(202, 178, 214)};
    public static final Pref.ValueProvider<GamaColor>[] DIVERGING_COLORS = new Pref.ValueProvider[]{() -> GamaColor.get(84, 48, 5), () -> GamaColor.get(140, 81, 10), () -> GamaColor.get(191, 129, 45), () -> GamaColor.get(223, 194, 125), () -> GamaColor.get(246, 232, 195), () -> GamaColor.get(245, 245, 245), () -> GamaColor.get(199, 234, 229), () -> GamaColor.get(128, 205, 193), () -> GamaColor.get(53, 151, 143), () -> GamaColor.get(1, 102, 94), () -> GamaColor.get(0, 60, 48)};
    public static final String PREF_SAVE_BUFFERING_STRATEGY = "pref_save_buffering_strategy";
    public static final String PREF_WRITE_BUFFERING_STRATEGY = "pref_write_buffering_strategy";
    private static Map<String, Pref<? extends Object>> prefs = new LinkedHashMap<String, Pref<? extends Object>>();
    static Interface inter = new Interface();
    static Theme theme = new Theme();
    static Modeling modeling = new Modeling();
    static Runtime runtime = new Runtime();
    static Displays displays = new Displays();
    static Network network = new Network();
    static External external = new External();
    static Experimental exp = new Experimental();
    public static final List<String> ORDER_OF_PREFERENCES = Arrays.asList("Interface", "Theme", "Editors", "Execution", "Displays", "Network", "Data and Operators", "Advanced");

    public static <T> Pref<T> get(String string, Class<T> clazz) {
        return prefs.get(string);
    }

    public static Pref<?> get(String string) {
        return prefs.get(string);
    }

    public static Map<String, Pref<?>> getAll() {
        return prefs;
    }

    public static <T> Pref<T> create(String string, String string2, T t, int n, boolean bl) {
        Pref pref = new Pref(string, n, bl).named(string2).in("Interface", "").init(t);
        GamaPreferences.register(pref);
        return pref;
    }

    public static <T> Pref<T> create(String string, String string2, Pref.ValueProvider<T> valueProvider, int n, boolean bl) {
        Pref pref = new Pref(string, n, bl).named(string2).in("Interface", "").init(valueProvider);
        GamaPreferences.register(pref);
        return pref;
    }

    private static void register(Pref<?> pref) {
        String string = pref.key;
        if (string == null) {
            return;
        }
        prefs.put(string, pref);
        GamaPreferenceStore.getStore().register(pref);
        PlatformSpeciesDescription platformSpeciesDescription = GamaMetaModel.getPlatformSpeciesDescription();
        if (platformSpeciesDescription != null && !platformSpeciesDescription.hasAttribute(string) && pref.inGaml()) {
            platformSpeciesDescription.addPref(string, pref);
        }
    }

    public static Map<String, Map<String, List<Pref<?>>>> organizePrefs() {
        IMap iMap = GamaMapFactory.create();
        for (String object : ORDER_OF_PREFERENCES) {
            iMap.put(object, GamaMapFactory.create());
        }
        for (Pref pref : prefs.values()) {
            String string;
            ArrayList<Pref> arrayList;
            if (pref.isHidden()) continue;
            String string2 = pref.tab;
            Map map = (Map)iMap.get(string2);
            if (map == null) {
                map = GamaMapFactory.create();
                iMap.put(string2, map);
            }
            if ((arrayList = (ArrayList<Pref>)map.get(string = pref.group)) == null) {
                arrayList = new ArrayList<Pref>();
                map.put(string, arrayList);
            }
            arrayList.add(pref);
        }
        return iMap;
    }

    public static void setNewPreferences(Map<String, Object> map) {
        for (String string : map.keySet()) {
            Pref<? extends Object> pref = prefs.get(string);
            if (pref == null) continue;
            pref.set(map.get(string));
            GamaPreferenceStore.getStore().write(pref);
        }
    }

    public static void revertToDefaultValues(Map<String, Object> map) {
        GamaPreferenceStore.getStore().clear();
    }

    public static void applyPreferencesFrom(String string, Map<String, Object> map) {
        GamaPreferenceStore.getStore().loadFromProperties(string);
        ArrayList<Pref<? extends Object>> arrayList = new ArrayList<Pref<? extends Object>>(prefs.values());
        for (Pref pref : arrayList) {
            GamaPreferences.register(pref);
            map.put(pref.key, pref.getValue());
        }
    }

    public static void savePreferencesToGAML(String string) {
        try {
            Throwable throwable = null;
            Object var2_4 = null;
            try (FileWriter fileWriter = new FileWriter(string);){
                List list = ((StreamEx)StreamEx.ofValues(prefs).sortedBy(Pref::getName)).toList();
                StringBuilder stringBuilder = new StringBuilder(1000);
                StringBuilder stringBuilder2 = new StringBuilder(1000);
                for (Pref pref : list) {
                    if (pref.isHidden() || !pref.inGaml()) continue;
                    stringBuilder.append("\t").append("//").append(pref.getTitle()).append(Strings.LN);
                    stringBuilder.append("\t").append("write sample(gama.").append(pref.getName()).append(");").append(Strings.LN).append(Strings.LN);
                    stringBuilder2.append("\t").append("//").append(pref.getTitle()).append(Strings.LN);
                    stringBuilder2.append("\t").append("gama.").append(pref.getName()).append(" <- ").append(StringUtils.toGaml(pref.getValue(), false)).append(";").append(Strings.LN).append(Strings.LN);
                }
                fileWriter.append("// ").append("GAMA 2025.5.2-SNAPSHOT").append(" Preferences saved on ").append(LocalDateTime.now().toString()).append(Strings.LN).append(Strings.LN);
                fileWriter.append("model preferences").append(Strings.LN).append(Strings.LN);
                fileWriter.append("experiment 'Display Preferences' type: gui {").append(Strings.LN);
                fileWriter.append("init {").append(Strings.LN);
                fileWriter.append(stringBuilder);
                fileWriter.append("}").append(Strings.LN);
                fileWriter.append("}").append(Strings.LN).append(Strings.LN).append(Strings.LN);
                fileWriter.append("experiment 'Set Preferences' type: gui {").append(Strings.LN);
                fileWriter.append("init {").append(Strings.LN);
                fileWriter.append(stringBuilder2);
                fileWriter.append("}").append(Strings.LN);
                fileWriter.append("}").append(Strings.LN);
                fileWriter.flush();
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static void savePreferencesToProperties(String string) {
        GamaPreferenceStore.getStore().saveToProperties(string);
    }

    public static class Displays {
        public static final String NAME = "Displays";
        public static final String PRESENTATION = "Presentation and Behavior of Graphical Display Views";
        public static final List<String> LAYOUTS = Arrays.asList("None", "Stacked", "Split", "Horizontal", "Vertical");
        public static final Pref<String> CORE_DISPLAY_LAYOUT = GamaPreferences.create("pref_display_view_layout", "Default layout of display views", "Split", 4, true).among((String[])LAYOUTS.toArray(new String[LAYOUTS.size()])).in("Displays", "Presentation and Behavior of Graphical Display Views");
        public static final Pref<Boolean> CORE_DISPLAY_BORDER = GamaPreferences.create("pref_display_show_border", "Display a border around display views", false, 3, true).in("Displays", "Presentation and Behavior of Graphical Display Views").hidden();
        public static final Pref<Boolean> CORE_DISPLAY_PERSPECTIVE = GamaPreferences.create("pref_display_continue_drawing", "Continue to draw displays when in Modeling perspective", false, 3, true).in("Displays", "Presentation and Behavior of Graphical Display Views");
        public static final Pref<Boolean> DISPLAY_FAST_SNAPSHOT = GamaPreferences.create("pref_display_fast_snapshot", "Enable fast snapshots (uncomplete when the display is obscured by others but much faster)", false, 3, true).in("Displays", "Presentation and Behavior of Graphical Display Views");
        public static final Pref<Boolean> CORE_DISPLAY_TOOLBAR = GamaPreferences.create("pref_display_show_toolbar", "Show the display top toolbar", true, 3, true).in("Displays", "Presentation and Behavior of Graphical Display Views").hidden();
        public static final Pref<Boolean> CORE_OVERLAY = GamaPreferences.create("pref_display_show_overlay", "Show the display bottom overlay", false, 3, true).in("Displays", "Presentation and Behavior of Graphical Display Views").hidden();
        public static final Pref<Boolean> CHART_MEMORIZE = GamaPreferences.create("pref_display_memorize_charts", "Keep chart values in memory (to save them as CSV) or not (to lower memory usage)", true, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Double> CHART_QUALITY = GamaPreferences.create("pref_chart_quality", "Graphical resolution of the charts (from 0, small and fast, to 1, best but consuming lots of resources)", 0.8, 2, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities").between(Double.valueOf(0.1), Double.valueOf(1.0));
        public static final String DRAWING = "Default Rendering Properties";
        public static final Pref<Boolean> CORE_DISPLAY = GamaPreferences.create("pref_display_default2", "Default rendering method", true, 3, true).withLabels("2D using Java", "3D using OpenGL").in("Displays", "Default Rendering Properties");
        public static final Pref<Boolean> CORE_ANTIALIAS = GamaPreferences.create("pref_display_antialias", "Apply antialiasing", false, 3, true).in("Displays", "Default Rendering Properties");
        public static final Pref<GamaColor> CORE_BACKGROUND = GamaPreferences.create("pref_display_background_color", "Default background color ('background' facet of 'display')", () -> GamaColor.get("white"), 6, true).in("Displays", "Default Rendering Properties");
        public static final Pref<GamaColor> CORE_HIGHLIGHT = GamaPreferences.create("pref_display_highlight_color", "Default highlight color", () -> GamaColor.get(0, 200, 200), 6, true).in("Displays", "Default Rendering Properties");
        public static final Pref<String> CORE_SHAPE = GamaPreferences.create("pref_display_default_shape", "Defaut shape of agents", "shape", 4, true).among((String[])new String[]{"shape", "circle", "square", "triangle", "point", "cube", "sphere"}).in("Displays", "Default Rendering Properties");
        public static final Pref<Double> CORE_SIZE = GamaPreferences.create("pref_display_default_size", "Default size of agents", 1.0, 2, true).between(Double.valueOf(0.01), null).in("Displays", "Default Rendering Properties");
        public static final Pref<GamaColor> CORE_COLOR = GamaPreferences.create("pref_display_default_color", "Default color of agents", () -> GamaColor.get("yellow"), 6, true).in("Displays", "Default Rendering Properties");
        public static final Pref<Boolean> DISPLAY_NO_ACCELERATION = GamaPreferences.create("pref_display_no_java2d_acceleration", "Disable acceleration for Java2D (necessary on some configurations)", false, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final String RENDERING = "OpenGL Rendering Properties";
        public static final Pref<Boolean> DISPLAY_ONLY_VISIBLE = GamaPreferences.create("pref_display_visible_agents", "Only display visible agents in OpenGL (faster, may create visual oddities)", false, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Boolean> CORE_DRAW_ENV = GamaPreferences.create("pref_display_show_referential", "Draw 3D axes", true, 3, true).in("Displays", "OpenGL Rendering Properties").hidden();
        public static final Pref<Boolean> DRAW_ROTATE_HELPER = GamaPreferences.create("pref_display_show_rotation", "Draw rotation axes", true, 3, true).in("Displays", "OpenGL Rendering Properties").hidden();
        public static final Pref<Double> CORE_LINE_WIDTH = GamaPreferences.create("pref_display_line_width", "Default line width (facet 'width' of 'draw'). Note that this attribute is not supported by all OpenGL implementations", 1.0, 2, true).in("Displays", "OpenGL Rendering Properties");
        public static final Pref<Boolean> ONLY_VISIBLE_FACES = GamaPreferences.create("pref_display_visible_faces", "Draw only the 'external' faces of objects in OpenGL", false, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Integer> DISPLAY_SLICE_NUMBER = GamaPreferences.create("pref_display_slice_number", "Number of slices of circular geometries in OpenGL (the higher the more resources consuming)", 16, 1, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Boolean> OPENGL_Z_FIGHTING = GamaPreferences.create("pref_opengl_z_fighting", "In OpenGL, add a small increment to the z ordinate of objects and layers to fight visual artefacts", true, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities").activates("pref_opengl_z_factor");
        public static final Pref<Double> OPENGL_Z_FACTOR = GamaPreferences.create("pref_opengl_z_factor", "Increment factor (from 0, none, to 1, max)", 0.05, 2, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities").between(Double.valueOf(0.0), Double.valueOf(1.0)).step(Double.valueOf(0.001));
        public static final Pref<Boolean> OPENGL_TEXTURE_ORIENTATION = GamaPreferences.create("pref_texture_orientation", "In OpenGL, orient the textures according to the geometry on which they are displayed (may create visual oddities)", true, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Double> OPENGL_ZOOM = GamaPreferences.create("pref_display_zoom_factor", "Set the zoom factor (0 for slow, 1 fast)", 0.5, 2, true).in("Displays", "OpenGL Rendering Properties").between(Integer.valueOf(0), Integer.valueOf(1)).step(Double.valueOf(0.01));
        public static final Pref<Double> OPENGL_KEYBOARD = GamaPreferences.create("pref_display_keyboard_factor", "Set the sensitivity of the keyboard movements  (0 for slow, 1 for fast)", 0.5, 2, true).in("Displays", "OpenGL Rendering Properties").between(Double.valueOf(0.01), Double.valueOf(1.0)).step(Double.valueOf(0.01));
        public static final Pref<Double> OPENGL_MOUSE = GamaPreferences.create("pref_display_mouse_factor", "Set the sensitivity of the mouse/trackpad movements  (0 for slow, 1 fast)", 0.5, 2, true).in("Displays", "OpenGL Rendering Properties").between(Double.valueOf(0.01), Double.valueOf(1.0)).step(Double.valueOf(0.01));
        public static final Pref<Boolean> OPENGL_CAP_FPS = GamaPreferences.create("pref_display_cap_fps", "Limit the number of frames per second if you experience stuttering in the rendering", false, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities").activates("pref_display_max_fps");
        public static final Pref<Integer> OPENGL_FPS = GamaPreferences.create("pref_display_max_fps", "Max. number of frames per second", 60, 1, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Boolean> OPENGL_NUM_KEYS_CAM = GamaPreferences.create("pref_display_numkeyscam", "Use Numeric Keypad (2,4,6,8) for camera interaction", true, 3, true).in("Displays", "OpenGL Rendering Properties");
        public static final Pref<String> OPENGL_DEFAULT_CAM = GamaPreferences.create("pref_display_camera", "Default camera to use when none is specified", "From above", 4, true).among((String[])ICameraDefinition.PRESETS).in("Displays", "OpenGL Rendering Properties");
        public static final Pref<Boolean> OPENGL_USE_IMAGE_CACHE = GamaPreferences.create("pref_display_use_cache", "Use GAMA image cache when building textures in OpenGL (potentially faster when running several simulations, but uses more memory)", true, 3, true).in("Advanced", "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities");
        public static final Pref<Integer> OPENGL_DEFAULT_LIGHT_INTENSITY = GamaPreferences.create("pref_display_light_intensity", "Set the default intensity of the lights (from 0, dark, to 255, light)", 160, 1, true).in("Displays", "OpenGL Rendering Properties").between(Integer.valueOf(0), Integer.valueOf(255));
    }

    public static class Experimental {
        public static final String NAME = "Advanced";
        public static final String CATEGORY = " These features have not been fully tested. Enable them at your own risks.";
        public static final String OPTIMIZATIONS = "These optimizations are considered safe";
        public static final String GRAPHICAL = "Various graphics optimizations to speed up displays and/or reduce memory usage. Some can produce visual oddities";
        public static final Pref<Boolean> REQUIRED_PLUGINS = GamaPreferences.create("pref_required_plugins", "Automatically add the plugins required to compile and run a model when editing it", false, 3, false).in("Advanced", " These features have not been fully tested. Enable them at your own risks.").hidden();
        public static final Pref<Boolean> QUADTREE_OPTIMIZATION = GamaPreferences.create("pref_optimize_quadtree", "Optimize spatial queries: add agents only when necessary in the quadtree (still experimental)", false, 3, true).in("Advanced", " These features have not been fully tested. Enable them at your own risks.");
        public static final Pref<Boolean> QUADTREE_SYNCHRONIZATION = GamaPreferences.create("pref_synchronize_quadtree", "Forces the spatial index to synchronize its operations. Useful for interactive models where the users interfere or parallel models with concurrency errors. Note that it may slow down simulations with a lot of mobile agents", true, 3, true).in("Advanced", " These features have not been fully tested. Enable them at your own risks.");
        public static final Pref<Boolean> CONSTANT_OPTIMIZATION = GamaPreferences.create("pref_optimize_constant_expressions", "Optimize constant expressions (experimental, performs a rebuild of models)", false, 3, true).in("Advanced", " These features have not been fully tested. Enable them at your own risks.").onChange(bl -> {
            try {
                ResourcesPlugin.getWorkspace().build(15, null);
            }
            catch (CoreException coreException) {}
        }).hidden();
        public static final Pref<Boolean> AT_DISTANCE_OPTIMIZATION = GamaPreferences.create("pref_optimize_at_distance", "Optimize the 'at_distance' operator", true, 3, true).in("Advanced", "These optimizations are considered safe");
        public static final Pref<Boolean> PATH_COMPUTATION_OPTIMIZATION = GamaPreferences.create("pref_optimize_path_computation", "Optimize the path computation operators and goto action (but with possible 'jump' issues)", false, 3, true).in("Advanced", "These optimizations are considered safe");
        public static final Pref<Double> TOLERANCE_POINTS = GamaPreferences.create("pref_point_tolerance", "Tolerance for the comparison of points", 0.0, 2, true).in("Advanced", "These optimizations are considered safe");
        public static final Pref<Boolean> SHAPEFILES_IN_MEMORY = GamaPreferences.create("pref_shapefiles_in_memory", "Mapping and caching of shapefiles in memory (optimises access to shapefile data in exchange for increased memory usage). Disable this property if you are dealing with shapefiles that change frequently", true, 3, true).in("Advanced", "These optimizations are considered safe");
        public static final Pref<String> DEFAULT_SAVE_BUFFERING_STRATEGY = GamaPreferences.create("pref_save_buffering_strategy", "Default buffering strategy for the save statement", "no_buffering", 4, true).among(BufferingController.BUFFERING_STRATEGIES.stream().toList()).in("Advanced", "These optimizations are considered safe");
        public static final Pref<String> DEFAULT_WRITE_BUFFERING_STRATEGY = GamaPreferences.create("pref_write_buffering_strategy", "Default buffering strategy for the write statement", "no_buffering", 4, true).among(BufferingController.BUFFERING_STRATEGIES.stream().toList()).in("Advanced", "These optimizations are considered safe");
        public static final Pref<Boolean> USE_POOLING = GamaPreferences.create("pref_use_pooling", "Use object pooling to reduce memory usage (still experimental)", false, 3, true).in("Advanced", " These features have not been fully tested. Enable them at your own risks.").hidden();
    }

    public static class External {
        public static final String NAME = "Data and Operators";
        public static final Pref<Integer> CORE_HTTP_CONNECT_TIMEOUT = GamaPreferences.create("pref_http_connect_timeout", "Connection timeout (in ms)", 20000, 1, true).in("Network", "Http connections");
        public static final Pref<Integer> CORE_HTTP_READ_TIMEOUT = GamaPreferences.create("pref_http_read_timeout", "Read timeout (in ms)", 20000, 1, true).in("Network", "Http connections");
        public static final Pref<Integer> CORE_HTTP_RETRY_NUMBER = GamaPreferences.create("pref_http_retry_number", "Number of times to retry if connection cannot be established", 3, 1, true).in("Network", "Http connections");
        public static final Pref<Boolean> CORE_HTTP_EMPTY_CACHE = GamaPreferences.create("pref_http_empty_cache", "Empty the local cache of files downloaded from the web", true, 3, true).in("Network", "Http connections");
        public static final String RNG = "Random number generation";
        public static final Pref<String> CORE_RNG = GamaPreferences.create("pref_rng_name", "Default random number generator", "mersenne", 4, true).among(RandomUtils.Generators.names()).in("Data and Operators", "Random number generation");
        public static final Pref<Boolean> CORE_SEED_DEFINED = GamaPreferences.create("pref_rng_define_seed", "Define a default seed", false, 3, true).activates("pref_rng_default_seed").in("Data and Operators", "Random number generation");
        public static final Pref<Double> CORE_SEED = GamaPreferences.create("pref_rng_default_seed", "Default seed value (0 is undefined)", 1.0, 2, true).in("Data and Operators", "Random number generation");
        public static final String DATES = "Management of dates";
        public static final String GEOTOOLS = "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)";
        public static final Pref<Boolean> LIB_TARGETED = GamaPreferences.create("pref_gis_auto_crs", "Let GAMA find which CRS to use to project GIS data", true, 3, true).in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)");
        public static final Pref<Boolean> LIB_PROJECTED = GamaPreferences.create("pref_gis_same_crs", "When no .prj file or CRS is supplied, consider GIS data to be already projected in this CRS", true, 3, true).deactivates("pref_gis_initial_crs").in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)");
        public static final Pref<Boolean> LIB_USE_DEFAULT = GamaPreferences.create("pref_gis_save_crs", "When no CRS is provided, save the GIS data with the current CRS", true, 3, true).deactivates("pref_gis_output_crs").in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)");
        public static final Pref<Integer> LIB_TARGET_CRS = GamaPreferences.create("pref_gis_default_crs", "...or use the following EPSG code (the one that will also be used if no projection information is found)", 32648, 1, true).in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)").addChangeListener(n -> {
            Set set = CRS.getSupportedCodes((String)n.toString());
            return !set.isEmpty();
        });
        public static final Pref<Integer> LIB_INITIAL_CRS = GamaPreferences.create("pref_gis_initial_crs", "...or use the following CRS (EPSG code)", 4326, 1, true).in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)").addChangeListener(n -> {
            Set set = CRS.getSupportedCodes((String)n.toString());
            return !set.isEmpty();
        });
        public static final Pref<Integer> LIB_OUTPUT_CRS = GamaPreferences.create("pref_gis_output_crs", "... or use this following CRS (EPSG code)", 4326, 1, true).in("Data and Operators", "GIS Coordinate Reference Systems (http://spatialreference.org/ref/epsg/ for EPSG codes)").addChangeListener(n -> {
            Set set = CRS.getSupportedCodes((String)n.toString());
            return !set.isEmpty();
        });
        public static final Pref<String> CSV_STRING_QUALIFIER = GamaPreferences.create("pref_csv_string_qualifier", "Default separator for strings", String.valueOf('\"'), 4, true).in("Data and Operators", "CSV Files");
        public static final Pref<String> CSV_SEPARATOR = GamaPreferences.create("pref_csv_separator", "Default separator for fields", String.valueOf(','), 4, true).in("Data and Operators", "CSV Files");
    }

    public static class Interface {
        public static final String NAME = "Interface";
        public static final String STARTUP = "Startup";
        public static final Pref<Boolean> CORE_REMEMBER_WINDOW = GamaPreferences.create("pref_remember_window", "Remember GAMA window size and position", true, 3, false).in("Interface", "Startup").deactivates("pref_show_maximized").withLabels("Yes", "No");
        public static final Pref<Boolean> CORE_ASK_REBUILD = GamaPreferences.create("pref_ask_rebuild", "Ask before rebuilding a corrupted workspace", true, 3, false).in("Interface", "Startup").withLabels("Yes", "No");
        public static final Pref<Boolean> CORE_ASK_OUTDATED = GamaPreferences.create("pref_ask_outdated", "Ask before using a workspace created by another version", true, 3, false).in("Interface", "Startup").withLabels("Yes", "No");
        public static final Pref<Boolean> CORE_STARTUP_MODEL = GamaPreferences.create("pref_startup_model", "Open a model", false, 3, false).in("Interface", "Startup").activates("pref_default_model", "pref_default_experiment").withLabels("Yes", "No");
        public static final Pref<? extends IGamaFile> CORE_DEFAULT_MODEL = GamaPreferences.create("pref_default_model", "Model to open", () -> new GenericFile("Enter path", false), 12, false).in("Interface", "Startup").restrictToWorkspace().withExtensions("gaml", "experiment").refreshes("pref_default_experiment").activates("pref_default_experiment");
        public static final Pref<String> CORE_DEFAULT_EXPERIMENT = GamaPreferences.create("pref_default_experiment", "Experiment to run", "", 4, false).in("Interface", "Startup").among(() -> {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (CORE_STARTUP_MODEL.getValue().booleanValue()) {
                IGamaFile iGamaFile = CORE_DEFAULT_MODEL.getValue();
                URI uRI = FileUtils.getURI(iGamaFile.getOriginalPath(), null);
                if (uRI == null) {
                    return arrayList;
                }
                arrayList.addAll(GAML.getInfo(uRI).getExperiments());
            }
            return arrayList;
        });
        public static final String MENUS = "Menus";
        public static final Pref<Integer> CORE_MENU_SIZE = GamaPreferences.create("pref_menu_size", "Break down agents in menus every", 50, 1, false).between(Integer.valueOf(10), Integer.valueOf(1000)).in("Interface", "Menus");
        public static final String CONSOLE = "Console";
        public static final Pref<Integer> CORE_CONSOLE_SIZE = GamaPreferences.create("pref_console_size", "Max. number of characters to display (-1 = unlimited)", 20000, 1, true).in("Interface", "Console");
        public static final Pref<Integer> CORE_CONSOLE_BUFFER = GamaPreferences.create("pref_console_buffer", "Max. number of characters to keep when paused (-1 = unlimited)", 20000, 1, true).in("Interface", "Console");
        public static final Pref<Boolean> CORE_CONSOLE_WRAP = GamaPreferences.create("pref_console_wrap", "Wrap long lines (can slow down output)", false, 3, true).in("Interface", "Console").withLabels("Yes", "No");
        public static final String APPEARANCE = "Appearance";
        public static final String NAVIGATOR = "Navigator";
        public static final String SIMULATIONS = "Simulations";
        public static final Pref<Boolean> CORE_SIMULATION_NAME = GamaPreferences.create("pref_append_simulation_name", "Append the name of simulations to their outputs", false, 3, true).in("Interface", "Simulations");
        private static GamaColor[] SIMULATION_COLORS = null;
        static final String DIVERGING = "Diverging (11 colors)";
        static final String BASIC = "Basic (5 colors)";
        static final String QUALITATIVE = "Qualitative (9 colors)";
        static final String PIVOT = "Based on pivot color (9 colors)";
        public static final Pref<String> CORE_SIMULATION_COLOR = GamaPreferences.create("pref_simulation_colors", "Default color scheme for simulations in UI", "Diverging (11 colors)", 4, true).among((String[])new String[]{"Basic (5 colors)", "Diverging (11 colors)", "Qualitative (9 colors)", "Based on pivot color (9 colors)"}).in("Interface", "Simulations").onChange(Interface::setColorScheme);
        public static final Pref<GamaColor> CORE_PIVOT_COLOR = GamaPreferences.create("pref_simulation_color", "Pivot color of simulations", GamaColor.get(64, 224, 208), 6, true).in("Interface", "Simulations").onChange(Interface::setPivot);

        static void setPivot(GamaColor gamaColor) {
            if (!PIVOT.equals(CORE_SIMULATION_COLOR.getValue())) {
                return;
            }
            SIMULATION_COLORS = new GamaColor[9];
            Interface.SIMULATION_COLORS[0] = GamaColor.get(gamaColor.darker().darker().darker().darker());
            Interface.SIMULATION_COLORS[1] = GamaColor.get(gamaColor.darker().darker().darker());
            Interface.SIMULATION_COLORS[2] = GamaColor.get(gamaColor.darker().darker());
            Interface.SIMULATION_COLORS[3] = GamaColor.get(gamaColor.darker());
            Interface.SIMULATION_COLORS[4] = GamaColor.get(gamaColor);
            Interface.SIMULATION_COLORS[5] = GamaColor.get(gamaColor.brighter());
            Interface.SIMULATION_COLORS[6] = GamaColor.get(gamaColor.brighter().brighter());
            Interface.SIMULATION_COLORS[7] = GamaColor.get(gamaColor.brighter().brighter().brighter());
            Interface.SIMULATION_COLORS[8] = GamaColor.get(gamaColor.brighter().brighter().brighter().brighter());
        }

        public static GamaColor getColorForSimulation(int n) {
            if (SIMULATION_COLORS == null) {
                Interface.setColorScheme(CORE_SIMULATION_COLOR.getValue());
            }
            return SIMULATION_COLORS[n % SIMULATION_COLORS.length];
        }

        public static void setColorScheme(String string) {
            String string2 = string;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DIVERGING, BASIC, QUALITATIVE}, (Object)string2, n)) {
                case 0: {
                    SIMULATION_COLORS = new GamaColor[DIVERGING_COLORS.length];
                    int n2 = 0;
                    while (n2 < DIVERGING_COLORS.length) {
                        Interface.SIMULATION_COLORS[n2] = DIVERGING_COLORS[n2].get();
                        ++n2;
                    }
                    break;
                }
                case 1: {
                    SIMULATION_COLORS = new GamaColor[BASIC_COLORS.length];
                    int n3 = 0;
                    while (n3 < BASIC_COLORS.length) {
                        Interface.SIMULATION_COLORS[n3] = BASIC_COLORS[n3].get();
                        ++n3;
                    }
                    break;
                }
                case 2: {
                    SIMULATION_COLORS = new GamaColor[QUALITATIVE_COLORS.length];
                    int n4 = 0;
                    while (n4 < QUALITATIVE_COLORS.length) {
                        Interface.SIMULATION_COLORS[n4] = QUALITATIVE_COLORS[n4].get();
                        ++n4;
                    }
                    break;
                }
                default: {
                    Interface.setPivot(CORE_PIVOT_COLOR.getValue());
                }
            }
        }
    }

    public static class Modeling {
        public static final String NAME = "Editors";
        public static final String TEXT = "Edition";
        public static final String OPTIONS = "Options";
        public static final Pref<Boolean> WARNINGS_ENABLED = GamaPreferences.create("pref_editor_enable_warnings", "Show warning markers in the editor", true, 3, false).in("Editors", "Options").hidden();
        public static final Pref<Boolean> INFO_ENABLED = GamaPreferences.create("pref_editor_enable_infos", "Show information markers in the editor", true, 3, false).in("Editors", "Options").hidden();
        public static final Pref<Boolean> EDITOR_PERSPECTIVE_SAVE = GamaPreferences.create("pref_editor_perspective_save", "Save editors when switching perspectives", true, 3, false).in("Editors", "Options").activates("pref_editor_ask_save").withLabels("Yes", "No");
        public static final Pref<Boolean> EDITOR_SAVE = GamaPreferences.create("pref_editor_save_all", "Save editors before lauching an experiment", true, 3, false).in("Editors", "Options").activates("pref_editor_ask_save").withLabels("Yes", "No");
        public static final Pref<Boolean> EDITOR_SAVE_ASK = GamaPreferences.create("pref_editor_ask_save", "Ask before saving each file", false, 3, false).in("Editors", "Options");
        public static final Pref<Boolean> EDITOR_PERSPECTIVE_HIDE = GamaPreferences.create("pref_editor_perspective_hide", "Hide editors when switching to simulation perspective", true, 3, false).in("Editors", "Options").withLabels("Yes", "No");
        public static final Pref<Boolean> OPERATORS_MENU_SORT = GamaPreferences.create("pref_menu_operators_sort2", "Sort operators menu by", true, 4, false).withLabels("Category", "Name").in("Interface", "Menus").hidden();
        public static final Pref<Boolean> CORE_SURROUND_SELECTED = GamaPreferences.create("pref_editor_surround_selected", "Surround selected text with the matching character when { [ ( \" ' < is pressed", true, 3, false).in("Editors", "Edition").withLabels("Yes", "No");
        public static final Pref<Boolean> CORE_CLOSE_QUOTE = GamaPreferences.create("pref_editor_close_quote", "Automatically close single quotes \u2014 '..'", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> CORE_CLOSE_DOUBLE = GamaPreferences.create("pref_editor_close_double", "Automatically close double quotes \u2014 \"..\"", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> CORE_CLOSE_CURLY = GamaPreferences.create("pref_editor_close_curly", "Automatically close curly brackets \u2014 {..}", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> CORE_CLOSE_SQUARE = GamaPreferences.create("pref_editor_close_square", "Automatically close square brackets \u2014 [..]", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> CORE_CLOSE_PARENTHESES = GamaPreferences.create("pref_editor_close_parentheses", "Automatically close parentheses \u2014 (..)", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> EDITOR_CLEAN_UP = GamaPreferences.create("pref_editor_save_format", "Apply formatting on save", false, 3, false).in("Editors", "Options");
        public static final Pref<Boolean> EDITOR_DRAG_RESOURCES = GamaPreferences.create("pref_editor_drag_resources", "Drag files and resources as references in GAML files", true, 3, false).in("Editors", "Options");
        public static final Pref<GamaFont> EDITOR_BASE_FONT = GamaPreferences.create("pref_editor_font", "Font of editors", null, 19, false).in("Editors", "Edition");
        public static final Pref<GamaColor> EDITOR_BACKGROUND_COLOR = GamaPreferences.create("pref_editor_background_color", "Background color of editors", null, 6, false).in("Editors", "Edition");
        public static final Pref<Boolean> EDITOR_MARK_OCCURRENCES = GamaPreferences.create("pref_editor_mark_occurrences", "Mark occurrences of symbols", true, 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> EDITOR_EXPERIMENT_MENU = GamaPreferences.create("pref_editor_experiment_menu", "Display experiments as", false, 3, false).withLabels("Menu", "Buttons").deactivates("pref_editor_collapse_buttons").in("Editors", "Edition").withColors(GamaColor.get("white"), GamaColor.get("darkgray"));
        public static final Pref<Boolean> EDITOR_COLLAPSE_BUTTONS = GamaPreferences.create("pref_editor_collapse_buttons", "Use a menu when the buttons exceed the width of the editor", PlatformHelper.isLinux(), 3, false).in("Editors", "Edition");
        public static final Pref<Boolean> EDITOR_MINING = GamaPreferences.create("pref_editor_mining", "Inline errors, warnings and information messages", true, 3, false).in("Editors", "Edition");
    }

    public static class Network {
        public static final String NAME = "Network";
        public static final String SERVER = "Server mode";
        public static final String HTTP = "Http connections";
    }

    public static class Runtime {
        public static final String NAME = "Execution";
        public static final String EXECUTION = "Experiments";
        public static final Pref<Boolean> CORE_AUTO_RUN = GamaPreferences.create("pref_experiment_auto_run", "Auto-run experiments when they are launched", false, 3, true).in("Execution", "Experiments");
        public static final Pref<Boolean> CORE_ASK_CLOSING = GamaPreferences.create("pref_experiment_ask_closing", "Ask to close the previous experiment when launching a new one", true, 3, true).in("Execution", "Experiments");
        public static final Pref<Boolean> CORE_SLIDER_TYPE = GamaPreferences.create("pref_experiment_type_slider", "Incrementation of the step duration slider", true, 3, true).in("Execution", "Experiments").withLabels("Linear", "Logarithmic").withColors(GamaColor.get("white"), GamaColor.get("darkgray"));
        public static final Pref<Boolean> CORE_SYNC = GamaPreferences.create("pref_display_synchronized", "Synchronize outputs with the simulation", false, 3, true).in("Execution", "Experiments");
        public static final String PARAMETERS = "Parameters";
        public static final Pref<Boolean> CORE_EXPAND_PARAMS = GamaPreferences.create("pref_experiment_expand_params", "Automatically expand the parameters categories", false, 3, true).in("Execution", "Parameters");
        public static final Pref<Boolean> CORE_MONITOR_PARAMETERS = GamaPreferences.create("pref_monitors_in_parameters", "Display monitors in the parameters view", true, 3, true).in("Execution", "Parameters");
        public static final Pref<Boolean> CORE_RND_EDITABLE = GamaPreferences.create("pref_rng_in_parameters", "Include random number generation parameters in the parameters view", false, 3, true).in("Execution", "Parameters");
        public static final String CONCURRENCY = "Parallelism";
        public static final String TESTS = "Tests";
        public static final Pref<Boolean> TESTS_SORTED = GamaPreferences.create("pref_tests_sorted", "Sorts the results of tests by severity", false, 3, false).in("Execution", "Tests").withComment(", if true, aborted and failed tests are displayed first");
        public static final Pref<Boolean> START_TESTS = GamaPreferences.create("pref_start_tests", "Run tests at each start of the platform", false, 3, false).in("Execution", "Tests");
        public static final Pref<Boolean> USER_TESTS = GamaPreferences.create("pref_user_tests", "Include user-defined tests in the tests suite", false, 3, false).in("Execution", "Tests").withComment(", if true, will run user models with 'test' experiments");
        public static final Pref<Boolean> FAILED_TESTS = GamaPreferences.create("pref_failed_tests", "Only display failed and aborted tests", false, 3, true).in("Execution", "Tests").withComment(", if true, only aborted and failed tests are displayed");
        public static final String MEMORY = "Memory";
        public static final Pref<Boolean> CORE_MEMORY_POLLING = GamaPreferences.create("pref_check_memory", "Emit a warning when memory is low", true, 3, true).in("Execution", "Memory").activates("pref_memory_threshold", "pref_memory_frequency").hidden();
        public static final Pref<Integer> CORE_MEMORY_PERCENTAGE = GamaPreferences.create("pref_memory_threshold", "Emit a warning when the percentage of available memory is under", 20, 1, true).in("Execution", "Memory").between(Integer.valueOf(0), Integer.valueOf(100));
        public static final Pref<Integer> CORE_MEMORY_FREQUENCY = GamaPreferences.create("pref_memory_frequency", "Interval (in seconds) at which memory should be monitored", 2, 1, true).in("Execution", "Memory");
        public static final Pref<Boolean> CORE_MEMORY_ACTION = GamaPreferences.create("pref_memory_action", "When running out of memory in an experiment, GAMA should", true, 3, true).in("Execution", "Memory").withLabels("Close", "Exit");
        public static final String ERRORS = "Runtime errors";
        public static final Pref<Boolean> CORE_SHOW_ERRORS = GamaPreferences.create("pref_errors_display", "Show execution errors", true, 3, true).in("Execution", "Runtime errors").activates("pref_errors_number", "pref_errors_recent_first", "pref_display_show_errors");
        public static final Pref<Boolean> ERRORS_IN_DISPLAYS = GamaPreferences.create("pref_display_show_errors", "Show errors thrown in displays and outputs", false, 3, true).in("Execution", "Runtime errors");
        public static final Pref<Integer> CORE_ERRORS_NUMBER = GamaPreferences.create("pref_errors_number", "Number of errors to display", 10, 1, true).in("Execution", "Runtime errors").between(Integer.valueOf(1), null);
        public static final Pref<Boolean> CORE_RECENT = GamaPreferences.create("pref_errors_recent_first", "Display most recent first", true, 3, true).in("Execution", "Runtime errors").hidden();
        public static final Pref<Boolean> CORE_REVEAL_AND_STOP = GamaPreferences.create("pref_errors_stop", "Stop simulation at first error", true, 3, true).in("Execution", "Runtime errors");
        public static final Pref<Boolean> CORE_WARNINGS = GamaPreferences.create("pref_errors_warnings_errors", "Treat warnings as errors", false, 3, true).in("Execution", "Runtime errors");
        public static final Pref<Boolean> CORE_ERRORS_EDITOR_LINK = GamaPreferences.create("pref_errors_in_editor", "Show errors in editors", true, 3, true).in("Execution", "Runtime errors");
        public static final Pref<Boolean> CORE_SERVER_MODE = GamaPreferences.create("pref_enable_server", "Enable GAMA Server mode", true, 3, true).in("Network", "Server mode").activates("pref_server_port", "pref_server_ping", "pref_server_console");
        public static final Pref<Integer> CORE_SERVER_PORT = GamaPreferences.create("pref_server_port", "Port to which GAMA Server is listening", 1000, 1, true).in("Network", "Server mode");
        public static final Pref<Integer> CORE_SERVER_PING = GamaPreferences.create("pref_server_ping", "Interval between two pings (-1 to disable)", 10000, 1, true).in("Network", "Server mode");
        public static final Pref<Boolean> CORE_SERVER_CONSOLE = GamaPreferences.create("pref_server_console", "Send console outputs to clients", true, 3, true).in("Network", "Server mode");
    }

    public static class Theme {
        public static final String NAME = "Theme";
        public static final String UI = "UI";
        public static final String EDITOR = "Editor";
    }
}

