/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.continuous;

import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.AbstractTopology;
import gama.core.metamodel.topology.ITopology;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.gaml.operators.Maths;
import gama.gaml.types.IType;
import gama.gaml.types.Types;

public class ContinuousTopology
extends AbstractTopology {
    public ContinuousTopology(IScope iScope, IShape iShape) {
        super(iScope, iShape, null);
        this.places = GamaListFactory.wrap((IType)Types.GEOMETRY, iShape);
    }

    @Override
    public String stringValue(IScope iScope) throws GamaRuntimeException {
        return "Continuous topology in " + this.environment.toString();
    }

    @Override
    protected String _toGaml(boolean bl) {
        return "topology(" + this.environment.serializeToGaml(bl) + ")";
    }

    @Override
    protected ITopology _copy(IScope iScope) {
        return new ContinuousTopology(iScope, this.environment);
    }

    @Override
    public boolean isValidLocation(IScope iScope, GamaPoint gamaPoint) {
        return this.environment.covers(gamaPoint);
    }

    @Override
    public boolean isValidGeometry(IScope iScope, IShape iShape) {
        return this.environment.intersects(iShape);
    }

    @Override
    public Double directionInDegreesTo(IScope iScope, IShape iShape, IShape iShape2) {
        if (iShape == null || iShape2 == null) {
            return null;
        }
        GamaPoint gamaPoint = iShape.getLocation();
        GamaPoint gamaPoint2 = iShape2.getLocation();
        if (this.isTorus()) {
            gamaPoint = this.normalizeLocation(iScope, gamaPoint, false);
            gamaPoint2 = this.normalizeLocation(iScope, gamaPoint2, false);
        }
        double d = gamaPoint2.getX();
        double d2 = gamaPoint2.getY();
        double d3 = d - gamaPoint.getX();
        double d4 = d2 - gamaPoint.getY();
        double d5 = Maths.atan2(d4, d3);
        return Maths.checkHeading(d5);
    }

    @Override
    public boolean isContinuous() {
        return true;
    }

    @Override
    public Double distanceBetween(IScope iScope, IShape iShape, IShape iShape2) {
        if (iShape == iShape2) {
            return 0.0;
        }
        if (this.isTorus()) {
            return this.returnToroidalGeom(iShape).distance(this.returnToroidalGeom(iShape2));
        }
        return iShape.euclidianDistanceTo(iShape2);
    }

    @Override
    public Double distanceBetween(IScope iScope, GamaPoint gamaPoint, GamaPoint gamaPoint2) {
        if (gamaPoint == gamaPoint2) {
            return 0.0;
        }
        if (this.isTorus()) {
            return this.returnToroidalGeom(gamaPoint).distance(this.returnToroidalGeom(gamaPoint2));
        }
        return gamaPoint.euclidianDistanceTo(gamaPoint2);
    }
}

