/*
 * Decompiled with CFR 0.152.
 */
package gama.core.metamodel.topology.graph;

import gama.core.common.util.StringUtils;
import gama.core.metamodel.agent.IAgent;
import gama.core.metamodel.population.IPopulation;
import gama.core.metamodel.shape.GamaPoint;
import gama.core.metamodel.shape.IShape;
import gama.core.metamodel.topology.ITopology;
import gama.core.metamodel.topology.graph.GraphTopology;
import gama.core.metamodel.topology.graph.ISpatialGraph;
import gama.core.metamodel.topology.graph._SpatialEdge;
import gama.core.metamodel.topology.graph._SpatialVertex;
import gama.core.runtime.IScope;
import gama.core.runtime.exceptions.GamaRuntimeException;
import gama.core.util.GamaListFactory;
import gama.core.util.GamaMapFactory;
import gama.core.util.IContainer;
import gama.core.util.IList;
import gama.core.util.IMap;
import gama.core.util.graph.GamaGraph;
import gama.core.util.graph.GraphEvent;
import gama.core.util.path.GamaSpatialPath;
import gama.core.util.path.PathFactory;
import gama.dev.DEBUG;
import gama.gaml.species.ISpecies;
import gama.gaml.types.GamaGeometryType;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.Graphs;
import org.locationtech.jts.geom.Coordinate;

public class GamaSpatialGraph
extends GamaGraph<IShape, IShape>
implements ISpatialGraph,
IPopulation.Listener {
    private ITopology topology;
    private double tolerance = 0.0;
    private final Map<Integer, IShape> verticesBuilt = new HashMap<Integer, IShape>();

    public GamaSpatialGraph(IContainer iContainer, boolean bl, boolean bl2, boolean bl3, VertexRelationship vertexRelationship, ISpecies iSpecies, IScope iScope, IType iType, IType iType2) {
        this(iScope, iType, iType2);
        this.init(iScope, iContainer, bl, bl2, bl3, vertexRelationship, iSpecies);
    }

    public GamaSpatialGraph(IContainer iContainer, boolean bl, boolean bl2, boolean bl3, VertexRelationship vertexRelationship, ISpecies iSpecies, IScope iScope, IType iType, IType iType2, Double d) {
        this(iScope, iType, iType2);
        this.tolerance = d;
        this.init(iScope, iContainer, bl, bl2, bl3, vertexRelationship, iSpecies, d);
    }

    public GamaSpatialGraph(IContainer iContainer, IContainer iContainer2, IScope iScope) {
        this(iScope, iContainer2.getGamlType().getContentType(), iContainer.getGamlType().getContentType());
        this.init(iScope, iContainer, iContainer2);
    }

    public GamaSpatialGraph(IScope iScope, IType iType, IType iType2) {
        super(iScope, iType, iType2);
    }

    @Override
    public GamaSpatialGraph copy(IScope iScope) {
        GamaSpatialGraph gamaSpatialGraph = new GamaSpatialGraph(GamaListFactory.EMPTY_LIST, true, this.directed, false, this.vertexRelation, this.edgeSpecies, iScope, this.type.getKeyType(), this.type.getContentType());
        Graphs.addAllVertices((Graph)gamaSpatialGraph, (Collection)this.getVertices());
        Graphs.addAllEdges((Graph)gamaSpatialGraph, (Graph)this, (Collection)this.edgeSet());
        for (Object e : this.getVertices()) {
            gamaSpatialGraph.setVertexWeight(e, this.getWeightOf(e));
        }
        for (Object e : this.getEdges()) {
            gamaSpatialGraph.setEdgeWeight(e, this.getWeightOf(e));
        }
        return gamaSpatialGraph;
    }

    protected GamaSpatialPath pathFromEdges(IScope iScope, IShape iShape, IShape iShape2, IList<IShape> iList) {
        return PathFactory.newInstance(iScope, this.getTopology(iScope), iShape, iShape2, iList);
    }

    @Override
    protected void buildByVertices(IScope iScope, IContainer<?, IShape> iContainer, boolean bl) {
        Iterable<IShape> iterable = iContainer.iterable(iScope);
        for (IShape iShape : iterable) {
            super.addVertex(iShape);
        }
        System.out.println("uniqueEdge: " + bl);
        for (IShape iShape : iterable) {
            if (iShape.getAgent() != null) {
                iShape.getAgent().setAttribute("attached_graph", this);
            }
            for (IShape iShape2 : iterable) {
                if (this.vertexRelation.equivalent(iScope, iShape, iShape2) || !this.vertexRelation.related(iScope, iShape, iShape2) || bl && this.containsEdge(iShape2, iShape)) continue;
                this.addEdge(iShape, iShape2);
            }
        }
    }

    public _SpatialEdge getEdge(Object object) {
        return (_SpatialEdge)this.edgeMap.get(object);
    }

    public _SpatialVertex getVertex(Object object) {
        return (_SpatialVertex)this.vertexMap.get(object);
    }

    protected _SpatialEdge newEdge(Object object, Object object2, Object object3) throws GamaRuntimeException {
        return new _SpatialEdge(this, object, object2, object3);
    }

    protected _SpatialVertex newVertex(Object object) throws GamaRuntimeException {
        return new _SpatialVertex(this, object);
    }

    public boolean addVertex(IShape iShape) {
        boolean bl = super.addVertex(iShape);
        if (bl && this.vertexRelation != null) {
            for (IShape iShape2 : this.vertexSet()) {
                if (this.vertexRelation.equivalent(this.graphScope, iShape, iShape2) || !this.vertexRelation.related(this.graphScope, iShape, iShape2)) continue;
                this.addEdge(iShape, iShape2);
            }
        }
        return bl;
    }

    @Override
    public ITopology getTopology(IScope iScope) {
        if (this.topology == null) {
            this.setTopology(new GraphTopology(iScope, this));
        }
        return this.topology;
    }

    protected void setTopology(ITopology iTopology) {
        this.topology = iTopology;
    }

    private void refreshEdges() {
        Set<IShape> set = this.vertexSet();
        DEBUG.OUT((Object)("Refreshing Edges " + String.valueOf(this.edgeSpecies)));
        for (IShape iShape : set) {
            for (IShape iShape2 : set) {
                if (this.graphScope.interrupted()) {
                    return;
                }
                if (this.vertexRelation.equivalent(this.graphScope, iShape, iShape2)) continue;
                boolean bl = this.containsEdge(iShape, iShape2);
                boolean bl2 = this.vertexRelation.related(this.graphScope, iShape, iShape2);
                if (bl2 && !bl) {
                    this.addEdge(iShape, iShape2);
                    continue;
                }
                if (!bl || bl2) continue;
                this.removeEdge(iShape, iShape2);
            }
        }
    }

    @Override
    protected Object generateEdgeObject(Object object, Object object2) {
        if (object instanceof IShape && object2 instanceof IShape) {
            return GamaGeometryType.buildLink(this.graphScope, (IShape)object, (IShape)object2);
        }
        return super.generateEdgeObject(object, object2);
    }

    public void notifyAgentRemoved(IScope iScope, IPopulation iPopulation, IAgent iAgent) {
        this.removeVertex(iAgent);
    }

    public void notifyAgentAdded(IScope iScope, IPopulation iPopulation, IAgent iAgent) {
        this.addVertex(iAgent);
    }

    public void notifyAgentsAdded(IScope iScope, IPopulation iPopulation, Collection collection) {
        for (Object e : collection) {
            this.addVertex((IAgent)e);
        }
    }

    public void notifyAgentsRemoved(IScope iScope, IPopulation iPopulation, Collection collection) {
        for (Object e : collection) {
            this.removeVertex(e);
        }
    }

    public void notifyPopulationCleared(IScope iScope, IPopulation iPopulation) {
        this.removeAllVertices(this.vertexSet());
    }

    public void postRefreshManagementAction(IScope iScope2) {
        iScope2.getSimulation().postEndAction(iScope -> {
            this.refreshEdges();
            return null;
        });
    }

    @Override
    public Set<IShape> vertexSet() {
        return this.vertexMap.keySet();
    }

    public void addBuiltVertex(IShape iShape) {
        this.verticesBuilt.put(iShape.getLocation().hashCode(), iShape);
    }

    public IShape getBuiltVertex(Coordinate coordinate) {
        if (this.tolerance == 0.0) {
            return this.verticesBuilt.get(coordinate.hashCode());
        }
        IShape iShape = this.verticesBuilt.get(coordinate.hashCode());
        if (iShape != null) {
            return iShape;
        }
        for (IShape iShape2 : this.verticesBuilt.values()) {
            if (!(coordinate.distance3D((Coordinate)iShape2.getLocation()) <= this.tolerance)) continue;
            return iShape2;
        }
        return null;
    }

    protected void buildByEdgeWithNode(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        IMap iMap = GamaMapFactory.create(Types.POINT, this.getGamlType().getKeyType());
        for (Object ValueType : iContainer2.iterable(iScope)) {
            super.addVertex(ValueType);
            iMap.put(((IShape)ValueType).getLocation(), (IShape)ValueType);
        }
        for (Object ValueType : iContainer.iterable(iScope)) {
            boolean bl = this.addEdgeWithNodes(iScope, (IShape)ValueType, iMap);
            if (!bl) continue;
            this.getEdge(ValueType).setWeight(((IShape)ValueType).getPerimeter());
        }
    }

    public boolean addEdgeWithNodes(IScope iScope, IShape iShape, IMap<GamaPoint, IShape> iMap) {
        _SpatialEdge _SpatialEdge2;
        if (this.containsEdge(iShape)) {
            return false;
        }
        Coordinate[] coordinateArray = iShape.getInnerGeometry().getCoordinates();
        GamaPoint gamaPoint = new GamaPoint(coordinateArray[0]);
        GamaPoint gamaPoint2 = new GamaPoint(coordinateArray[coordinateArray.length - 1]);
        IShape iShape2 = (IShape)iMap.get(gamaPoint);
        if (iShape2 == null) {
            return false;
        }
        IShape iShape3 = (IShape)iMap.get(gamaPoint2);
        if (iShape3 == null) {
            return false;
        }
        this.addVertex(iShape2);
        this.addVertex(iShape3);
        try {
            _SpatialEdge2 = this.newEdge(iShape, iShape2, iShape3);
        }
        catch (GamaRuntimeException gamaRuntimeException) {
            gamaRuntimeException.addContext("Impossible to create edge from " + StringUtils.toGaml(iShape, false) + " in graph " + String.valueOf(this));
            throw gamaRuntimeException;
        }
        this.edgeMap.put(iShape, _SpatialEdge2);
        this.dispatchEvent(iScope, new GraphEvent(iScope, this, iShape, null, GraphEvent.GraphEventType.EDGE_ADDED));
        return true;
    }

    protected void init(IScope iScope, IContainer iContainer, IContainer iContainer2) {
        this.directed = true;
        this.vertexRelation = null;
        this.edgeSpecies = null;
        this.agentEdge = true;
        this.buildByEdgeWithNode(iScope, iContainer, iContainer2);
    }

    @Override
    public ISpecies getSpecies() {
        return this.getEdgeSpecies();
    }

    @Override
    public IPopulation<? extends IAgent> getPopulation(IScope iScope) {
        return this.getScope().getSimulation().getPopulationFor(this.getSpecies());
    }

    @Override
    public IContainer<?, ? extends IAgent> getAgents(IScope iScope) {
        return this.getEdges();
    }

    @Override
    public boolean hasAgentList() {
        return true;
    }

    @Override
    public boolean accept(IScope iScope, IShape iShape, IShape iShape2) {
        return iShape2.getGeometry() != iShape.getGeometry() && this.containsEdge(iShape2);
    }

    @Override
    public void filter(IScope iScope, IShape iShape2, Collection<? extends IShape> collection) {
        collection.removeIf(iShape -> !this.edgeMap.containsKey(iShape));
    }

    public double getTolerance() {
        return this.tolerance;
    }

    public void setTolerance(double d) {
        this.tolerance = d;
    }

    public static interface VertexRelationship<T> {
        public boolean related(IScope var1, T var2, T var3);

        public boolean equivalent(IScope var1, T var2, T var3);
    }
}

