/*
 * Decompiled with CFR 0.152.
 */
package gama.core.outputs.layers.charts;

import gama.core.outputs.display.AbstractDisplayGraphics;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputBoxAndWhiskerCategory;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputHeatmap;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputHistogram;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputPie;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputRadar;
import gama.core.outputs.layers.charts.ChartJFreeChartOutputScatter;
import gama.core.outputs.layers.charts.ChartOutput;
import gama.core.runtime.IScope;
import gama.gaml.expressions.IExpression;
import gama.gaml.operators.Cast;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.jfree.chart.ChartRenderingInfo;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.block.BlockBorder;
import org.jfree.chart.block.BlockFrame;
import org.jfree.chart.event.ChartProgressEvent;
import org.jfree.chart.event.ChartProgressListener;
import org.jfree.chart.plot.DefaultDrawingSupplier;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.renderer.AbstractRenderer;
import org.jfree.chart.renderer.xy.XYErrorRenderer;
import org.jfree.data.general.Dataset;

public class ChartJFreeChartOutput
extends ChartOutput
implements ChartProgressListener {
    Object lock = new Object();
    public static final Shape[] defaultmarkers = DefaultDrawingSupplier.createStandardSeriesShapes();
    boolean oldAntiAlias;
    public final ChartRenderingInfo info;
    final List<Dataset> jfreedataset = new ArrayList<Dataset>();
    JFreeChart chart = null;
    final Rectangle2D area = new Rectangle2D.Double();
    BufferedImage frontImage;
    BufferedImage backImage;
    AbstractRenderer defaultrenderer;
    final HashMap<String, Integer> idPosition = new HashMap();
    final HashMap<String, AbstractRenderer> rendererSet = new HashMap();
    int nbseries = 0;

    public ChartJFreeChartOutput(IScope iScope, String string, IExpression iExpression) {
        super(iScope, string, iExpression);
        this.info = new ChartRenderingInfo();
    }

    public static ChartJFreeChartOutput createChartOutput(IScope iScope, String string, IExpression iExpression) {
        block19: {
            String string2;
            IExpression iExpression2 = iExpression;
            if (iExpression2 == null) break block19;
            return switch (string2 = Cast.asString(iScope, iExpression2.value(iScope))) {
                case "histogram" -> new ChartJFreeChartOutputHistogram(iScope, string, iExpression);
                case "pie" -> new ChartJFreeChartOutputPie(iScope, string, iExpression);
                case "radar" -> new ChartJFreeChartOutputRadar(iScope, string, iExpression);
                case "heatmap" -> new ChartJFreeChartOutputHeatmap(iScope, string, iExpression);
                case "box_whisker" -> new ChartJFreeChartOutputBoxAndWhiskerCategory(iScope, string, iExpression);
                default -> new ChartJFreeChartOutputScatter(iScope, string, iExpression);
            };
        }
        return new ChartJFreeChartOutputScatter(iScope, string, iExpression);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BufferedImage getImage(int n, int n2, boolean bl) {
        this.adjustImage(n, n2, bl);
        Graphics2D graphics2D = this.backImage.createGraphics();
        try {
            try {
                Object object = this.lock;
                synchronized (object) {
                    this.chart.draw(graphics2D, this.area, this.info);
                }
            }
            catch (IllegalArgumentException | IndexOutOfBoundsException | NullPointerException runtimeException) {
                graphics2D.dispose();
            }
        }
        finally {
            graphics2D.dispose();
        }
        return this.frontImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void chartProgress(ChartProgressEvent chartProgressEvent) {
        if (chartProgressEvent.getType() == 2) {
            Object object = this.lock;
            synchronized (object) {
                BufferedImage bufferedImage = this.backImage;
                this.backImage = this.frontImage;
                this.frontImage = bufferedImage;
            }
        }
    }

    private void adjustImage(int n, int n2, boolean bl) {
        if (bl != this.oldAntiAlias) {
            this.oldAntiAlias = bl;
            this.chart.setAntiAlias(bl);
            this.chart.setTextAntiAlias(bl);
        }
        if ((int)this.area.getWidth() != n || (int)this.area.getHeight() != n2) {
            this.area.setRect(0.0, 0.0, n, n2);
            this.frontImage = AbstractDisplayGraphics.createCompatibleImage(n, n2);
            this.backImage = AbstractDisplayGraphics.createCompatibleImage(n, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void step(IScope iScope) {
        Object object = this.lock;
        synchronized (object) {
            super.step(iScope);
        }
    }

    protected void initRenderer(IScope iScope) {
    }

    @Override
    public void initChart(IScope iScope, String string) {
        super.initChart(iScope, string);
        this.initRenderer(iScope);
        Plot plot = this.chart.getPlot();
        this.chart.addProgressListener((ChartProgressListener)this);
        this.chart.setBorderVisible(false);
        plot.setOutlineVisible(false);
        this.chart.setTitle(this.getName());
        this.chart.getTitle().setVisible(true);
        this.chart.getTitle().setFont(this.getTitleFont());
        if (!this.getTitleVisible(iScope)) {
            this.chart.getTitle().setVisible(false);
        }
        if (this.textColor != null) {
            this.chart.getTitle().setPaint((Paint)this.textColor);
        }
        if (this.backgroundColor == null) {
            plot.setBackgroundPaint(null);
            this.chart.setBackgroundPaint(null);
            this.chart.setBorderPaint(null);
            if (this.chart.getLegend() != null) {
                this.chart.getLegend().setBackgroundPaint(null);
            }
        } else {
            Color color = this.backgroundColor;
            this.chart.setBackgroundPaint((Paint)color);
            plot.setBackgroundPaint((Paint)color);
            this.chart.setBorderPaint((Paint)color);
            if (this.chart.getLegend() != null) {
                this.chart.getLegend().setBackgroundPaint((Paint)color);
            }
        }
        if (this.chart.getLegend() != null) {
            this.chart.getLegend().setItemFont(this.getLegendFont());
            this.chart.getLegend().setFrame((BlockFrame)BlockBorder.NONE);
            if (this.textColor != null) {
                this.chart.getLegend().setItemPaint((Paint)this.textColor);
            }
        }
    }

    AbstractRenderer getOrCreateRenderer(IScope iScope, String string) {
        if (this.rendererSet.containsKey(string)) {
            return this.rendererSet.get(string);
        }
        AbstractRenderer abstractRenderer = this.createRenderer(iScope, string);
        this.rendererSet.put(string, abstractRenderer);
        return abstractRenderer;
    }

    protected AbstractRenderer createRenderer(IScope iScope, String string) {
        return new XYErrorRenderer();
    }

    Font getLabelFont() {
        return new Font(this.labelFontFace, this.labelFontStyle, this.labelFontSize);
    }

    Font getTickFont() {
        return new Font(this.tickFontFace, this.tickFontStyle, this.tickFontSize);
    }

    Font getLegendFont() {
        return new Font(this.legendFontFace, this.legendFontStyle, this.legendFontSize);
    }

    Font getTitleFont() {
        return new Font(this.titleFontFace, this.titleFontStyle, this.titleFontSize);
    }

    @Override
    public JFreeChart getJFChart() {
        return this.chart;
    }

    @Override
    public void dispose(IScope iScope) {
        if (this.frontImage != null) {
            this.frontImage.flush();
        }
        if (this.backImage != null) {
            this.backImage.flush();
        }
        this.backImage = null;
        this.frontImage = null;
        this.clearDataSet(iScope);
        this.jfreedataset.clear();
        this.chart = null;
    }
}

