/*
 * Decompiled with CFR 0.152.
 */
package gama.core.util.file.json;

class HashIndexTable {
    private final byte[] hashTable = new byte[32];

    HashIndexTable() {
    }

    HashIndexTable(HashIndexTable hashIndexTable) {
        System.arraycopy(hashIndexTable.hashTable, 0, this.hashTable, 0, this.hashTable.length);
    }

    void add(String string, int n) {
        int n2 = this.hashSlotFor(string);
        this.hashTable[n2] = n < 255 ? (byte)(n + 1) : (byte)0;
    }

    void remove(int n) {
        int n2 = 0;
        while (n2 < this.hashTable.length) {
            if ((this.hashTable[n2] & 0xFF) == n + 1) {
                this.hashTable[n2] = 0;
            } else if ((this.hashTable[n2] & 0xFF) > n + 1) {
                int n3 = n2;
                this.hashTable[n3] = (byte)(this.hashTable[n3] - 1);
            }
            ++n2;
        }
    }

    int get(Object object) {
        int n = this.hashSlotFor(object);
        return (this.hashTable[n] & 0xFF) - 1;
    }

    private int hashSlotFor(Object object) {
        return object.hashCode() & this.hashTable.length - 1;
    }
}

