/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.compilation;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import gama.gaml.compilation.GAML;
import gama.gaml.compilation.kernel.GamaSkillRegistry;
import gama.gaml.descriptions.ActionDescription;
import gama.gaml.descriptions.FacetProto;
import gama.gaml.descriptions.OperatorProto;
import gama.gaml.descriptions.SkillDescription;
import gama.gaml.descriptions.SpeciesDescription;
import gama.gaml.descriptions.SymbolProto;
import gama.gaml.descriptions.TypeDescription;
import gama.gaml.descriptions.VariableDescription;
import gama.gaml.expressions.units.UnitConstantExpression;
import gama.gaml.factories.DescriptionFactory;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.interfaces.INamed;
import gama.gaml.operators.Strings;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class GamlIdiomsProvider<T extends IGamlDescription> {
    public static final int NOT_FOUND = -1;
    public static final GamlIdiomsProvider<SpeciesDescription> SPECIES = new GamlIdiomsProvider<SpeciesDescription>("species", "Built-in species", Types.getBuiltInSpecies().values());
    public static final GamlIdiomsProvider<VariableDescription> SPECIES_ATTRIBUTES = new GamlIdiomsProvider("variables", "Built-in species attribute", Iterables.concat((Iterable)Iterables.transform(Types.getBuiltInSpecies().values(), TypeDescription::getOwnAttributes)));
    public static final GamlIdiomsProvider<ActionDescription> SPECIES_ACTIONS = new GamlIdiomsProvider("actions", "Built-in species action", Iterables.concat((Iterable)Iterables.transform(Types.getBuiltInSpecies().values(), TypeDescription::getOwnActions)));
    public static final GamlIdiomsProvider<SkillDescription> SKILLS = new GamlIdiomsProvider<SkillDescription>("skills", "Skill", GamaSkillRegistry.INSTANCE.getRegisteredSkills());
    public static final GamlIdiomsProvider<VariableDescription> SKILLS_ATTRIBUTES = new GamlIdiomsProvider<VariableDescription>("variables", "Skill Attribute", GamaSkillRegistry.INSTANCE.getRegisteredSkillsAttributes());
    public static final GamlIdiomsProvider<ActionDescription> SKILLS_ACTIONS = new GamlIdiomsProvider<ActionDescription>("actions", "Skill Action", GamaSkillRegistry.INSTANCE.getRegisteredSkillsActions());
    public static final GamlIdiomsProvider<SymbolProto> STATEMENTS = new GamlIdiomsProvider<SymbolProto>("statements", "Statements", DescriptionFactory.getStatementProtos());
    public static final GamlIdiomsProvider<UnitConstantExpression> CONSTANTS = new GamlIdiomsProvider<UnitConstantExpression>("constant", "Constant & Units", GAML.UNITS.values());
    public static final GamlIdiomsProvider<OperatorProto> OPERATORS = new GamlIdiomsProvider("operators", "Operators", Iterables.concat((Iterable)Iterables.transform(GAML.OPERATORS.values(), Map::values)));
    public static final GamlIdiomsProvider<IType<?>> TYPES = new GamlIdiomsProvider("types", "Types", Types.builtInTypes.getAllTypes());
    public static final GamlIdiomsProvider<FacetProto> FACETS = new GamlIdiomsProvider<FacetProto>("facets", "Facets", DescriptionFactory.getFacetsProtos());
    public static final GamlIdiomsProvider<OperatorProto> FIELDS = new GamlIdiomsProvider<OperatorProto>("attributes", "Fields", Types.getAllFields());
    public static final List<GamlIdiomsProvider<?>> PROVIDERS = Arrays.asList(SPECIES, SPECIES_ATTRIBUTES, SPECIES_ACTIONS, SKILLS, SKILLS_ATTRIBUTES, SKILLS_ACTIONS, STATEMENTS, CONSTANTS, OPERATORS, TYPES, FACETS, FIELDS);
    public final String name;
    public final String search;
    public final Iterable<? extends T> elements;
    public final Map<T, String> titles;
    public IGamlDescription[] sortedElements;
    public Multimap<String, ? extends T> byName;
    public Function<T, IGamlDescription.Doc> documenter = IGamlDescription::getDocumentation;
    private static String[] HTML_TAGS = new String[]{"<br/>", "<br>", "<b>", "</b>", "<i>", "</i>", "<ul>", "</ul>", "<li>", "</li>"};
    private static String[] REPLACEMENTS = new String[]{Strings.LN, Strings.LN, "", "", "", "", "", "", Strings.LN + "- ", ""};

    public GamlIdiomsProvider(String string, String string2, Iterable<? extends T> iterable) {
        this(string, string2, iterable, null);
    }

    public GamlIdiomsProvider(String string, String string2, Iterable<? extends T> iterable, Map<T, String> map) {
        this.search = string;
        this.name = string2;
        this.elements = iterable;
        this.titles = map;
    }

    public String document(IGamlDescription iGamlDescription) {
        return this.documenter.apply(iGamlDescription).toString();
    }

    public GamlIdiomsProvider<T> withStringProvider(Function<T, String> function) {
        this.documenter = iGamlDescription -> new IGamlDescription.ConstantDoc((String)function.apply(iGamlDescription));
        return this;
    }

    public String getSearchCategory() {
        return this.search;
    }

    public Collection<? extends T> get(String string) {
        if (this.byName == null) {
            this.init();
        }
        return this.byName.get((Object)string);
    }

    public IGamlDescription[] getSortedElements() {
        if (this.sortedElements == null) {
            this.init();
        }
        return this.sortedElements;
    }

    private void init() {
        this.sortedElements = (IGamlDescription[])Iterables.toArray(this.elements, IGamlDescription.class);
        if (this.titles == null) {
            Arrays.sort(this.sortedElements, Comparator.comparing(IGamlDescription::getTitle));
        } else {
            Arrays.sort(this.sortedElements, (iGamlDescription, iGamlDescription2) -> this.titles.get(iGamlDescription).compareTo(this.titles.get(iGamlDescription2)));
        }
        this.byName = Multimaps.index(this.elements, INamed::getName);
    }

    public static Multimap<GamlIdiomsProvider<?>, IGamlDescription> forName(String string) {
        ArrayListMultimap arrayListMultimap = ArrayListMultimap.create();
        for (GamlIdiomsProvider<?> gamlIdiomsProvider : PROVIDERS) {
            arrayListMultimap.replaceValues(gamlIdiomsProvider, gamlIdiomsProvider.get(string));
        }
        return arrayListMultimap;
    }

    public static String getDocumentationOn(String string) {
        String string2 = StringUtils.removeEnd((String)StringUtils.removeStart((String)string.trim(), (String)"#"), (String)":");
        Multimap<GamlIdiomsProvider<?>, IGamlDescription> multimap = GamlIdiomsProvider.forName(string2);
        if (multimap.isEmpty()) {
            return "No result found";
        }
        StringBuilder stringBuilder = new StringBuilder();
        int n = multimap.keySet().stream().mapToInt(gamlIdiomsProvider -> gamlIdiomsProvider.name.length()).max().getAsInt();
        String string3 = StringUtils.repeat((String)"\u2014", (int)(n + 6)).concat(Strings.LN);
        multimap.asMap().forEach((gamlIdiomsProvider, collection) -> {
            stringBuilder.append("").append(string3).append("|| ");
            stringBuilder.append(StringUtils.rightPad((String)gamlIdiomsProvider.name, (int)n));
            stringBuilder.append(" ||").append(Strings.LN).append(string3);
            for (IGamlDescription iGamlDescription : collection) {
                stringBuilder.append("== ").append(GamlIdiomsProvider.toText(iGamlDescription.getTitle())).append(Strings.LN).append(GamlIdiomsProvider.toText(gamlIdiomsProvider.document(iGamlDescription))).append(Strings.LN);
            }
        });
        return stringBuilder.toString();
    }

    public static String toText(String string) {
        if (string == null) {
            return "";
        }
        return GamlIdiomsProvider.breakStringToLines(StringUtils.replaceEach((String)string, (String[])HTML_TAGS, (String[])REPLACEMENTS), 120, Strings.LN);
    }

    public static int lastIndexOfRegex(String string, String string2) {
        Pattern pattern = Pattern.compile(string2);
        Matcher matcher = pattern.matcher(string);
        int n = -1;
        while (matcher.find()) {
            n = matcher.start();
        }
        return n;
    }

    public static int lastIndexOfRegex(String string, String string2, int n) {
        return GamlIdiomsProvider.lastIndexOfRegex(string.substring(0, n), string2);
    }

    public static String breakStringToLines(String string, int n, String string2) {
        String string3 = string;
        StringBuilder stringBuilder = new StringBuilder();
        while (string3.length() > n) {
            int n2 = GamlIdiomsProvider.lastIndexOfRegex(string3, "\\s", n);
            if (n2 == -1) {
                n2 = GamlIdiomsProvider.lastIndexOfRegex(string3, "[^a-zA-Z0-9]", n);
            }
            if (n2 == -1) {
                n2 = n;
            }
            stringBuilder.append(string3.substring(0, n2 + 1));
            stringBuilder.append(string2);
            string3 = string3.substring(n2 + 1);
        }
        if (string3.length() > 0) {
            stringBuilder.append(string3);
        }
        return stringBuilder.toString();
    }
}

