/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.expressions.units;

import gama.annotations.precompiler.GamlProperties;
import gama.core.runtime.IScope;
import gama.gaml.descriptions.IDescription;
import gama.gaml.descriptions.IExpressionDescription;
import gama.gaml.descriptions.LabelExpressionDescription;
import gama.gaml.expressions.ConstantExpression;
import gama.gaml.expressions.IExpression;
import gama.gaml.expressions.units.CameraOrientationUnitExpression;
import gama.gaml.expressions.units.CameraPositionUnitExpression;
import gama.gaml.expressions.units.CameraTargetUnitExpression;
import gama.gaml.expressions.units.CurrentErrorUnitExpression;
import gama.gaml.expressions.units.DisplayHeightUnitExpression;
import gama.gaml.expressions.units.DisplayWidthUnitExpression;
import gama.gaml.expressions.units.FullScreenExpression;
import gama.gaml.expressions.units.HiDPIExpression;
import gama.gaml.expressions.units.NowUnitExpression;
import gama.gaml.expressions.units.PixelUnitExpression;
import gama.gaml.expressions.units.TimeUnitConstantExpression;
import gama.gaml.expressions.units.UserLocationInDisplayUnitExpression;
import gama.gaml.expressions.units.UserLocationUnitExpression;
import gama.gaml.expressions.units.ZoomUnitExpression;
import gama.gaml.interfaces.IGamlDescription;
import gama.gaml.types.IType;
import gama.gaml.types.Types;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;

public class UnitConstantExpression
extends ConstantExpression
implements IExpressionDescription {
    String name;
    IGamlDescription.Doc documentation;
    final List<String> alternateNames;
    private boolean isDeprecated;

    public static UnitConstantExpression create(Object object, IType<?> iType, String string, String string2, boolean bl, String[] stringArray) {
        switch (string) {
            case "zoom": {
                return new ZoomUnitExpression(string, string2);
            }
            case "fullscreen": {
                return new FullScreenExpression(string, string2);
            }
            case "hidpi": {
                return new HiDPIExpression(string, string2);
            }
            case "pixels": 
            case "px": {
                return new PixelUnitExpression(string, string2);
            }
            case "display_width": {
                return new DisplayWidthUnitExpression(string2);
            }
            case "display_height": {
                return new DisplayHeightUnitExpression(string2);
            }
            case "now": {
                return new NowUnitExpression(string, string2);
            }
            case "camera_location": {
                return new CameraPositionUnitExpression(string2);
            }
            case "camera_target": {
                return new CameraTargetUnitExpression(string2);
            }
            case "camera_orientation": {
                return new CameraOrientationUnitExpression(string2);
            }
            case "user_location_in_world": 
            case "user_location": {
                return new UserLocationUnitExpression(string, string2);
            }
            case "user_location_in_display": {
                return new UserLocationInDisplayUnitExpression(string2);
            }
            case "current_error": {
                return new CurrentErrorUnitExpression(string2);
            }
        }
        if (bl) {
            return new TimeUnitConstantExpression(object, iType, string, string2, stringArray);
        }
        return new UnitConstantExpression(object, iType, string, string2, stringArray);
    }

    public UnitConstantExpression(Object object, IType<?> iType, String string, String string2, String[] stringArray) {
        super(object, iType);
        this.name = string;
        this.documentation = new IGamlDescription.ConstantDoc(string2);
        this.alternateNames = new ArrayList<String>();
        this.alternateNames.add(string);
        if (stringArray != null) {
            this.alternateNames.addAll(Arrays.asList(stringArray));
        }
    }

    @Override
    public String serializeToGaml(boolean bl) {
        return "#" + this.name;
    }

    @Override
    public IGamlDescription.Doc getDocumentation() {
        return this.documentation;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public String getTitle() {
        String string = this.type.equals(Types.COLOR) ? "Constant color " : (this.getClass().equals(UnitConstantExpression.class) ? "Constant " : "Mutable value ");
        StringBuilder stringBuilder = new StringBuilder().append(string).append(this.serializeToGaml(false));
        if (this.alternateNames.size() > 1) {
            stringBuilder.append(" (").append(this.alternateNames).append(")");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean shouldBeParenthesized() {
        return false;
    }

    @Override
    public void collectMetaInformation(GamlProperties gamlProperties) {
        gamlProperties.put("constants", this.name);
    }

    @Override
    public void setExpression(IExpression iExpression) {
    }

    @Override
    public IExpression compile(IDescription iDescription) {
        return this.getExpression();
    }

    @Override
    public IExpression getExpression() {
        return this;
    }

    @Override
    public IExpressionDescription compileAsLabel() {
        return LabelExpressionDescription.create(this.name);
    }

    @Override
    public boolean equalsString(String string) {
        return this.name.equals(string);
    }

    @Override
    public EObject getTarget() {
        return null;
    }

    @Override
    public void setTarget(EObject eObject) {
    }

    public Set<String> getStrings(IDescription iDescription, boolean bl) {
        return Collections.EMPTY_SET;
    }

    @Override
    public IExpressionDescription cleanCopy() {
        return this;
    }

    @Override
    public IType<?> getDenotedType(IDescription iDescription) {
        return Types.NO_TYPE;
    }

    public void setDeprecated(String string) {
        this.isDeprecated = true;
        this.documentation.prepend("Deprecated: " + string + ". ");
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    @Override
    public IExpression resolveAgainst(IScope iScope) {
        return this.getExpression();
    }
}

