/*
 * Decompiled with CFR 0.152.
 */
package gama.gaml.statements;

import gama.annotations.precompiler.GamlAnnotations;
import gama.gaml.compilation.IDescriptionValidator;
import gama.gaml.compilation.annotations.validator;
import gama.gaml.descriptions.IDescription;
import gama.gaml.statements.AbstractPlaceHolderStatement;

@GamlAnnotations.facets(value={@GamlAnnotations.facet(name="name", type={-204}, optional=false, doc={@GamlAnnotations.doc(value="the name of the action argument ")}), @GamlAnnotations.facet(name="type", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the type of the action argument (only in an action statement)")}), @GamlAnnotations.facet(name="of", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the type of the content of the argument, if its type is a container (only in an action statement)")}), @GamlAnnotations.facet(name="index", type={-202}, optional=true, doc={@GamlAnnotations.doc(value="the type of the key of the argument, if its type is a map (only in an action statement)")}), @GamlAnnotations.facet(name="optional", type={3}, optional=true, doc={@GamlAnnotations.doc(value="a boolean specifying if the argument is optional (false by default) (only in an action statement)")}), @GamlAnnotations.facet(name="value", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the value of the argument (only in a do statement)")}), @GamlAnnotations.facet(name="id", type={3}, internal=true, optional=true, doc={@GamlAnnotations.doc(value="whether the argument is to be treated as an id or as a value")}), @GamlAnnotations.facet(name="default", type={0}, optional=true, doc={@GamlAnnotations.doc(value="the default value of the argument (only in an action statement)")})}, omissible="name")
@GamlAnnotations.inside(symbols={"action", "do", "invoke"})
@validator(value=IDescriptionValidator.ValidNameValidator.class)
@GamlAnnotations.doc(value="Argument ", usages={@GamlAnnotations.usage(value="In an action, it is used to define the paramaters of the action. Facets type:, optional: and default: can be used in this case to characterize the arguments.", examples={@GamlAnnotations.example(value="action swap {", isExecutable=false), @GamlAnnotations.example(value="\t\targ arg1 type: int default: 3;", isExecutable=false), @GamlAnnotations.example(value="\targ arg2 type: int optional: true;", isExecutable=false), @GamlAnnotations.example(value="\t// ....", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)}), @GamlAnnotations.usage(value="In the call of an action, i.e. in a do statement, it is used to explicit the values given to arguments. Facets value: cna be used in this case.", examples={@GamlAnnotations.example(value="int val1 <- 5;", isExecutable=false), @GamlAnnotations.example(value="do swap {", isExecutable=false), @GamlAnnotations.example(value="\t\targ arg1 value: 7;", isExecutable=false), @GamlAnnotations.example(value="\targ arg2 value: val1 ;", isExecutable=false), @GamlAnnotations.example(value="}", isExecutable=false)})}, see={"action", "do"})
public class ArgStatement
extends AbstractPlaceHolderStatement {
    public ArgStatement(IDescription iDescription) {
        super(iDescription);
    }
}

